/* OtBbN֌W */

#define AA_LEVEL	0
#define USE_AA		0

#include "bootpack.h"
#include "../version.h"

static unsigned char table_rgb[16 * 3] = {
	0x00, 0x00, 0x00,	/*  0: */
	0xff, 0x00, 0x00,	/*  1:邢 */
	0x00, 0xff, 0x00,	/*  2:邢 */
	0xff, 0xff, 0x00,	/*  3:邢F */
	0x00, 0x00, 0xff,	/*  4:邢 */
	0xff, 0x00, 0xff,	/*  5:邢 */
	0x00, 0xff, 0xff,	/*  6:邢F */
	0xff, 0xff, 0xff,	/*  7: */
	0xc0, 0xc0, 0xc0,	/*  8:邢DF */
	0x84, 0x00, 0x00,	/*  9:Â */
	0x00, 0x84, 0x00,	/* 10:Â */
	0x84, 0x84, 0x00,	/* 11:ÂF */
	0x00, 0x00, 0x84,	/* 12:Â */
	0x84, 0x00, 0x84,	/* 13:Â */
	0x00, 0x84, 0x84,	/* 14:ÂF */
	0x84, 0x84, 0x84	/* 15:ÂDF */
};

unsigned char table2[216 * 3];
unsigned int table_8_888[256];

void init_palette(void)
{
	int r, g, b;
	int i;
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	
	if(binfo->vmode == 8) set_palette(0, 15, table_rgb);
	for (b = 0; b < 6; b++) {
		for (g = 0; g < 6; g++) {
			for (r = 0; r < 6; r++) {
				table2[(r + g * 6 + b * 36) * 3 + 0] = r * 51;
				table2[(r + g * 6 + b * 36) * 3 + 1] = g * 51;
				table2[(r + g * 6 + b * 36) * 3 + 2] = b * 51;
			}
		}
	}
	for (i = 0; i < 16; i++) {
		r = table_rgb[i * 3 + 0];
		g = table_rgb[i * 3 + 1];
		b = table_rgb[i * 3 + 2];
		table_8_888[i] = (((r & 0xff) << 16) | ((g & 0xff) << 8) | (b & 0xff));
	}
	for (b = 0; b < 6; b++) {
		for (g = 0; g < 6; g++) {
			for (r = 0; r < 6; r++) {
				table_8_888[r + g * 6 + b * 36 + 16] = ((((r * 51) & 0xff) << 16) | (((g * 51) & 0xff) << 8) | ((b * 51) & 0xff));
			}
		}
	}
	if(binfo->vmode == 8) set_palette(16, 231, table2);
	return;
}

void set_palette(int start, int end, unsigned char *rgb)
{
	int i, eflags;
	eflags = io_load_eflags();	/* 荞݋tO̒lL^ */
	io_cli(); 					/* tO0ɂĊ荞݋֎~ɂ */
	io_out8(0x03c8, start);
	for (i = start; i <= end; i++) {
		io_out8(0x03c9, rgb[0] / 4);
		io_out8(0x03c9, rgb[1] / 4);
		io_out8(0x03c9, rgb[2] / 4);
		rgb += 3;
	}
	io_store_eflags(eflags);	/* 荞݋tOɖ߂ */
	return;
}

void boxfill8(unsigned int *vram, int xsize, unsigned int c, int x0, int y0, int x1, int y1)
{
	int x, y;
	for (y = y0; y <= y1; y++) {
		for (x = x0; x <= x1; x++)
			vram[y * xsize + x] = c;
	}
	return;
}

int alphamix(int c1, int c2, int alpha)
{
	int r, g, b;
	int r1, g1, b1;
	int r2, g2, b2;
	int i = 2;
	
	r1 = c1 >> 16;
	g1 = (c1 >> 8) & 0xff;
	b1 = c1 & 0xff;
	
	r2 = c2 >> 16;
	g2 = (c2 >> 8) & 0xff;
	b2 = c2 & 0xff;
	
	r = (r2 * alpha + r1 * (255 - alpha)) / 255;   // B`l.
	g = (g2 * alpha + g1 * (255 - alpha)) / 255;   // G`l.
	b = (b2 * alpha + b1 * (255 - alpha)) / 255;   // R`l.
	
	if(r > 255) r = 255;
	if(g > 255) g = 255;
	if(b > 255) b = 255;
	
	
	return (r << 16) | (g << 8) | b;
}

void putfont8(int *vram, int xsize, int x, int y, int c, char *font)
{
#if USE_AA == 0
	int i;
	int *p, d;
	
	for (i = 0; i < 16; i++) {
		p = vram + (y + i) * xsize + x;
		d = font[i];
		if ((d & 0x80) != 0) { p[0] = c; }
		if ((d & 0x40) != 0) { p[1] = c; }
		if ((d & 0x20) != 0) { p[2] = c; }
		if ((d & 0x10) != 0) { p[3] = c; }
		if ((d & 0x08) != 0) { p[4] = c; }
		if ((d & 0x04) != 0) { p[5] = c; }
		if ((d & 0x02) != 0) { p[6] = c; }
		if ((d & 0x01) != 0) { p[7] = c; }
	}
#else
	int i;
	int xc, yc;
	int *p, d;
	int c1, c2;
	
	int i2 = 0;
	for (i = 0; i < 16; i++) {
		p = vram + (y + i) * xsize + x;
		d = font[i];
		if ((d & 0x80) != 0) { p[0] = c; }
		if ((d & 0x40) != 0) { p[1] = c; }
		if ((d & 0x20) != 0) { p[2] = c; }
		if ((d & 0x10) != 0) { p[3] = c; }
		if ((d & 0x08) != 0) { p[4] = c; }
		if ((d & 0x04) != 0) { p[5] = c; }
		if ((d & 0x02) != 0) { p[6] = c; }
		if ((d & 0x01) != 0) { p[7] = c; }
	}
	
	for (yc = y; yc < 16 + y; yc++) {
		for (xc = x; xc < 8 + x; xc++) {
			c1 = vram[yc * xsize + xc];
			
			if(vram[(yc + 0) * xsize + (xc + 1)] == c && c1 != c) i2 += 64;
			if(vram[(yc + 0) * xsize + (xc - 1)] == c && c1 != c) i2 += 64;
			if(vram[(yc + 1) * xsize + (xc + 0)] == c && c1 != c) i2 += 64;
			if(vram[(yc - 1) * xsize + (xc + 0)] == c && c1 != c) i2 += 64;
			
			if(i2 > AA_LEVEL * 64) {
				c2 = alphamix(c, c1, 256 - i2);
				
				vram[yc * xsize + xc] = c2;
			}
			i2 = 0;
		}
	}
#endif
	return;
}

void putfont8_sjis(int *vram, int xsize, int x, int y, int c, char *font)
{
#if USE_AA == 0
	int i;
	int *p, d;
	
	for (i = 0; i < 16; i++) {
		p = vram + (y + i) * xsize + x;
		d = font[i];
		if ((d & 0x80) != 0) { p[0] = c; }
		if ((d & 0x40) != 0) { p[1] = c; }
		if ((d & 0x20) != 0) { p[2] = c; }
		if ((d & 0x10) != 0) { p[3] = c; }
		if ((d & 0x08) != 0) { p[4] = c; }
		if ((d & 0x04) != 0) { p[5] = c; }
		if ((d & 0x02) != 0) { p[6] = c; }
		if ((d & 0x01) != 0) { p[7] = c; }
		
		d = font[i + 16];
		
		if ((d & 0x80) != 0) { p[8] = c; }
		if ((d & 0x40) != 0) { p[9] = c; }
		if ((d & 0x20) != 0) { p[10] = c; }
		if ((d & 0x10) != 0) { p[11] = c; }
		if ((d & 0x08) != 0) { p[12] = c; }
		if ((d & 0x04) != 0) { p[13] = c; }
		if ((d & 0x02) != 0) { p[14] = c; }
		if ((d & 0x01) != 0) { p[15] = c; }
	}
#else
	int i;
	int xc, yc;
	int *p, d;
	int c1, c2;
	
	int i2 = 0;
	for (i = 0; i < 16; i++) {
		p = vram + (y + i) * xsize + x;
		d = font[i];
		if ((d & 0x80) != 0) { p[0] = c; }
		if ((d & 0x40) != 0) { p[1] = c; }
		if ((d & 0x20) != 0) { p[2] = c; }
		if ((d & 0x10) != 0) { p[3] = c; }
		if ((d & 0x08) != 0) { p[4] = c; }
		if ((d & 0x04) != 0) { p[5] = c; }
		if ((d & 0x02) != 0) { p[6] = c; }
		if ((d & 0x01) != 0) { p[7] = c; }
		
		d = font[i + 16];
		
		if ((d & 0x80) != 0) { p[8] = c; }
		if ((d & 0x40) != 0) { p[9] = c; }
		if ((d & 0x20) != 0) { p[10] = c; }
		if ((d & 0x10) != 0) { p[11] = c; }
		if ((d & 0x08) != 0) { p[12] = c; }
		if ((d & 0x04) != 0) { p[13] = c; }
		if ((d & 0x02) != 0) { p[14] = c; }
		if ((d & 0x01) != 0) { p[15] = c; }
	}
	
	for (yc = y; yc < 16 + y; yc++) {
		for (xc = x; xc < 16 + x; xc++) {
			c1 = vram[yc * xsize + xc];
			
			if(vram[(yc + 0) * xsize + (xc + 1)] == c && c1 != c) i2 += 64;
			if(vram[(yc + 0) * xsize + (xc - 1)] == c && c1 != c) i2 += 64;
			if(vram[(yc + 1) * xsize + (xc + 0)] == c && c1 != c) i2 += 64;
			if(vram[(yc - 1) * xsize + (xc + 0)] == c && c1 != c) i2 += 64;
			
			if(i2 > AA_LEVEL * 64) {
				
				c2 = alphamix(c, c1, 256 - i2);
				
				vram[yc * xsize + xc] = c2;
			}
			i2 = 0;
		}
	}
#endif
	return;
}

void putfonts8_asc(int *vram, int xsize, int x, int y, int c, unsigned char *s)
{
	
	extern char ascii[4096];
	struct TASK *task = task_now();
	char *sjis = (char *) *((int *) 0x0fe8), *font;
	int k, t;
	int l = 1;
	char debug[256];

	if (task->langmode == 0) {
		for (; *s != 0x00; s++) {
			if(*s != 0x0a){
				putfont8(vram, xsize, x, y, c, ascii + *s * 16);
				l++;
			} else {
				y += 16;
				x -= l * 8;
				l = 1;
			}
			x += 8;
		}
	}
	if (task->langmode == 1) {
		for (; *s != 0x00; s++) {
			if (task->langbyte1 == 0) {
				if ((0x81 <= *s && *s <= 0x9f) || (0xe0 <= *s && *s <= 0xfc)) {
					task->langbyte1 = *s;
				} else {
					if(*s != 0x0a){
						putfont8(vram, xsize, x, y, c, ascii + *s * 16);
						l++;
					} else {
						y += 16;
						if(*s == 0x0a) x -= l * 8;
						l = 1;
					}
				}
			} else {
				if (0x81 <= task->langbyte1 && task->langbyte1 <= 0x9f) {
					k = (task->langbyte1 - 0x81) * 2;
				} else {
					k = (task->langbyte1 - 0xe0) * 2 + 62;
				}
				if (0x40 <= *s && *s <= 0x7e) {
					t = *s - 0x40;
				} else if (0x80 <= *s && *s <= 0x9e) {
					t = *s - 0x80 + 63;
				} else {
					t = *s - 0x9f;
					k++;
				}
				task->langbyte1 = 0;
				font = sjis + (k * 94 + t) * 32;
				if(*s != 0x0a)
				{
					putfont8_sjis(vram, xsize, x - 8, y, c, font);
					l += 2;
				} else {
					y += 16;
					if(*s == 0x0a) x -= l * 8;
					l = 1;
				}
			}
			x += 8;
		}
	}
	return;
}

void putfonts8(int *vram, int xsize, int x, int y, int c, unsigned char *s)
{
	extern char ascii[4096];
	struct TASK *task = task_now();
	char *font;
	int l = 1;
	
	for (; *s != 0x00; s++) {
		if(*s != 0x0a){
			putfont8(vram, xsize, x, y, c, ascii + *s * 16);
			l++;
		} else {
			y += 16;
			x -= l * 8;
			l = 1;
		}
		x += 8;
	}
	return;
}

void init_screen8(int *vram, int x, int y)
{
	int cx, cy;
	for(cy = 0; cy < y; cy++) {
		for(cx = 0; cx < x; cx++) {
			float xp = (float)cx / (float)x;
			float yp = (float)cy / (float)y;
			int r = (255.0f * (1.0f - (float)xp));
			int g = (255.0f * ((float)yp));
			int b = ((255.0f * ((float)yp * (float)xp))) / 2.0f;
			
			vram[cy * x + cx] = (r << 16) | (g << 8) | b;
		}
	}
	//boxfill8(vram, x, 0x007fc0,  0,      0,      x -  1, y - 1);
	boxfill8(vram, x, COL8_000000,  0,      y - 28, x -  1, y - 1);
	boxfill8(vram, x, COL8_333333,  0,      y - 27, x -  2, y - 2);

	boxfill8(vram, x, COL8_FFFFFF,  3,     y - 24, 60,     y - 3);
	boxfill8(vram, x, COL8_333333,  4,     y - 23, 59,     y - 4);
	
	putfonts8_asc(vram, x, 9, 9, COL8_000000, "Tiny Unstable Operating System\n"OS_VERSION);
	putfonts8_asc(vram, x, 8, 8, COL8_FFFFFF, "Tiny Unstable Operating System\n"OS_VERSION);
	
	putfonts8_asc(vram, x, 12, y - 21, COL8_FFFFFF, "apps");
	
	return;
}

void init_mouse_cursor8(int *mouse, int bc)
/* }EXJ[\i16x16j */
{
	static char cursor[16][16] = {
		"OO..............",
		"O*O.............",
		"O**O............",
		"O***O...........",
		"O****O..........",
		"O*****O.........",
		"O******O........",
		"O*******O.......",
		"O********O......",
		"O*****OOOOO.....",
		"O**O**O.........",
		"O*O.O**O........",
		"OO..O**O........",
		"O....O**O.......",
		".....O**O.......",
		"......OO........"
	};
	int x, y;

	for (y = 0; y < 16; y++) {
		for (x = 0; x < 16; x++) {
			if (cursor[y][x] == '*') {
				mouse[y * 16 + x] = COL8_000000;
			}
			if (cursor[y][x] == 'O') {
				mouse[y * 16 + x] = COL8_FFFFFF;
			}
			if (cursor[y][x] == '.') {
				mouse[y * 16 + x] = bc;
			}
		}
	}
	return;
}

void push_menu(int *vram, int bxsize, int bysize)
{
	int x, y;
	int c;

	for (y = bysize - 24; y <= bysize - 3; y++) {
		for (x = 3; x <= 60; x++) {
			c = vram[y * bxsize + x];
			if (c == COL8_333333) {
				c = COL8_FFFFFF;
			} else if (c == COL8_FFFFFF) {
				c = COL8_333333;
			}
			vram[y * bxsize + x] = c;
		}
	}

	return;
}

void pull_menu(int *vram, int bxsize, int bysize)
{
	/*int x, y;
	int c;

	for (y = bysize - 24; y <= bysize - 3; y++) {
		for (x = 3; x <= 60; x++) {
			c = vram[y * bxsize + x];
			if (c == COL8_333333) {
				c = COL8_FFFFFF;
			} else if (c == COL8_FFFFFF) {
				c = COL8_333333;
			}
			vram[y * bxsize + x] = c;
		}
	}*/
	push_menu(vram, bxsize, bysize);

	return;
}

void draw_line(int *vram, int xsize, int x0, int y0, int x1, int y1, int col)
{
	int i, x, y, len, dx, dy;

	dx = x1 - x0;
	dy = y1 - y0;
	x = x0 << 10;
	y = y0 << 10;
	if (dx < 0) {
		dx = - dx;
	}
	if (dy < 0) {
		dy = - dy;
	}
	if (dx >= dy) {
		len = dx + 1;
		if (x0 > x1) {
			dx = -1024;
		} else {
			dx =  1024;
		}
		if (y0 <= y1) {
			dy = ((y1 - y0 + 1) << 10) / len;
		} else {
			dy = ((y1 - y0 - 1) << 10) / len;
		}
	} else {
		len = dy + 1;
		if (y0 > y1) {
			dy = -1024;
		} else {
			dy =  1024;
		}
		if (x0 <= x1) {
			dx = ((x1 - x0 + 1) << 10) / len;
		} else {
			dx = ((x1 - x0 - 1) << 10) / len;
		}
	}

	for (i = 0; i < len; i++) {
		vram[(y >> 10) * xsize + (x >> 10)] = col;
		x += dx;
		y += dy;
	}

	return;
}

void boxfill8_fb(unsigned int *vram, unsigned int c, int x0, int y0, int x1, int y1)
{
	int x, y;
	for (y = y0; y <= y1; y++) {
		for (x = x0; x <= x1; x++)
		draw_pixel(vram, c, x, y);
	}
	return;
}

void bit2bmp(unsigned char bit, int *bmp, int fcol, int bcol)
{
	if ((bit & 0x80) != 0) { bmp[0] = fcol; } else { bmp[0] = bcol; }
	if ((bit & 0x40) != 0) { bmp[1] = fcol; } else { bmp[1] = bcol; }
	if ((bit & 0x20) != 0) { bmp[2] = fcol; } else { bmp[2] = bcol; }
	if ((bit & 0x10) != 0) { bmp[3] = fcol; } else { bmp[3] = bcol; }
	if ((bit & 0x08) != 0) { bmp[4] = fcol; } else { bmp[4] = bcol; }
	if ((bit & 0x04) != 0) { bmp[5] = fcol; } else { bmp[5] = bcol; }
	if ((bit & 0x02) != 0) { bmp[6] = fcol; } else { bmp[6] = bcol; }
	if ((bit & 0x01) != 0) { bmp[7] = fcol; } else { bmp[7] = bcol; }
}

void putblock8_fb(unsigned int *vram, unsigned char *img, int x0, int y0, int sx, int sy)
{
	int x, y;
	for (y = 0; y < sy; y++) {
		for (x = 0; x < sx; x += 8) {
			int i;
			int p[8];
			
			bit2bmp(img[y * (sx >> 3) + (x >> 3)], p, 0xefe4b0, 0x202020);
			
			for(i = 0; i < 8; i++) draw_pixel(vram, p[i], x0 + x + i, y0 + y);
		}
	}
	return;
}

void draw_pixel(unsigned int *vram, unsigned int col, int x, int y)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	int scx = binfo->scrnx;
	int r, g, b;
	
	if (binfo->vmode == 8) {
		col2rgb(col, &r, &g, &b);
		((unsigned char *)vram)[y * scx + x] = rgb2pal_8(r, g, b, x, y);
	} else if (binfo->vmode == 16) {
		col2rgb(col, &r, &g, &b);
		((unsigned short *)vram)[y * scx + x] = rgb2pal_16(r, g, b);
	} else if (binfo->vmode == 24) {
		col2rgb(col, &r, &g, &b);
		((unsigned char *)vram)[(y * scx + x) * 3 + 0] = b;
		((unsigned char *)vram)[(y * scx + x) * 3 + 1] = g;
		((unsigned char *)vram)[(y * scx + x) * 3 + 2] = r;
	} else if (binfo->vmode == 32) {
		vram[y * scx + x] = col;
	}
}

int get_int(unsigned char c)
{
	return table_8_888[c];
}
