/**
 * @file tulstr.c
 * @brief string function implementations.
 * @author ASAKURA, Hunyosi
 */

#include "tulstr.h"

#include <stdlib.h>

#include "tulasrt.h"
#include "tulmem.h"


TulErr tulStrNew(TulStr **io_objp, const char *i_cstr)
{
	TulErr err;

	TUL_ASSERT(io_objp, "TulStrNew 1st param is NULL");
	TUL_ASSERT(!*io_objp, "TulStrNew 1st param ref value is NULL");

	*io_objp = tulMemAlloc(sizeof(TulStr), &err);
	if (err)
		return err;

	(*io_objp)->buf = NULL;
	(*io_objp)->body = NULL;
	(*io_objp)->end = NULL;
	(*io_objp)->bufEnd = NULL;

	return TUL_ERR_NO_ERR;
}


void TulStrDelete(TulStr **io_objp)
{
	TulStr *obj;

	if (!io_objp)
		return;
	if (!*io_objp)
		return;

	obj = *io_objp;
	*io_objp = NULL;
	tulMemFree(obj->buf);
	obj->buf = NULL;
	tulMemFree(obj);
}


TulErr tulStrAddChar(TulStr *io_obj, TulChar i_char)
{
	TulErr err;

	TUL_ASSERT(io_obj, "tulStrAddChar 1st param is NULL");

	if (!io_obj->buf)
		return TUL_ERR_NO_ERR;

	if (!io_obj->buf) {
		size_t s = sizeof(TulChar);
		io_obj->buf = tulMemAlloc(s, &err);
		if (err)
			return err;

		io_obj->body = io_obj->buf;
		io_obj->end = io_obj->body;
		io_obj->bufEnd = io_obj->end;
	}

	*io_obj->end = i_char;

	return TUL_ERR_NO_ERR;
}
