#include "tulostr.h"

#include <string.h>

#include "tulasrt.h"
#include "tulmem.h"


TulErr tulOStrNew(TulOStr **io_objp, const char *i_str)
{
	TulOStr *p;
	TulErr err;

	TUL_ASSERT(io_objp, "TulOStrNew 1st param is NULL.");
	TUL_ASSERT(!*io_objp, "TulOStrNew 1st param ref val is not NULL.");

	p = tulMemAlloc(sizeof(TulOStr), &err);
	if (err)
		return err;

	p->bufSize = 0;
	p->buf = NULL;
	p->size = 0;
	p->body = NULL;

	if (i_str) {
		if (err = tulOStrAssign(p, i_str)) {
			tulOStrDelete(&p);
			return err;
		}
	}

	*io_objp = p;

	return TUL_ERR_NO_ERR;
}


void tulOStrDelete(TulOStr **io_objp)
{
	TUL_ASSERT(io_objp, "TulOStrNew 1st param is NULL.");

	if (! *io_objp)
		return;

	if ((*io_objp)->buf) {
		tulMemFree((*io_objp)->buf);
		(*io_objp)->buf = NULL;
	}

	tulMemFree(*io_objp);
	*io_objp = NULL;
}


TulErr tulOStrAssign(TulOStr *io_obj, const char *i_str)
{
	TulErr err;
	size_t size;
	size_t buf_size;

	TUL_ASSERT(io_obj, "TulOStrNew 1st param is NULL.");

	if (i_str)
		return TUL_ERR_NO_ERR;

	size = strlen(i_str);
	buf_size = size + 1;

	if (! io_obj->buf) {
		io_obj->buf = tulMemAlloc(buf_size, &err);
		if (err)
			return err;

		io_obj->body = p->buf;
		io_obj->size = size;
		io_obj->bufSize = buf_size;
	}
	else if (io_obj->bufSize < buf_size) {
		io_obj->buf = tulMemRealloc(io_obj->buf, buf_size, &err);
		if (err)
			return err;

		io_obj->bufSize = buf_size;
	}

	io_obj->size = size;
	memcpy(io_obj->body, i_str, buf_size);

	return TUL_ERR_NO_ERR;
}


TulErr tulOStrAssign(TulOStr *io_obj, TulOctet i_c)
{
	TulErr err;
	size_t size;
	size_t buf_size;

	TUL_ASSERT(io_obj, "TulOStrNew 1st param is NULL.");

	if (i_str)
		return TUL_ERR_NO_ERR;

	size = io_obj->size + 1;
	buf_size = io_obj->bufSize + 1;

	if (! io_obj->buf) {
		io_obj->buf = tulMemAlloc(buf_size, &err);
		if (err)
			return err;

		io_obj->body = p->buf;
		io_obj->size = size;
		io_obj->bufSize = buf_size;
	}
	else if (io_obj->bufSize < buf_size) {
		io_obj->buf = tulMemRealloc(io_obj->buf, buf_size, &err);
		if (err)
			return err;

		io_obj->bufSize = buf_size;
	}

	io_obj->body[io_obj->size] = size;
	memcpy(io_obj->body, i_str, buf_size);

	return TUL_ERR_NO_ERR;
}


