/**
 * @file tulmem.c
 * @brief implementation of memory functions.
 * @author ASAKURA, Hunyosi
 */

#include "tulmem.h"

#include <stdlib.h>

#include "tulasrt.h"


void *tulMemAlloc(size_t i_size, TulErr *o_err)
{
	void *p;

	TUL_ASSERT(i_size, "tulMemAlloc 1st param is 0");
	TUL_ASSERT(o_err, "tulMemAlloc 2st param is NULL");

	*o_err = TUL_ERR_NO_ERR;

	p = malloc(i_size);
	if (!p)
		*o_err = TUL_ERR_NO_MEM;

	return p;
}


void *tulMemRealloc(void *io_memblk, size_t i_size, TulErr *o_err)
{
	void *p;

	TUL_ASSERT(io_memblk, "tulMemRealloc 1st param is NULL");
	TUL_ASSERT(i_size, "tulMemRealloc 2nd param is 0");
	TUL_ASSERT(o_err, "tulMemRealloc 2nd param is 0");

	*o_err = TUL_ERR_NO_ERR;

	p = realloc(io_memblk, i_size);
	if (!p) {
		*o_err = TUL_ERR_NO_MEM;
		return io_memblk;
	}

	return p;
}


void tulMemFree(void *io_memblkp)
{
	if (!io_memblkp)
		return;

	free(io_memblkp);
}

