/**
 * @file tulerr.c
 * @brief implementation of functions for error.
 * @author ASAKURA, Hunyosi
 */

#include "tulerr.h"


typedef struct TulErrMsgTbl TulErrMsgTbl;
struct TulErrMsgTbl
{
	TulErr errorCode;
	const char *message;
};


const char *tulErrToMsg(TulErr i_err)
{
	static const TulErrMsgTbl err_msg_tbl[] = {
		{ TUL_ERR_NO_ERR, "Succeed" },
		{ TUL_ERR_NO_MEM, "No Memory" },
		{ TUL_ERR_END_OF_ENUM, NULL }
	};
	int i;

	if (i_err < TUL_ERR_NO_ERR || i_err >= TUL_ERR_END_OF_ENUM)
		return NULL;

	for (i = 0; err_msg_tbl[i].errorCode != TUL_ERR_END_OF_ENUM; i ++) {
		if (err_msg_tbl[i].errorCode == i_err)
			return err_msg_tbl[i].message;
	}

	return NULL;
}

