/**
 * @file tulasrt.h
 * @brief assertion macro, declaration of functions for assertion
 * @author ASAKURA, Hunyosi
 */

#ifndef TULASRT_H__TUL
#define TULASRT_H__TUL


#include "tulerr.h"


#define TUL_ASSERT(i_res, i_msg) do \
{ \
	if (! i_res) \
		tulAssert(__FILE__, __LINE__, i_msg); \
} \
while (0)


void tulAssert(const char *i_file, int i_line, const char *i_msg);


#define TUL_ERROR(i_err, i_msg) tulError(i_err, __FILE__, __LINE__, i_msg)


void tulError(TulErr i_err, const char *i_file, int i_line, const char *i_msg);


#endif	/* TULASRT_H__TUL */
