/**
 * @file tulasrt.c
 * @brief implementation of functions for assertion
 * @author ASAKURA, Hunyosi
 */

#include "tulasrt.h"

#include <stdlib.h>
#include <stdio.h>


/**
 * assert.
 *
 * This function exits the process.
 *
 * @param[in] i_file source file name (__FILE__ macro).
 * @param[in] i_line source file line no (__LINE__ macro).
 * @param[in] i_msg asserting message.
 */
void tulAssert(const char *i_file, int i_line, const char *i_msg)
{
	fprintf(stderr, "%s(%d): assertion:", i_file, i_line);

	if (i_msg)
		fprintf(stderr, " %s", i_msg);

	fputc('\n', stderr);
	abort();
}


/**
 * error assert.
 *
 * This function exits the process.
 *
 * @param[in] i_err error code.
 * @param[in] i_file source file name (__FILE__ macro).
 * @param[in] i_line source file line no (__LINE__ macro).
 * @param[in] i_msg asserting message.
 */
void tulError(TulErr i_err, const char *i_file, int i_line, const char *i_msg)
{
	const char *err_msg;

	if (i_err == TUL_ERR_NO_ERR)
		return;

	err_msg = tulErrToMsg(i_err);
	fprintf(stderr, "%s(%d): error:", i_file, i_line);

	if (err_msg)
		fprintf(stderr, " %s", err_msg);
	else
		fprintf(stderr, " unknown error %d", i_err);

	fputc(':', stderr);
	if (i_msg)
		fprintf(stderr, " %s", i_msg);

	fputc('\n', stderr);
	abort();
}

