/* ===========================================================================
                           TTB Plugin Template(VC++)

                                 Plugin.cpp

   =========================================================================== */
#include "Plugin.h"
#include "Main.h"
#include "MessageDef.h"


// --------------------------------------------------------
//    {̑GNX|[g֐
// --------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif
PLUGIN_INFO* (WINAPI *TTBPlugin_GetPluginInfo)(DWORD hPlugin);
void (WINAPI *TTBPlugin_SetPluginInfo)(DWORD hPlugin, PLUGIN_INFO *PluginInfo);
void (WINAPI *TTBPlugin_FreePluginInfo)(PLUGIN_INFO *PluginInfo);
void (WINAPI *TTBPlugin_SetMenuProperty)(DWORD hPlugin, int CommandID, DWORD CheckFlag, DWORD Flag);
PLUGIN_INFO** (WINAPI *TTBPlugin_GetAllPluginInfo)(void);
void (WINAPI *TTBPlugin_FreePluginInfoArray)(PLUGIN_INFO **PluginInfoArray);
void (WINAPI *TTBPlugin_SetTaskTrayIcon)(HICON hIcon, const char *Tips);
void (WINAPI *TTBPlugin_WriteLog)( DWORD hPlugin, int logLevel, const char *msg );
BOOL (WINAPI *TTBPlugin_ExecuteCommand)( const char *PluginName, int CmdID, HWND hWnd );
#ifdef __cplusplus
};
#endif

/* [J֐` */
void GetVersion(char *, DWORD *, DWORD *);

/* O[oϐ */
char *PLUGIN_FILENAME;	// vOC̃t@CBTTBasetH_̑΃pX
DWORD PLUGIN_HANDLE;	// TTBasevOCʂ邽߂̃R[h

// ****************************************************************
// *
// *         vOC Cxg
// *
// --------------------------------------------------------
//    vOC\̂̃Zbg
// --------------------------------------------------------
extern "C"
PLUGIN_INFO* WINAPI TTBEvent_InitPluginInfo(char *PluginFilename)
{
	int i;
	PLUGIN_COMMAND_INFO *pCI;

	PLUGIN_INFO		*result;	/* Ԓl	*/

	/* t@Ci΃pXjRs[ */
	PLUGIN_FILENAME = (char *)malloc(strlen(PluginFilename) + 1);
	if (PLUGIN_FILENAME != NULL)
		lstrcpy(PLUGIN_FILENAME, PluginFilename);

	/* vOC\̂̐ */
	result = (PLUGIN_INFO *)malloc(sizeof(PLUGIN_INFO));
	if (result == NULL) return NULL;
	
	/* vOC̖O */
	result->Name = (char *)malloc(strlen(PLUGIN_NAME) + 1);
	if (result->Name != NULL)
		lstrcpy(result->Name, PLUGIN_NAME);
	/* vOCt@C */
	result->Filename = (char *)malloc(strlen(PLUGIN_FILENAME) + 1);
	if (result->Filename != NULL)
		lstrcpy(result->Filename, PLUGIN_FILENAME);
	/* vOC^Cv */
	result->PluginType = PLUGIN_TYPE;
	/* o[W̎擾 */
	GetVersion(PLUGIN_FILENAME, &result->VersionMS, &result->VersionLS);
	/* R}h̐ */
	result->CommandCount = COMMAND_COUNT;
	/* R}h\̔z̍쐬 */
#if COMMAND_COUNT > 0
	result->Commands = (PLUGIN_COMMAND_INFO *)malloc(
				sizeof(PLUGIN_COMMAND_INFO) * COMMAND_COUNT);
	if (result->Commands != NULL) {
		/* R}h\̂̍쐬 */
		for (i = 0; i < COMMAND_COUNT; i++) {
			pCI = &result->Commands[i];
			*pCI = COMMAND_INFO[i];
			/* R}h		*/
			pCI->Name = (char *)malloc(strlen(COMMAND_INFO[i].Name) + 1);
			if (pCI->Name != NULL)
				lstrcpy(pCI->Name, COMMAND_INFO[i].Name);
			pCI->Caption = (char *)malloc(strlen(COMMAND_INFO[i].Caption) + 1);
			if (pCI->Caption != NULL)
				lstrcpy(pCI->Caption, COMMAND_INFO[i].Caption);
		}
	}
#else
	result->Commands = NULL;
#endif

	return result;
}

// --------------------------------------------------------
//    vOC\̂̔j
// --------------------------------------------------------
extern "C"
void WINAPI TTBEvent_FreePluginInfo(PLUGIN_INFO *PluginInfo)
{
	DWORD i;
	PLUGIN_COMMAND_INFO *pCI;

	for (i = 0; i < PluginInfo->CommandCount; i++) {
		pCI = &PluginInfo->Commands[i];
		free(pCI->Name);
		free(pCI->Caption);
	}
	free(PluginInfo->Commands);
	free(PluginInfo->Filename);
	free(PluginInfo->Name);
	free(PluginInfo);
}

// --------------------------------------------------------
//    vOC
// --------------------------------------------------------
extern "C"
BOOL WINAPI TTBEvent_Init(char *PluginFilename, DWORD hPlugin)
{
	// bZ[W`
	RegisterMessages();
	// LbV̂߂ɁATTBPlugin_InitPluginInfo͌Ă΂Ȃꍇ
	// ̂߁AInitłPLUGIN_FILENAMȄs
	if (PLUGIN_FILENAME != NULL) free(PLUGIN_FILENAME);
	PLUGIN_FILENAME = (char *)malloc(strlen(PluginFilename) + 1);
	if (PLUGIN_FILENAME != NULL)
		lstrcpy(PLUGIN_FILENAME, PluginFilename);

	// TTBasevOCʂ邽߂̃R[h
	PLUGIN_HANDLE = hPlugin;

	// API֐̎擾
	HMODULE hModule = GetModuleHandle(NULL);
	(FARPROC&)TTBPlugin_GetPluginInfo = GetProcAddress(hModule, "TTBPlugin_GetPluginInfo");
	(FARPROC&)TTBPlugin_SetPluginInfo = GetProcAddress(hModule, "TTBPlugin_SetPluginInfo");
	(FARPROC&)TTBPlugin_FreePluginInfo = GetProcAddress(hModule, "TTBPlugin_FreePluginInfo");
	(FARPROC&)TTBPlugin_SetMenuProperty = GetProcAddress(hModule, "TTBPlugin_SetMenuProperty");
	(FARPROC&)TTBPlugin_GetAllPluginInfo = GetProcAddress(hModule, "TTBPlugin_GetAllPluginInfo");
	(FARPROC&)TTBPlugin_FreePluginInfoArray = GetProcAddress(hModule, "TTBPlugin_FreePluginInfoArray");
	(FARPROC&)TTBPlugin_SetTaskTrayIcon = GetProcAddress(hModule, "TTBPlugin_SetTaskTrayIcon");
	(FARPROC&)TTBPlugin_WriteLog = GetProcAddress(hModule, "TTBPlugin_WriteLog");
	(FARPROC&)TTBPlugin_ExecuteCommand = GetProcAddress(hModule, "TTBPlugin_ExecuteCommand");

	return Init();
}

// --------------------------------------------------------
//    vOCA[h̏
// --------------------------------------------------------
extern "C"
void WINAPI TTBEvent_Unload(void)
{
	Unload();
}

// --------------------------------------------------------
//    R}hs
// --------------------------------------------------------
extern "C"
BOOL WINAPI TTBEvent_Execute(int CommandID, HWND hWnd)
{
	return Execute(CommandID, hWnd);
}

// --------------------------------------------------------
//    tbNiShellHook,MouseHook)
// --------------------------------------------------------
extern "C"
void WINAPI TTBEvent_WindowsHook(UINT Msg, DWORD wParam, DWORD lParam)
{
	Hook(Msg, wParam, lParam);
}

// ****************************************************************
// *
// *         [eBeB[`
// *
// --------------------------------------------------------
//    o[WԂ
// --------------------------------------------------------
static void GetVersion(char *Filename, DWORD *VersionMS, DWORD *VersionLS)
{
	DWORD	Size;
	LPDWORD	hVersion;
	LPVOID	pVersionInfo;
	VS_FIXEDFILEINFO	*FixedFileInfo;
	UINT	ItemLen;


	*VersionMS = 0;
	*VersionLS = 0;

	hVersion = NULL;

	Size = GetFileVersionInfoSize(Filename, hVersion);
	if (Size == 0) return;

	pVersionInfo = (LPVOID)malloc(Size);
	if (pVersionInfo == NULL) return;

	GetFileVersionInfo(Filename, 0, Size, pVersionInfo);

	if (VerQueryValue(pVersionInfo, "\\", (void **)&FixedFileInfo, &ItemLen)) {
		*VersionMS = FixedFileInfo->dwFileVersionMS;
		*VersionLS = FixedFileInfo->dwFileVersionLS;
	}

	free(pVersionInfo);
}

// --------------------------------------------------------
//    vOC\̂SrcRs[ĕԂ
// --------------------------------------------------------
PLUGIN_INFO* CopyPluginInfo(PLUGIN_INFO *PluginInfo)
{
	PLUGIN_INFO *Result;
	PLUGIN_COMMAND_INFO *Command, *SrcCommand;
	DWORD i;
	
	Result = (PLUGIN_INFO *)malloc(sizeof(PLUGIN_INFO));
	*Result = *PluginInfo;
	Result->Name = (char *)malloc(strlen(PluginInfo->Name) + 1);
	lstrcpy(Result->Name, PluginInfo->Name);
	Result->Filename = (char *)malloc(strlen(PluginInfo->Filename) + 1);
	lstrcpy(Result->Filename, PluginInfo->Filename);
	
	Result->Commands = (PLUGIN_COMMAND_INFO *)malloc(
		sizeof(PLUGIN_INFO) * PluginInfo->CommandCount);
	for (i = 0; i < PluginInfo->CommandCount; i++) {
		Command = &Result->Commands[i];
		SrcCommand = &PluginInfo->Commands[i];
		*Command = *SrcCommand;
		Command->Name = (char *)malloc(strlen(SrcCommand->Name) + 1);
		lstrcpy(Command->Name, SrcCommand->Name);
		Command->Caption = (char *)malloc(strlen(SrcCommand->Caption) + 1);
		lstrcpy(Command->Caption, SrcCommand->Caption);
	}

	return Result;
}

// --------------------------------------------------------
//  vOCō쐬ꂽvOC\̂j
// --------------------------------------------------------
void FreePluginInfo(PLUGIN_INFO *PluginInfo)
{
	TTBEvent_FreePluginInfo(PluginInfo);
}

// --------------------------------------------------------
//	Oo͂
// --------------------------------------------------------
void WriteLog( int logLevel, const char *msg ) {
	if( TTBPlugin_WriteLog != NULL ) {
		TTBPlugin_WriteLog( PLUGIN_HANDLE, logLevel, msg );
	}
}

// --------------------------------------------------------
//	̃vOC̃R}hs
// --------------------------------------------------------
BOOL ExecutePluginCommand( const char *PluginName, int CmdID, HWND hWnd ) {
	if( TTBPlugin_ExecuteCommand != NULL ) {
		return TTBPlugin_ExecuteCommand( PluginName, CmdID, hWnd );
	}
	return FALSE;
}
