/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.FieldUtil;

public class URLUtil {
    protected static final Map CANONICAL_PROTOCOLS = new HashMap();

    protected URLUtil() {
    }

    public static InputStream openStream(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static URLConnection openConnection(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static URL create(String spec) {
        try {
            return new URL(spec);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static URL create(URL context, String spec) {
        try {
            return new URL(context, spec);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String encode(String s, String enc) {
        try {
            return URLEncoder.encode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String decode(String s, String enc) {
        try {
            return URLDecoder.decode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String toCanonicalProtocol(String protocol) {
        String canonicalProtocol = (String)CANONICAL_PROTOCOLS.get(protocol);
        if (canonicalProtocol != null) {
            return canonicalProtocol;
        }
        return protocol;
    }

    public static File toFile(URL fileUrl) {
        try {
            String path = URLDecoder.decode(fileUrl.getPath(), "UTF-8");
            return new File(path).getAbsoluteFile();
        }
        catch (Exception e) {
            throw new SRuntimeException("ESSR0091", new Object[]{fileUrl}, e);
        }
    }

    public static void disableURLCaches() {
        BeanDesc bd = BeanDescFactory.getBeanDesc(URLConnection.class);
        FieldUtil.set(bd.getField("defaultUseCaches"), null, Boolean.FALSE);
    }

    static {
        CANONICAL_PROTOCOLS.put("wsjar", "jar");
    }
}

