/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.yadis.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.tsukuyomi.openid.http.HttpClientManager;
import jp.sourceforge.tsukuyomi.openid.yadis.YadisException;
import jp.sourceforge.tsukuyomi.openid.yadis.YadisResolver;
import jp.sourceforge.tsukuyomi.openid.yadis.YadisResult;
import jp.sourceforge.tsukuyomi.openid.yadis.YadisUrl;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.tags.MetaTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class YadisResolverImpl
implements YadisResolver {
    private static final Log LOG = LogFactory.getLog(YadisResolverImpl.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final String YADIS_XRDS_LOCATION = "X-XRDS-Location";
    private static final String YADIS_CONTENT_TYPE = "application/xrds+xml";
    private static final String YADIS_ACCEPT_HEADER = "text/html; q=0.3, application/xhtml+xml; q=0.5, application/xrds+xml";
    private HttpClientManager httpClientManager;

    public YadisResult discover(String url) {
        HttpClient client = this.httpClientManager.getHttpClient();
        YadisResult result = new YadisResult();
        try {
            YadisUrl yadisUrl = new YadisUrl(url);
            result.setYadisUrl(yadisUrl);
            this.headXrdsUrl(client, yadisUrl, result);
            this.getXrds(client, result, false);
            result.setStatus(0);
            LOG.info((Object)("Yadis discovery succeeded on " + url));
        }
        catch (YadisException e) {
            result.setStatus(e.getStatusCode());
            result.setStatusMessage(e.getMessage());
            if (e.getCause() != null) {
                result.setFailureCause(e.getCause());
            }
            LOG.info((Object)("Yadis discovery failed on " + url + ", status: " + e.getStatusCode() + ", error message: " + e.getMessage()));
        }
        return result;
    }

    private void getXrds(HttpClient client, YadisResult result, boolean secondCall) throws YadisException {
        block15: {
            String getUrl = result.getXrdsLocation() != null ? result.getXrdsLocation().toString() : result.getYadisUrl().toString();
            GetMethod get = new GetMethod(getUrl);
            get.setFollowRedirects(true);
            get.setRequestHeader("Accept", YADIS_ACCEPT_HEADER);
            try {
                Header contentType;
                int statusCode;
                if (DEBUG) {
                    LOG.debug((Object)("Performing HTTP GET #" + (secondCall ? "2" : "1") + " on: " + getUrl + " ..."));
                }
                if ((statusCode = client.executeMethod((HttpMethod)get)) != 200) {
                    throw new YadisException("GET failed on " + getUrl, 6);
                }
                if (result.getNormalizedUrl() == null) {
                    result.setNormalizedUrl(get.getURI().toString());
                }
                if ((contentType = get.getResponseHeader("content-type")) != null && contentType.getValue() != null && contentType.getValue().split(";")[0].equalsIgnoreCase(YADIS_CONTENT_TYPE)) {
                    XRDS xrds = this.parseXrds(get.getResponseBodyAsStream());
                    result.setXrdsLocation(get.getURI().toString(), 8);
                    result.setContentType(YADIS_ACCEPT_HEADER);
                    result.setXrds(xrds);
                    if (DEBUG) {
                        LOG.debug((Object)("Retrieved Yadis discovery result:\n" + result.dump()));
                    }
                    break block15;
                }
                if (!secondCall) {
                    if (get.getResponseHeaders(YADIS_XRDS_LOCATION).length > 1) {
                        throw new YadisException("Found more than one X-XRDS-Location headers: " + Arrays.toString(get.getResponseHeaders(YADIS_XRDS_LOCATION)), 8);
                    }
                    String xrdsLocation = null;
                    if (get.getResponseHeader(YADIS_XRDS_LOCATION) != null) {
                        xrdsLocation = get.getResponseHeader(YADIS_XRDS_LOCATION).getValue();
                        if (DEBUG) {
                            LOG.debug((Object)"Found X-XRDS-Location header.");
                        }
                    }
                    if (xrdsLocation == null) {
                        xrdsLocation = this.getHtmlMeta(get.getResponseBodyAsStream());
                    }
                    result.setXrdsLocation(xrdsLocation, 8);
                    this.getXrds(client, result, true);
                    break block15;
                }
                throw new YadisException("Cannot retrieve XRDS for " + result.getYadisUrl().getUrl().toString(), 9);
            }
            catch (IOException e) {
                throw new YadisException("Fatal transport error: ", 7, e);
            }
            finally {
                get.releaseConnection();
            }
        }
    }

    private String getHtmlMeta(InputStream input) throws YadisException {
        String xrdsLocation = null;
        if (input == null) {
            throw new YadisException("Cannot download HTML message", 10);
        }
        try {
            byte[] data = new byte[this.httpClientManager.getMaxHtmlSize()];
            int bytesRead = input.read(data);
            input.close();
            if (bytesRead <= 0) {
                throw new YadisException("No data read from the HTML message", 10);
            }
            Parser parser = Parser.createParser((String)new String(data, 0, bytesRead), null);
            NodeList heads = parser.parse((NodeFilter)new TagNameFilter("HEAD"));
            if (heads.size() != 1) {
                throw new YadisException("HTML response must have exactly one HEAD element, found " + heads.size() + " : " + heads.toHtml(), 11);
            }
            Node head = heads.elementAt(0);
            SimpleNodeIterator i = head.getChildren().elements();
            while (i.hasMoreNodes()) {
                MetaTag meta;
                Node node = i.nextNode();
                if (!(node instanceof MetaTag) || (meta = (MetaTag)node).getHttpEquiv() == null || !meta.getHttpEquiv().equalsIgnoreCase(YADIS_XRDS_LOCATION)) continue;
                if (xrdsLocation != null) {
                    throw new YadisException("More than one X-XRDS-LocationMETA tags found in HEAD: " + head.toHtml(), 11);
                }
                xrdsLocation = meta.getMetaContent();
                if (!DEBUG) continue;
                LOG.debug((Object)"Found X-XRDS-LocationMETA tags.");
            }
        }
        catch (IOException e) {
            throw new YadisException("I/O error while reading HTML message", 10, e);
        }
        catch (ParserException pe) {
            throw new YadisException("Error parsing HTML message", 11, pe);
        }
        return xrdsLocation;
    }

    private XRDS parseXrds(InputStream input) throws YadisException {
        XRDS xrds;
        if (input == null) {
            throw new YadisException("Cannot read XML message", 12);
        }
        try {
            int test;
            int bytesRead;
            int maxXmlSize = this.httpClientManager.getMaxXmlSize();
            byte[] data = new byte[maxXmlSize];
            int len = 0;
            for (bytesRead = 0; len != -1 && bytesRead < maxXmlSize; bytesRead += len) {
                len = input.read(data, bytesRead, maxXmlSize - bytesRead);
            }
            if (bytesRead == maxXmlSize && (test = input.read()) == -1) {
                throw new YadisException("XRDS stream exceeds max allowed size: " + this.httpClientManager.getMaxXmlSize(), 14);
            }
            input.close();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(data, 0, bytesRead));
            xrds = new XRDS(document.getDocumentElement(), false);
            if (DEBUG) {
                LOG.debug((Object)("Retrieved Yadis / XRDS:\n" + xrds.dump()));
            }
        }
        catch (ParserConfigurationException e) {
            throw new YadisException("Parser configuration error", 13, e);
        }
        catch (SAXException e) {
            throw new YadisException("Error parsing XML document", 13, e);
        }
        catch (ParseException e) {
            throw new YadisException("Error parsing XML DATE field", 13, e);
        }
        catch (URISyntaxException e) {
            throw new YadisException("Invalid URI specified in XRDS document", 13, e);
        }
        catch (IOException e) {
            throw new YadisException("Error reading XRDS document", 12, e);
        }
        return xrds;
    }

    private void headXrdsUrl(HttpClient client, YadisUrl url, YadisResult result) throws YadisException {
        HeadMethod head = new HeadMethod(url.getUrl().toString());
        head.setFollowRedirects(true);
        try {
            int statusCode;
            if (DEBUG) {
                LOG.debug((Object)("Performing HTTP HEAD on: " + url + " ..."));
            }
            if ((statusCode = client.executeMethod((HttpMethod)head)) != 200) {
                if (DEBUG) {
                    LOG.debug((Object)("Cannot retrieve X-XRDS-Location using HEAD from " + url.getUrl().toString() + "; status=" + head.getStatusLine()));
                }
                return;
            }
            if (head.getResponseHeaders(YADIS_XRDS_LOCATION).length > 1) {
                throw new YadisException("Found more than one X-XRDS-Location headers: " + Arrays.toString(head.getResponseHeaders(YADIS_XRDS_LOCATION)), 5);
            }
            Header xrdsLocation = head.getResponseHeader(YADIS_XRDS_LOCATION);
            if (xrdsLocation != null) {
                result.setXrdsLocation(xrdsLocation.getValue(), 5);
                result.setNormalizedUrl(head.getURI().toString());
            }
        }
        catch (HttpException e) {
            LOG.error((Object)("HTTP error during HEAD request on: " + url), (Throwable)e);
        }
        catch (IOException e) {
            throw new YadisException("I/O transport error: ", 4, e);
        }
        finally {
            head.releaseConnection();
        }
    }

    public void setHttpClientManager(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }
}

