/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.rp.impl;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.tsukuyomi.openid.rp.AbstractNonceVerifier;
import jp.sourceforge.tsukuyomi.openid.util.InternetDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InMemoryNonceVerifier
extends AbstractNonceVerifier {
    private static final Log LOG = LogFactory.getLog(InMemoryNonceVerifier.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private Map<String, Set<String>> idpMap = new HashMap<String, Set<String>>();

    public InMemoryNonceVerifier(int maxAge) {
        super(maxAge);
    }

    public InMemoryNonceVerifier() {
        super(60);
    }

    protected synchronized int seen(Date now, String idpUrl, String nonce) {
        this.removeAged(now);
        Set<String> seenSet = this.idpMap.get(idpUrl);
        if (seenSet == null) {
            seenSet = new HashSet<String>();
            this.idpMap.put(idpUrl, seenSet);
        }
        if (seenSet.contains(nonce)) {
            LOG.error((Object)("Possible replay attack! Already seen nonce: " + nonce));
            return 1;
        }
        seenSet.add(nonce);
        if (DEBUG) {
            LOG.debug((Object)("Nonce verified: " + nonce));
        }
        return 0;
    }

    private synchronized void removeAged(Date now) {
        InternetDateFormat dateFormat = new InternetDateFormat();
        HashSet<String> idpToRemove = new HashSet<String>();
        for (Map.Entry<String, Set<String>> ent : this.idpMap.entrySet()) {
            String idpUrl = ent.getKey();
            Set<String> seenSet = ent.getValue();
            HashSet<String> nonceToRemove = new HashSet<String>();
            for (String nonce : seenSet) {
                try {
                    Date nonceDate = dateFormat.parse(nonce);
                    if (!this.isTooOld(now, nonceDate)) continue;
                    nonceToRemove.add(nonce);
                }
                catch (ParseException e) {
                    nonceToRemove.add(nonce);
                }
            }
            for (String nonce : nonceToRemove) {
                if (DEBUG) {
                    LOG.debug((Object)("Removing nonce: " + nonce + " from OP: " + idpUrl));
                }
                seenSet.remove(nonce);
            }
            if (seenSet.size() != 0) continue;
            idpToRemove.add(idpUrl);
        }
        for (String idpUrl : idpToRemove) {
            if (DEBUG) {
                LOG.debug((Object)("Removed all nonces from OP: " + idpUrl));
            }
            this.idpMap.remove(idpUrl);
        }
    }

    public synchronized int size() {
        int total = 0;
        for (Set<String> seenSet : this.idpMap.values()) {
            total += seenSet.size();
        }
        return total;
    }
}

