/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message.ax;

import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.MessageExtension;
import jp.sourceforge.tsukuyomi.openid.message.MessageExtensionFactory;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.ax.FetchRequest;
import jp.sourceforge.tsukuyomi.openid.message.ax.FetchResponse;
import jp.sourceforge.tsukuyomi.openid.message.ax.StoreRequest;
import jp.sourceforge.tsukuyomi.openid.message.ax.StoreResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxMessage
implements MessageExtension,
MessageExtensionFactory {
    private static final Log LOG = LogFactory.getLog(AxMessage.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final String OPENID_NS_AX = "http://openid.net/srv/ax/1.0-draft4";
    protected ParameterList parameters;

    public AxMessage() {
        this.parameters = new ParameterList();
        if (DEBUG) {
            LOG.debug((Object)"Created empty AXMessage.");
        }
    }

    public AxMessage(ParameterList params) {
        this.parameters = params;
        if (DEBUG) {
            LOG.debug((Object)("Created AXMessage from parameter list:\n" + params));
        }
    }

    public String getTypeUri() {
        return OPENID_NS_AX;
    }

    public ParameterList getParameters() {
        return this.parameters;
    }

    public String getParameterValue(String name) {
        return this.parameters.getParameterValue(name);
    }

    public void setParameters(ParameterList params) {
        this.parameters = params;
    }

    public String multivalEncode(String value) {
        return value.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,");
    }

    public String multivalDecode(String value) {
        return value.replaceAll("\\\\,", ",").replaceAll("\\\\\\\\", "\\\\");
    }

    public boolean providesIdentifier() {
        return false;
    }

    public MessageExtension getExtension(ParameterList parameterList, boolean isRequest) throws MessageException {
        String axMode = null;
        if (parameterList.hasParameter("mode")) {
            axMode = parameterList.getParameterValue("mode");
            if ("fetch_request".equals(axMode)) {
                return FetchRequest.createFetchRequest(parameterList);
            }
            if ("fetch_response".equals(axMode)) {
                return FetchResponse.createFetchResponse(parameterList);
            }
            if ("store_request".equals(axMode)) {
                return StoreRequest.createStoreRequest(parameterList);
            }
            if ("store_response".equals(axMode)) {
                return StoreResponse.createStoreResponse(parameterList);
            }
        }
        throw new MessageException("Invalid value for attribute exchange mode: " + axMode);
    }
}

