/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.association;

import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import jp.sourceforge.tsukuyomi.openid.association.AssociationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Association
implements Serializable {
    private static final long serialVersionUID = 1683487719331303148L;
    private static final Log LOG = LogFactory.getLog(Association.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final String FAILED_ASSOC_HANDLE = " ";
    public static final String TYPE_HMAC_SHA1 = "HMAC-SHA1";
    public static final String TYPE_HMAC_SHA256 = "HMAC-SHA256";
    public static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    public static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    public static final int HMAC_SHA1_KEYSIZE = 160;
    public static final int HMAC_SHA256_KEYSIZE = 256;
    private String type;
    private String handle;
    private SecretKey macKey;
    private Date expiry;

    private Association(String type, String handle, SecretKey macKey, Date expiry) {
        if (DEBUG) {
            LOG.debug((Object)("Creating association, type: " + type + " handle: " + handle + " expires: " + expiry));
        }
        this.type = type;
        this.handle = handle;
        this.macKey = macKey;
        this.expiry = expiry;
    }

    private Association(String type, String handle, SecretKey macKey, int expiryIn) {
        this(type, handle, macKey, new Date(System.currentTimeMillis() + (long)expiryIn * 1000L));
    }

    public static Association getFailedAssociation(int expiryIn) {
        return new Association(null, FAILED_ASSOC_HANDLE, null, new Date(System.currentTimeMillis() + (long)expiryIn * 1000L));
    }

    public static Association generate(String type, String handle, int expiryIn) throws AssociationException {
        if (TYPE_HMAC_SHA1.equals(type)) {
            return Association.generateHmacSha1(handle, expiryIn);
        }
        if (TYPE_HMAC_SHA256.equals(type)) {
            return Association.generateHmacSha256(handle, expiryIn);
        }
        throw new AssociationException("Unknown association type: " + type);
    }

    public static Association generateHmacSha1(String handle, int expiryIn) {
        SecretKey macKey = Association.generateMacSha1Key();
        if (DEBUG) {
            LOG.debug((Object)("Generated SHA1 MAC key: " + macKey));
        }
        return new Association(TYPE_HMAC_SHA1, handle, macKey, expiryIn);
    }

    public static Association createHmacSha1(String handle, byte[] macKeyBytes, int expiryIn) {
        SecretKey macKey = Association.createMacKey(HMAC_SHA1_ALGORITHM, macKeyBytes);
        return new Association(TYPE_HMAC_SHA1, handle, macKey, expiryIn);
    }

    public static Association createHmacSha1(String handle, byte[] macKeyBytes, Date expDate) {
        SecretKey macKey = Association.createMacKey(HMAC_SHA1_ALGORITHM, macKeyBytes);
        return new Association(TYPE_HMAC_SHA1, handle, macKey, expDate);
    }

    public static Association generateHmacSha256(String handle, int expiryIn) {
        SecretKey macKey = Association.generateMacSha256Key();
        if (DEBUG) {
            LOG.debug((Object)("Generated SHA256 MAC key: " + macKey));
        }
        return new Association(TYPE_HMAC_SHA256, handle, macKey, expiryIn);
    }

    public static Association createHmacSha256(String handle, byte[] macKeyBytes, int expiryIn) {
        SecretKey macKey = Association.createMacKey(HMAC_SHA256_ALGORITHM, macKeyBytes);
        return new Association(TYPE_HMAC_SHA256, handle, macKey, expiryIn);
    }

    public static Association createHmacSha256(String handle, byte[] macKeyBytes, Date expDate) {
        SecretKey macKey = Association.createMacKey(HMAC_SHA256_ALGORITHM, macKeyBytes);
        return new Association(TYPE_HMAC_SHA256, handle, macKey, expDate);
    }

    protected static SecretKey generateMacKey(String algorithm, int keySize) {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(algorithm);
            keyGen.init(keySize);
            return keyGen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)("Unsupported algorithm: " + algorithm + ", size: " + keySize), (Throwable)e);
            return null;
        }
    }

    protected static SecretKey generateMacSha1Key() {
        return Association.generateMacKey(HMAC_SHA1_ALGORITHM, 160);
    }

    protected static SecretKey generateMacSha256Key() {
        return Association.generateMacKey(HMAC_SHA256_ALGORITHM, 256);
    }

    public static boolean isHmacSupported(String hMacType) {
        String hMacAlgorithm;
        if (TYPE_HMAC_SHA1.equals(hMacType)) {
            hMacAlgorithm = HMAC_SHA1_ALGORITHM;
        } else if (TYPE_HMAC_SHA256.equals(hMacType)) {
            hMacAlgorithm = HMAC_SHA256_ALGORITHM;
        } else {
            return false;
        }
        try {
            KeyGenerator.getInstance(hMacAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        return true;
    }

    public static boolean isHmacSha256Supported() {
        try {
            KeyGenerator.getInstance(HMAC_SHA256_ALGORITHM);
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public static boolean isHmacSha1Supported() {
        try {
            KeyGenerator.getInstance(HMAC_SHA1_ALGORITHM);
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    protected static SecretKey createMacKey(String algorithm, byte[] macKey) {
        return new SecretKeySpec(macKey, algorithm);
    }

    public String getType() {
        return this.type;
    }

    public String getHandle() {
        return this.handle;
    }

    public SecretKey getMacKey() {
        return this.macKey;
    }

    public Date getExpiry() {
        return (Date)this.expiry.clone();
    }

    public boolean hasExpired() {
        Date now = new Date();
        return this.expiry.before(now);
    }

    protected byte[] sign(byte[] data) throws AssociationException {
        try {
            String algorithm = this.macKey.getAlgorithm();
            Mac mac = Mac.getInstance(algorithm);
            mac.init(this.macKey);
            return mac.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new AssociationException("Cannot sign!", e);
        }
    }

    public String sign(String text) throws AssociationException {
        if (DEBUG) {
            LOG.debug((Object)("Computing signature for input data:\n" + text));
        }
        return new String(Base64.encodeBase64((byte[])this.sign(text.getBytes())));
    }

    public boolean verifySignature(String text, String signature) throws AssociationException {
        if (DEBUG) {
            LOG.debug((Object)("Verifying signature: " + signature));
        }
        return signature.equals(this.sign(text));
    }
}

