/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class IO {
    public static HttpURLConnection getConnectionToURI(URI oURI, String sMethod, Map oReqProperties, SSLSocketFactory oSSLFactory, boolean bFollowRedirects, boolean bUseCaches) throws IOException {
        if (sMethod == null || sMethod.equals("")) {
            sMethod = "GET";
        }
        HttpURLConnection oConnection = null;
        try {
            oConnection = (HttpURLConnection)oURI.toURL().openConnection();
            oConnection.setRequestMethod(sMethod);
            oConnection.setInstanceFollowRedirects(bFollowRedirects);
            oConnection.setAllowUserInteraction(false);
            oConnection.setUseCaches(bUseCaches);
            oConnection.setDoInput(true);
            oConnection.setDoOutput(sMethod.equals("POST"));
            if (oReqProperties != null) {
                Set oSet = oReqProperties.entrySet();
                Iterator oIt = oSet.iterator();
                while (oIt.hasNext()) {
                    Map.Entry oProperty = oIt.next();
                    oConnection.addRequestProperty(oProperty.getKey().toString(), oProperty.getValue().toString());
                }
            }
            if (oConnection instanceof HttpsURLConnection && oSSLFactory != null) {
                ((HttpsURLConnection)oConnection).setSSLSocketFactory(oSSLFactory);
            }
            oConnection.connect();
            return oConnection;
        }
        catch (IOException oEx) {
            if (oConnection != null) {
                oConnection.disconnect();
            }
            throw oEx;
        }
    }

    public static HttpURLConnection getConnectionToURI(URI oURI, String sMethod, Map oReqProperties, SSLSocketFactory oSSLFactory, int nFollowRedirects, boolean bUseCaches) throws IOException {
        URI oNextURI = oURI;
        block5: for (int i = 0; i <= nFollowRedirects; ++i) {
            HttpURLConnection oConnection = IO.getConnectionToURI(oNextURI, sMethod, oReqProperties, oSSLFactory, false, bUseCaches);
            int nCode = oConnection.getResponseCode();
            switch (nCode) {
                case 301: 
                case 302: 
                case 303: 
                case 305: {
                    String sURI = oConnection.getHeaderField("Location");
                    try {
                        oNextURI = new URI(sURI);
                        continue block5;
                    }
                    catch (URISyntaxException e) {
                        throw new IOException("Got invalid URI via http redirect from : " + oNextURI.toString() + ", location header = " + sURI);
                    }
                }
                default: {
                    return oConnection;
                }
            }
        }
        throw new IOException("Got too many redirects accessing " + oURI.toString());
    }
}

