/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.message.Message;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthImmediateFailure
extends Message {
    private static final Log LOG = LogFactory.getLog(AuthImmediateFailure.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    protected static final List<String> REQUIRED_FIELDS = Arrays.asList("openid.mode");
    protected static final List<String> OPTIONAL_FIELDS = Arrays.asList("openid.ns", "openid.user_setup_url");

    protected AuthImmediateFailure(String url, String returnTo, boolean compatibility) {
        if (compatibility) {
            this.set("openid.mode", "id_res");
            this.set("openid.user_setup_url", url);
        } else {
            this.set("openid.mode", "setup_needed");
            this.set("openid.ns", "http://specs.openid.net/auth/2.0");
        }
        this.destinationUrl = returnTo;
    }

    protected AuthImmediateFailure(ParameterList params) {
        super(params);
    }

    public static AuthImmediateFailure createAuthImmediateFailure(String url, String returnTo, boolean compatibility) throws MessageException {
        AuthImmediateFailure fail = new AuthImmediateFailure(url, returnTo, compatibility);
        if (!fail.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        return fail;
    }

    public static AuthImmediateFailure createAuthImmediateFailure(ParameterList params) throws MessageException {
        AuthImmediateFailure fail = new AuthImmediateFailure(params);
        if (!fail.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Retrieved auth immediate failure from message parameters:\n" + fail.keyValueFormEncoding()));
        }
        return fail;
    }

    @Override
    public List<String> getRequiredFields() {
        return REQUIRED_FIELDS;
    }

    public boolean isVersion2() {
        return this.hasParameter("openid.ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("openid.ns"));
    }

    public String getUserSetupUrl() {
        return this.getParameterValue("openid.user_setup_url");
    }

    @Override
    public boolean isValid() {
        boolean compatibility;
        if (!super.isValid()) {
            return false;
        }
        boolean bl = compatibility = !this.isVersion2();
        if (compatibility) {
            try {
                new URL(this.getUserSetupUrl());
            }
            catch (MalformedURLException e) {
                LOG.error((Object)"Error verifying auth immediate response validity.", (Throwable)e);
                return false;
            }
            return "id_res".equals(this.getParameterValue("openid.mode"));
        }
        return "setup_needed".equals(this.getParameterValue("openid.mode"));
    }
}

