/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external.servlet;

import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.seasar.framework.container.external.AbstractUnmodifiableExternalContextMap;
import org.seasar.framework.util.AssertionUtil;

public class CookieMap
extends AbstractUnmodifiableExternalContextMap {
    private static final Cookie[] EMPTY_COOKIE = new Cookie[0];
    private final HttpServletRequest request;

    public CookieMap(HttpServletRequest request) {
        AssertionUtil.assertNotNull("request is null.", request);
        this.request = request;
    }

    public boolean containsKey(Object key) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (cookie == null || !cookie.getName().equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                String cookieValue = cookie.getValue();
                if (!value.equals(cookieValue)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        Cookie[] cookies = this.request.getCookies();
        return cookies == null || cookies.length == 0;
    }

    public int size() {
        return this.getCookies().length;
    }

    protected Object getAttribute(String key) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (cookie == null || !cookie.getName().equals(key)) continue;
                return cookie;
            }
        }
        return null;
    }

    protected Iterator getAttributeNames() {
        final Cookie[] cookies = this.getCookies();
        return new Iterator(){
            private int index = 0;

            public boolean hasNext() {
                return this.index < cookies.length;
            }

            public Object next() {
                return cookies[this.index++].getName();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    private Cookie[] getCookies() {
        return this.request.getCookies() != null ? this.request.getCookies() : EMPTY_COOKIE;
    }
}

