/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.controller.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.seasar.cubby.controller.RequestParser;
import org.seasar.cubby.controller.RequestParserSelector;
import org.seasar.framework.container.S2Container;

public class RequestParserSelectorImpl
implements RequestParserSelector {
    private S2Container container;
    private Comparator<RequestParser> requestParserComparator = new Comparator<RequestParser>(){

        @Override
        public int compare(RequestParser reuqestParser1, RequestParser reuqestParser2) {
            return reuqestParser1.getPriority() - reuqestParser2.getPriority();
        }
    };

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public RequestParser select(HttpServletRequest request) {
        S2Container root = this.container.getRoot();
        RequestParser[] requestParsers = (RequestParser[])root.findAllComponents(RequestParser.class);
        List<RequestParser> requestParserList = Arrays.asList(requestParsers);
        Collections.sort(requestParserList, this.requestParserComparator);
        for (RequestParser requestParser : requestParserList) {
            if (!requestParser.isParsable(request)) continue;
            return requestParser;
        }
        return null;
    }
}

