/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.action;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.action.Action;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.util.CubbyUtils;
import org.seasar.cubby.util.QueryStringBuilder;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Redirect
implements ActionResult {
    private static final Logger logger = Logger.getLogger(Redirect.class);
    private static final Map<String, String[]> EMPTY_PARAMETERS = Collections.emptyMap();
    private String path;
    private final String protocol;
    private final int port;
    private Class<? extends Action> actionClass;
    private String methodName;
    private Map<String, String[]> parameters;
    private String characterEncoding;
    private boolean encodeURL = true;

    public Redirect(String path) {
        this(path, null);
    }

    public Redirect(String path, String protocol) {
        this(path, protocol, -1);
    }

    public Redirect(String path, String protocol, int port) {
        this.path = path;
        this.protocol = protocol;
        this.port = port;
    }

    public Redirect(Class<? extends Action> actionClass) {
        this(actionClass, "index");
    }

    public Redirect(Class<? extends Action> actionClass, String methodName) {
        this(actionClass, methodName, EMPTY_PARAMETERS);
    }

    public Redirect(Class<? extends Action> actionClass, String methodName, Map<String, String[]> parameters) {
        this(actionClass, methodName, parameters, null);
    }

    public Redirect(Class<? extends Action> actionClass, String methodName, Map<String, String[]> parameters, String protocol) {
        this(actionClass, methodName, parameters, protocol, -1);
    }

    public Redirect(Class<? extends Action> actionClass, String methodName, Map<String, String[]> parameters, String protocol, int port) {
        this.actionClass = actionClass;
        this.methodName = methodName;
        this.parameters = parameters;
        this.protocol = protocol;
        this.port = port;
    }

    public String getPath(String characterEncoding) {
        if (this.isReverseLookupRedirect()) {
            String redirectPath;
            S2Container container = SingletonS2ContainerFactory.getContainer();
            PathResolver pathResolver = (PathResolver)container.getComponent(PathResolver.class);
            this.path = redirectPath = pathResolver.reverseLookup(this.actionClass, this.methodName, this.parameters, characterEncoding);
        }
        return this.path;
    }

    private boolean isReverseLookupRedirect() {
        return this.actionClass != null && this.methodName != null && this.parameters != null;
    }

    @Override
    public void execute(Action action, Class<? extends Action> actionClass, Method method, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String characterEncoding = this.characterEncoding == null ? request.getCharacterEncoding() : this.characterEncoding;
        String redirectURL = this.calculateRedirectURL(this.getPath(characterEncoding), actionClass, request);
        String encodedRedirectURL = this.encodeURL(redirectURL, response);
        if (logger.isDebugEnabled()) {
            logger.log("DCUB0003", (Object[])new String[]{encodedRedirectURL});
        }
        response.sendRedirect(encodedRedirectURL);
    }

    protected String calculateRedirectURL(String path, Class<? extends Action> actionClass, HttpServletRequest request) {
        try {
            String redirectURL = new URL(path).toExternalForm();
            return redirectURL;
        }
        catch (MalformedURLException e) {
            String redirectURL = this.calculateInternalRedirectURL(path, actionClass, request);
            return redirectURL;
        }
    }

    private String calculateInternalRedirectURL(String path, Class<? extends Action> actionClass, HttpServletRequest request) {
        String redirectPath;
        String contextPath = "/".equals(request.getContextPath()) ? "" : request.getContextPath();
        if (path.startsWith("/")) {
            redirectPath = contextPath + path;
        } else {
            StringBuilder builder;
            String actionDirectory = CubbyUtils.getActionDirectory(actionClass);
            if (StringUtil.isEmpty((String)actionDirectory)) {
                builder = new StringBuilder();
                builder.append(contextPath);
                if (!contextPath.endsWith("/")) {
                    builder.append("/");
                }
                builder.append(path);
                redirectPath = builder.toString();
            } else {
                builder = new StringBuilder();
                builder.append(contextPath);
                if (!contextPath.endsWith("/") && !actionDirectory.startsWith("/")) {
                    builder.append("/");
                }
                builder.append(actionDirectory);
                if (!actionDirectory.endsWith("/")) {
                    builder.append("/");
                }
                builder.append(path);
                redirectPath = builder.toString();
            }
        }
        if (this.protocol == null) {
            return redirectPath;
        }
        try {
            URL currentURL = new URL(request.getRequestURL().toString());
            String redirectProtocol = this.protocol == null ? currentURL.getProtocol() : this.protocol;
            int redirectPort = this.port < 0 ? currentURL.getPort() : this.port;
            URL redirectURL = new URL(redirectProtocol, currentURL.getHost(), redirectPort, redirectPath);
            return redirectURL.toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new IORuntimeException((IOException)e);
        }
    }

    protected String encodeURL(String url, HttpServletResponse response) {
        if (this.encodeURL) {
            return response.encodeRedirectURL(url);
        }
        return url;
    }

    public Redirect noEncodeURL() {
        this.encodeURL = false;
        return this;
    }

    public Redirect param(String paramName, Object paramValue) {
        return this.param(paramName, new String[]{paramValue.toString()});
    }

    public Redirect param(String paramName, Object[] paramValues) {
        return this.param(paramName, this.toStringArray(paramValues));
    }

    public Redirect param(String paramName, String[] paramValues) {
        if (this.isReverseLookupRedirect()) {
            if (this.parameters == EMPTY_PARAMETERS) {
                this.parameters = new HashMap<String, String[]>();
            }
            this.parameters.put(paramName, paramValues);
        } else {
            QueryStringBuilder builder = new QueryStringBuilder(this.path);
            builder.addParam(paramName, paramValues);
            this.path = builder.toString();
        }
        return this;
    }

    private String[] toStringArray(Object[] paramValues) {
        String[] values = new String[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            values[i] = paramValues[i].toString();
        }
        return values;
    }

    public Redirect characterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
        return this;
    }

    @Deprecated
    public String getPath() {
        return this.getPath("UTF-8");
    }
}

