/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory.intertype;

import java.util.HashSet;
import java.util.Set;
import org.seasar.framework.aop.InterType;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.InterTypeDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.IntertypeDefBuilder;
import org.seasar.framework.container.impl.InterTypeDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.ejb.EJB3BusinessMethodDesc;
import org.seasar.framework.ejb.EJB3Desc;
import org.seasar.framework.ejb.EJB3DescFactory;
import org.seasar.framework.ejb.EJB3InterceptorDesc;
import org.seasar.framework.ejb.impl.EJB3InterceptorSupportInterType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3IntertypeDefBuilder
implements IntertypeDefBuilder {
    @Override
    public void appendIntertypeDef(AnnotationHandler annotationHandler, ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        EJB3Desc ejb3Desc = EJB3DescFactory.getEJB3Desc(componentClass);
        if (ejb3Desc == null) {
            return;
        }
        EJB3InterceptorSupportInterType interType = new EJB3InterceptorSupportInterType();
        for (Class<?> interceptorClass : this.getInterceptorClasses(ejb3Desc)) {
            interType.addInterceptor(interceptorClass);
            componentDef.addPropertyDef(this.createPropertyDef(annotationHandler, interceptorClass));
        }
        componentDef.addInterTypeDef((InterTypeDef)new InterTypeDefImpl((InterType)interType));
    }

    protected Set<Class<?>> getInterceptorClasses(EJB3Desc ejb3desc) {
        HashSet interceptorClasses = new HashSet();
        for (EJB3InterceptorDesc interceptorDesc : ejb3desc.getInterceptors()) {
            interceptorClasses.add(interceptorDesc.getInterceptorClass());
        }
        for (EJB3BusinessMethodDesc methodDesc : ejb3desc.getBusinessMethods()) {
            for (EJB3InterceptorDesc interceptorDesc : methodDesc.getInterceptors()) {
                interceptorClasses.add(interceptorDesc.getInterceptorClass());
            }
        }
        return interceptorClasses;
    }

    protected PropertyDef createPropertyDef(AnnotationHandler annotationHandler, Class<?> interceptorClass) {
        PropertyDefImpl propDef = new PropertyDefImpl(EJB3InterceptorSupportInterType.getFieldName(interceptorClass));
        propDef.setChildComponentDef(this.createInterceptorComonentDef(annotationHandler, interceptorClass));
        return propDef;
    }

    protected ComponentDef createInterceptorComonentDef(AnnotationHandler annotationHandler, Class<?> interceptorClass) {
        ComponentDef interceptorCd = annotationHandler.createComponentDef(interceptorClass, null);
        annotationHandler.appendDI(interceptorCd);
        annotationHandler.appendInitMethod(interceptorCd);
        annotationHandler.appendDestroyMethod(interceptorCd);
        annotationHandler.appendAspect(interceptorCd);
        annotationHandler.appendInterType(interceptorCd);
        return interceptorCd;
    }
}

