/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.Converter;
import org.seasar.framework.beans.ConverterRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.converter.DateConverter;
import org.seasar.framework.beans.converter.NumberConverter;
import org.seasar.framework.beans.converter.SqlDateConverter;
import org.seasar.framework.beans.converter.TimeConverter;
import org.seasar.framework.beans.converter.TimestampConverter;
import org.seasar.framework.beans.factory.BeanDescFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCopy<S extends AbstractCopy<S>> {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected String[] includePropertyNames = EMPTY_STRING_ARRAY;
    protected String[] excludePropertyNames = EMPTY_STRING_ARRAY;
    protected boolean excludesNull = false;
    protected boolean excludesWhitespace = false;
    protected String prefix;
    protected char beanDelimiter = (char)36;
    protected char mapDelimiter = (char)46;
    protected Map<String, Converter> converterMap = new HashMap<String, Converter>();
    protected List<Converter> converters = new ArrayList<Converter>();

    public S includes(String ... propertyNames) {
        this.includePropertyNames = propertyNames;
        return (S)this;
    }

    public S excludes(String ... propertyNames) {
        this.excludePropertyNames = propertyNames;
        return (S)this;
    }

    public S excludesNull() {
        this.excludesNull = true;
        return (S)this;
    }

    public S excludesWhitespace() {
        this.excludesWhitespace = true;
        return (S)this;
    }

    public S prefix(String prefix) {
        this.prefix = prefix;
        return (S)this;
    }

    public S beanDelimiter(char beanDelimiter) {
        this.beanDelimiter = beanDelimiter;
        return (S)this;
    }

    public S mapDelimiter(char mapDelimiter) {
        this.mapDelimiter = mapDelimiter;
        return (S)this;
    }

    public S converter(Converter converter, String ... propertyNames) {
        if (propertyNames.length == 0) {
            this.converters.add(converter);
        } else {
            for (String name : propertyNames) {
                this.converterMap.put(name, converter);
            }
        }
        return (S)this;
    }

    public S dateConverter(String pattern, String ... propertyNames) {
        return this.converter((Converter)new DateConverter(pattern), propertyNames);
    }

    public S sqlDateConverter(String pattern, String ... propertyNames) {
        return this.converter((Converter)new SqlDateConverter(pattern), propertyNames);
    }

    public S timeConverter(String pattern, String ... propertyNames) {
        return this.converter((Converter)new TimeConverter(pattern), propertyNames);
    }

    public S timestampConverter(String pattern, String ... propertyNames) {
        return this.converter((Converter)new TimestampConverter(pattern), propertyNames);
    }

    public S numberConverter(String pattern, String ... propertyNames) {
        return this.converter((Converter)new NumberConverter(pattern), propertyNames);
    }

    protected boolean isTargetProperty(String name) {
        if (this.prefix != null && !name.startsWith(this.prefix)) {
            return false;
        }
        if (this.includePropertyNames.length > 0) {
            for (String s : this.includePropertyNames) {
                if (!s.equals(name)) continue;
                for (String s2 : this.excludePropertyNames) {
                    if (!s2.equals(name)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.excludePropertyNames.length > 0) {
            for (String s : this.excludePropertyNames) {
                if (!s.equals(name)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    protected void copyBeanToBean(Object src, Object dest) {
        BeanDesc srcBeanDesc = BeanDescFactory.getBeanDesc(src.getClass());
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        int size = srcBeanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            Object value;
            PropertyDesc destPropertyDesc;
            String destPropertyName;
            PropertyDesc srcPropertyDesc = srcBeanDesc.getPropertyDesc(i);
            String srcPropertyName = srcPropertyDesc.getPropertyName();
            if (!srcPropertyDesc.isReadable() || !this.isTargetProperty(srcPropertyName) || !destBeanDesc.hasPropertyDesc(destPropertyName = this.trimPrefix(srcPropertyName)) || !(destPropertyDesc = destBeanDesc.getPropertyDesc(destPropertyName)).isWritable() || (value = srcPropertyDesc.getValue(src)) instanceof String && this.excludesWhitespace && ((String)value).trim().length() == 0 || value == null && this.excludesNull) continue;
            value = this.convertValue(value, destPropertyName, destPropertyDesc.getPropertyType());
            destPropertyDesc.setValue(dest, value);
        }
    }

    protected void copyBeanToMap(Object src, Map dest) {
        BeanDesc srcBeanDesc = BeanDescFactory.getBeanDesc(src.getClass());
        int size = srcBeanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            Object value;
            PropertyDesc srcPropertyDesc = srcBeanDesc.getPropertyDesc(i);
            String srcPropertyName = srcPropertyDesc.getPropertyName();
            if (!srcPropertyDesc.isReadable() || !this.isTargetProperty(srcPropertyName) || (value = srcPropertyDesc.getValue(src)) instanceof String && this.excludesWhitespace && ((String)value).trim().length() == 0 || value == null && this.excludesNull) continue;
            String destPropertyName = this.trimPrefix(srcPropertyName.replace(this.beanDelimiter, this.mapDelimiter));
            value = this.convertValue(value, destPropertyName, null);
            dest.put(destPropertyName, value);
        }
    }

    protected void copyMapToBean(Map<String, Object> src, Object dest) {
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        for (String srcPropertyName : src.keySet()) {
            Object value;
            PropertyDesc destPropertyDesc;
            String destPropertyName;
            if (!this.isTargetProperty(srcPropertyName) || !destBeanDesc.hasPropertyDesc(destPropertyName = this.trimPrefix(srcPropertyName.replace(this.mapDelimiter, this.beanDelimiter))) || !(destPropertyDesc = destBeanDesc.getPropertyDesc(destPropertyName)).isWritable() || (value = src.get(srcPropertyName)) instanceof String && this.excludesWhitespace && ((String)value).trim().length() == 0 || value == null && this.excludesNull) continue;
            value = this.convertValue(value, destPropertyName, destPropertyDesc.getPropertyType());
            destPropertyDesc.setValue(dest, value);
        }
    }

    protected void copyMapToMap(Map<String, Object> src, Map<String, Object> dest) {
        for (String srcPropertyName : src.keySet()) {
            if (!this.isTargetProperty(srcPropertyName)) continue;
            String destPropertyName = this.trimPrefix(srcPropertyName);
            Object value = src.get(srcPropertyName);
            if (value instanceof String && this.excludesWhitespace && ((String)value).trim().length() == 0 || value == null && this.excludesNull) continue;
            value = this.convertValue(value, destPropertyName, null);
            dest.put(destPropertyName, value);
        }
    }

    protected String trimPrefix(String propertyName) {
        if (this.prefix == null) {
            return propertyName;
        }
        return propertyName.substring(this.prefix.length());
    }

    protected Object convertValue(Object value, String destPropertyName, Class<?> destPropertyClass) {
        if (value == null) {
            return null;
        }
        Converter converter = this.converterMap.get(destPropertyName);
        if (converter == null) {
            Class<?> targetClass;
            Class<?> clazz = targetClass = value.getClass() != String.class ? value.getClass() : destPropertyClass;
            if (targetClass == null) {
                return value;
            }
            for (Class<?> clazz2 = targetClass; clazz2 != Object.class && clazz2 != null && (converter = this.findConverter(clazz2)) == null; clazz2 = clazz2.getSuperclass()) {
            }
            if (converter == null) {
                return value;
            }
        }
        try {
            if (value.getClass() == String.class) {
                return converter.getAsObject((String)value);
            }
            return converter.getAsString(value);
        }
        catch (Throwable cause) {
            throw new ConverterRuntimeException(destPropertyName, value, cause);
        }
    }

    protected Converter findConverter(Class<?> clazz) {
        for (Converter c : this.converters) {
            if (!c.isTarget(clazz)) continue;
            return c;
        }
        return null;
    }
}

