/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.states.RowStates;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.impl.PropertyTypeUtil;

public class DataRowReloadResultSetHandler
implements ResultSetHandler {
    private DataRow newRow;

    public DataRowReloadResultSetHandler(DataRow newRow) {
        this.newRow = newRow;
    }

    public DataRow getNewRow() {
        return this.newRow;
    }

    public Object handle(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        PropertyType[] propertyTypes = PropertyTypeUtil.createPropertyTypes(rsmd);
        if (rs.next()) {
            this.reload(rs, propertyTypes);
        }
        return this.newRow;
    }

    private void reload(ResultSet rs, PropertyType[] propertyTypes) throws SQLException {
        for (int i = 0; i < propertyTypes.length; ++i) {
            Object value = propertyTypes[i].getValueType().getValue(rs, i + 1);
            this.newRow.setValue(propertyTypes[i].getColumnName(), value);
        }
        this.newRow.setState(RowStates.UNCHANGED);
    }
}

