/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.ejb.impl;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.seasar.framework.ejb.EJB3Desc;
import org.seasar.framework.ejb.EJB3InterceptorDesc;
import org.seasar.framework.ejb.SEJBException;
import org.seasar.framework.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3InterceptorDescImpl
implements EJB3InterceptorDesc {
    protected EJB3Desc ejb3desc;
    protected Class<?> interceptorClass;
    protected LinkedList<Method> interceptorMethods = new LinkedList();
    protected LinkedList<Method> postConstructMethods = new LinkedList();

    public EJB3InterceptorDescImpl(EJB3Desc ejb3desc, Class<?> interceptorClass) {
        this.ejb3desc = ejb3desc;
        this.interceptorClass = interceptorClass;
        ClassUtil.getConstructor(interceptorClass, null);
        this.detectInterceptorMethods();
        this.detectPostConstructMethod();
        if (this.interceptorMethods.isEmpty() && this.postConstructMethods.isEmpty()) {
            throw new SEJBException("ESSR0410", interceptorClass.getName());
        }
    }

    @Override
    public EJB3Desc getEJB3Desc() {
        return this.ejb3desc;
    }

    @Override
    public Class<?> getInterceptorClass() {
        return this.interceptorClass;
    }

    @Override
    public List<Method> getInterceptorMethods() {
        return this.interceptorMethods;
    }

    @Override
    public List<Method> getPostConstructMethods() {
        return this.postConstructMethods;
    }

    protected void detectInterceptorMethods() {
        HashSet<String> methods = new HashSet<String>();
        for (Class<?> clazz = this.interceptorClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                String methodName;
                Class<?>[] paramTypes;
                if (method.isBridge() || method.isSynthetic() || (paramTypes = method.getParameterTypes()).length != 1 || paramTypes[0] != InvocationContext.class || method.getReturnType() != Object.class || methods.contains(methodName = method.getName())) continue;
                methods.add(methodName);
                AroundInvoke aroundInvoke = method.getAnnotation(AroundInvoke.class);
                if (aroundInvoke == null) continue;
                this.interceptorMethods.addFirst(method);
            }
        }
    }

    protected void detectPostConstructMethod() {
        HashSet<String> methods = new HashSet<String>();
        for (Class<?> clazz = this.interceptorClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                String methodName;
                Class<?>[] paramTypes;
                if (method.isBridge() || (paramTypes = method.getParameterTypes()).length != 1 || paramTypes[0] != InvocationContext.class || method.getReturnType() != Void.TYPE || methods.contains(methodName = method.getName())) continue;
                methods.add(methodName);
                PostConstruct postConstruct = method.getAnnotation(PostConstruct.class);
                if (postConstruct == null) continue;
                this.postConstructMethods.addFirst(method);
            }
        }
    }
}

