/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.sql.PreparedStatement;
import java.sql.Statement;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.Update;
import org.seasar.extension.jdbc.exception.SEntityExistsException;
import org.seasar.extension.jdbc.exception.SOptimisticLockException;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractQuery;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAutoUpdate<T, S extends Update<S>>
extends AbstractQuery<S>
implements Update<S> {
    protected final T entity;
    protected final EntityMeta entityMeta;
    protected boolean suppresOptimisticLockException;

    public AbstractAutoUpdate(JdbcManagerImplementor jdbcManager, T entity) {
        super(jdbcManager);
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        this.entity = entity;
        this.entityMeta = jdbcManager.getEntityMetaFactory().getEntityMeta(entity.getClass());
    }

    public T getEntity() {
        return this.entity;
    }

    public EntityMeta getEntityMeta() {
        return this.entityMeta;
    }

    @Override
    public int execute() {
        this.prepare("execute");
        try {
            return this.executeInternal();
        }
        catch (RuntimeException e) {
            if (this.getJdbcManager().getDialect().isUniqueConstraintViolation(e)) {
                throw new SEntityExistsException(this.entity, this.executedSql, e);
            }
            throw e;
        }
    }

    protected void prepareSql() {
        this.executedSql = this.toSql();
    }

    protected abstract String toSql();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeInternal() {
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            this.logSql();
            PreparedStatement ps = this.getPreparedStatement(jdbcContext);
            int rows = PreparedStatementUtil.executeUpdate((PreparedStatement)ps);
            this.postExecute(ps);
            if (this.isOptimisticLock()) {
                this.validateRows(rows);
            }
            if (this.entityMeta.hasVersionPropertyMeta()) {
                this.incrementVersion();
            }
            int n = rows;
            return n;
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
    }

    protected PreparedStatement getPreparedStatement(JdbcContext jdbcContext) {
        PreparedStatement ps = this.createPreparedStatement(jdbcContext);
        if (this.queryTimeout > 0) {
            StatementUtil.setQueryTimeout((Statement)ps, (int)this.queryTimeout);
        }
        this.prepareInParams(ps);
        return ps;
    }

    protected PreparedStatement createPreparedStatement(JdbcContext jdbcContext) {
        return jdbcContext.getPreparedStatement(this.executedSql);
    }

    protected void postExecute(PreparedStatement ps) {
    }

    protected abstract boolean isOptimisticLock();

    protected void validateRows(int rows) {
        if (!this.suppresOptimisticLockException && rows == 0) {
            throw new SOptimisticLockException(this.entity);
        }
    }

    protected void incrementVersion() {
    }
}

