/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.cubby.validator.MessageHelper;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;
import org.seasar.framework.util.StringUtil;

public class RegexpValidator
implements ScalarFieldValidator {
    private final MessageHelper messageHelper;
    private final Pattern pattern;

    public RegexpValidator(String regex) {
        this(regex, "valid.regexp");
    }

    public RegexpValidator(String regex, String messageKey) {
        this(Pattern.compile(regex), messageKey);
    }

    public RegexpValidator(Pattern pattern) {
        this(pattern, "valid.regexp");
    }

    public RegexpValidator(Pattern pattern, String messageKey) {
        this.pattern = pattern;
        this.messageHelper = new MessageHelper(messageKey);
    }

    public void validate(ValidationContext context, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (StringUtil.isEmpty((String)stringValue)) {
                return;
            }
            Matcher matcher = this.pattern.matcher(stringValue);
            if (matcher.matches()) {
                return;
            }
        }
        context.addMessageInfo(this.messageHelper.createMessageInfo(new Object[0]));
    }
}

