/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.cubby.action.FormatPattern;
import org.seasar.cubby.controller.CubbyConfiguration;
import org.seasar.cubby.controller.ThreadContext;
import org.seasar.cubby.validator.MessageHelper;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.StringUtil;

public class DateFormatValidator
implements ScalarFieldValidator {
    private final MessageHelper messageHelper;
    private final String pattern;

    public DateFormatValidator() {
        this(null);
    }

    public DateFormatValidator(String pattern) {
        this(pattern, "valid.dateFormat");
    }

    public DateFormatValidator(String pattern, String messageKey) {
        this.pattern = pattern;
        this.messageHelper = new MessageHelper(messageKey);
    }

    public void validate(ValidationContext context, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (StringUtil.isEmpty((String)((String)value))) {
                return;
            }
            try {
                DateFormat dateFormat = this.createDateFormat(context, value);
                ParsePosition parsePosition = new ParsePosition(0);
                Date date = dateFormat.parse(stringValue, parsePosition);
                if (date != null && parsePosition.getIndex() == stringValue.length()) {
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        context.addMessageInfo(this.messageHelper.createMessageInfo(new Object[0]));
    }

    private DateFormat createDateFormat(ValidationContext context, Object value) {
        String pattern;
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        if (StringUtil.isEmpty((String)this.pattern)) {
            CubbyConfiguration configuration = ThreadContext.getConfiguration();
            FormatPattern formatPattern = configuration.getFormatPattern();
            if (formatPattern == null) {
                throw new SRuntimeException("ECUB0301", new Object[]{this, value});
            }
            pattern = formatPattern.getDatePattern();
        } else {
            pattern = this.pattern;
        }
        dateFormat.applyPattern(pattern);
        dateFormat.setLenient(false);
        return dateFormat;
    }
}

