/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator;

import org.seasar.cubby.util.Messages;

public class MessageInfo {
    private String key;
    private Object[] arguments;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object[] getArguments() {
        if (this.arguments == null) {
            return null;
        }
        return (Object[])this.arguments.clone();
    }

    public void setArguments(Object ... arguments) {
        this.arguments = arguments;
    }

    public MessageBuilder builder() {
        MessageBuilder builder = new MessageBuilder(this.key, this.arguments);
        return builder;
    }

    public class MessageBuilder {
        private final String messageKey;
        private final Object[] arguments;
        private String fieldNameKey;

        private MessageBuilder(String messageKey, Object[] arguments) {
            this.messageKey = messageKey;
            this.arguments = arguments;
        }

        public MessageBuilder fieldNameKey(String fieldNameKey) {
            this.fieldNameKey = fieldNameKey;
            return this;
        }

        public String toString() {
            Object[] args;
            if (this.fieldNameKey != null) {
                args = new Object[this.arguments.length + 1];
                String paramNameText = Messages.getText(this.fieldNameKey, new Object[0]);
                args[0] = paramNameText;
                System.arraycopy(this.arguments, 0, args, 1, this.arguments.length);
            } else {
                args = this.arguments;
            }
            return Messages.getText(this.messageKey, args);
        }
    }
}

