/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.action.Forward;
import org.seasar.cubby.exception.ActionRuntimeException;
import org.seasar.cubby.validator.FieldValidationRule;
import org.seasar.cubby.validator.ValidationPhase;
import org.seasar.cubby.validator.ValidationRule;
import org.seasar.cubby.validator.ValidationRules;
import org.seasar.cubby.validator.Validator;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultValidationRules
implements ValidationRules {
    public static final ValidationPhase DATA_TYPE = new ValidationPhase();
    public static final ValidationPhase DATA_CONSTRAINT = new ValidationPhase();
    private final Map<ValidationPhase, List<ValidationRule>> phaseValidationRulesMap = new HashMap<ValidationPhase, List<ValidationRule>>();
    private final String resourceKeyPrefix;
    private static final List<ValidationPhase> VALIDATION_PHASES = Arrays.asList(DATA_TYPE, DATA_CONSTRAINT);

    public DefaultValidationRules() {
        this(null);
    }

    public DefaultValidationRules(String resourceKeyPrefix) {
        this.resourceKeyPrefix = resourceKeyPrefix;
        this.initialize();
    }

    protected abstract void initialize();

    protected void add(ValidationPhase validationPhase, ValidationRule validationRule) {
        if (!this.phaseValidationRulesMap.containsKey(validationPhase)) {
            this.phaseValidationRulesMap.put(validationPhase, new ArrayList());
        }
        List<ValidationRule> validationRules = this.phaseValidationRulesMap.get(validationPhase);
        validationRules.add(validationRule);
    }

    protected void add(ValidationRule validationRule) {
        this.add((ValidationPhase)this.getValidationPhases().get(0), validationRule);
    }

    protected void add(String paramName, Validator ... validators) {
        this.add(paramName, paramName, validators);
    }

    protected void add(String paramName, String paramNameMessageKey, Validator ... validators) {
        this.add((ValidationPhase)this.getValidationPhases().get(0), new FieldValidationRule(paramName, this.makePropertyNameKey(paramNameMessageKey), validators));
    }

    protected void addAll(ValidationRules validationRules) {
        for (ValidationPhase validationPhase : validationRules.getValidationPhases()) {
            Collection<ValidationRule> phaseValidationRules = validationRules.getPhaseValidationRules(validationPhase);
            for (ValidationRule validationRule : phaseValidationRules) {
                this.add(validationPhase, validationRule);
            }
        }
    }

    private String makePropertyNameKey(String messageKey) {
        if (this.resourceKeyPrefix == null) {
            return messageKey;
        }
        return this.resourceKeyPrefix + messageKey;
    }

    @Override
    public ActionResult fail(String errorPage) {
        if (StringUtil.isEmpty((String)errorPage)) {
            throw new ActionRuntimeException("ECUB0106");
        }
        return new Forward(errorPage);
    }

    public List<ValidationPhase> getValidationPhases() {
        return VALIDATION_PHASES;
    }

    @Override
    public Collection<ValidationRule> getPhaseValidationRules(ValidationPhase validationPhase) {
        Collection<ValidationRule> phaseValidationRules = this.phaseValidationRulesMap.containsKey(validationPhase) ? (Collection)this.phaseValidationRulesMap.get(validationPhase) : Collections.emptyList();
        return phaseValidationRules;
    }

    @Override
    @Deprecated
    public List<ValidationRule> getRules() {
        return this.phaseValidationRulesMap.get(this.getValidationPhases().get(0));
    }

    public boolean isFail(String name) {
        return false;
    }

    public boolean isFail(ValidationRule rule) {
        return false;
    }
}

