/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.SimpleTag;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.tags.CubbyFunctions;
import org.seasar.cubby.tags.DynamicAttributesTagSupport;
import org.seasar.cubby.tags.TagUtils;

public class TextareaTag
extends DynamicAttributesTagSupport {
    private String name;
    private Object value;
    private Integer index;

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void doTag() throws JspException, IOException {
        JspContext context = this.getJspContext();
        JspWriter out = context.getOut();
        ActionErrors errors = TagUtils.errors(context);
        Map<String, Object> dyn = this.getDynamicAttribute();
        String[] outputValues = TagUtils.getOutputValues((SimpleTag)this, this.name);
        if (this.index == null) {
            if (!errors.getFields().get(this.name).isEmpty()) {
                TagUtils.addClassName(dyn, "fieldError");
            }
        } else if (!errors.getIndexedFields().get(this.name).get(this.index).isEmpty()) {
            TagUtils.addClassName(dyn, "fieldError");
        }
        Object value = TagUtils.formValue(context, outputValues, this.name, this.index, this.value);
        out.write("<textarea name=\"");
        out.write(this.name);
        out.write("\" ");
        out.write(TagUtils.toAttr(dyn));
        out.write(">");
        out.write(CubbyFunctions.out(value));
        out.write("</textarea>");
    }
}

