/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.routing.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.cubby.action.Action;
import org.seasar.cubby.action.RequestMethod;
import org.seasar.cubby.controller.ClassDetector;
import org.seasar.cubby.controller.DetectClassProcessor;
import org.seasar.cubby.exception.ActionRuntimeException;
import org.seasar.cubby.exception.DuplicateRoutingRuntimeException;
import org.seasar.cubby.routing.InternalForwardInfo;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.routing.Routing;
import org.seasar.cubby.routing.impl.InternalForwardInfoImpl;
import org.seasar.cubby.routing.impl.RoutingImpl;
import org.seasar.cubby.util.CubbyUtils;
import org.seasar.cubby.util.QueryStringBuilder;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathResolverImpl
implements PathResolver,
DetectClassProcessor,
Disposable {
    private static final Logger logger = Logger.getLogger(PathResolverImpl.class);
    private static final String DEFAULT_URI_ENCODING = "UTF-8";
    private static Pattern URI_PARAMETER_MATCHING_PATTERN = Pattern.compile("([{]([^}]+)[}])([^{]*)");
    private static final String DEFAULT_URI_PARAMETER_REGEX = "[a-zA-Z0-9]+";
    private boolean initialized;
    private NamingConvention namingConvention;
    private final Comparator<Routing> routingComparator = new RoutingComparator();
    private final Map<Routing, Routing> routings = new TreeMap<Routing, Routing>(this.routingComparator);
    private ClassDetector classDetector;
    private String uriEncoding = "UTF-8";
    private int priorityCounter = 0;

    @Override
    public List<Routing> getRoutings() {
        this.initialize();
        return Collections.unmodifiableList(new ArrayList<Routing>(this.routings.values()));
    }

    public void setClassDetector(ClassDetector classDetector) {
        this.classDetector = classDetector;
    }

    public void setUriEncoding(String uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.classDetector.detect();
        DisposableUtil.add((Disposable)this);
        this.initialized = true;
    }

    public void dispose() {
        ArrayList<Routing> removes = new ArrayList<Routing>();
        for (Routing routing : this.routings.keySet()) {
            if (!routing.isAuto()) continue;
            removes.add(routing);
        }
        for (Routing routing : removes) {
            this.routings.remove(routing);
        }
        this.initialized = false;
    }

    public void add(String actionPath, Class<? extends Action> actionClass, String methodName) {
        this.add(actionPath, actionClass, methodName, new RequestMethod[0]);
    }

    @Override
    public void add(String actionPath, Class<? extends Action> actionClass, String methodName, RequestMethod ... requestMethods) {
        Method method = ClassUtil.getMethod(actionClass, (String)methodName, (Class[])new Class[0]);
        if (requestMethods == null || requestMethods.length == 0) {
            for (RequestMethod requestMethod : CubbyUtils.DEFAULT_ACCEPT_ANNOTATION.value()) {
                this.add(actionPath, actionClass, method, requestMethod, false);
            }
        } else {
            for (RequestMethod requestMethod : requestMethods) {
                this.add(actionPath, actionClass, method, requestMethod, false);
            }
        }
    }

    private void add(String actionPath, Class<? extends Action> actionClass, Method method, RequestMethod requestMethod, boolean auto) {
        int n;
        Matcher matcher = URI_PARAMETER_MATCHING_PATTERN.matcher(actionPath);
        String uriRegex = actionPath;
        ArrayList<String> uriParameterNames = new ArrayList<String>();
        while (matcher.find()) {
            String holder = matcher.group(2);
            String[] tokens = CubbyUtils.split2(holder, ',');
            uriParameterNames.add(tokens[0]);
            String uriParameterRegex = tokens.length == 1 ? DEFAULT_URI_PARAMETER_REGEX : tokens[1];
            uriRegex = StringUtil.replace((String)uriRegex, (String)matcher.group(1), (String)PathResolverImpl.regexGroup(uriParameterRegex));
        }
        uriRegex = "^" + uriRegex + "$";
        Pattern pattern = Pattern.compile(uriRegex);
        String onSubmit = CubbyUtils.getOnSubmit(method);
        if (auto) {
            n = CubbyUtils.getPriority(method);
        } else {
            int n2 = this.priorityCounter;
            n = n2;
            this.priorityCounter = n2 + 1;
        }
        int priority = n;
        RoutingImpl routing = new RoutingImpl(actionClass, method, actionPath, uriParameterNames, pattern, requestMethod, onSubmit, priority, auto);
        if (this.routings.containsKey(routing)) {
            Routing duplication = this.routings.get(routing);
            if (!routing.getActionClass().equals(duplication.getActionClass()) || !routing.getMethod().equals(duplication.getMethod())) {
                throw new DuplicateRoutingRuntimeException("ECUB0001", new Object[]{routing, duplication});
            }
        } else {
            this.routings.put(routing, routing);
            if (logger.isDebugEnabled()) {
                logger.log("DCUB0007", new Object[]{routing});
            }
        }
    }

    @Override
    public InternalForwardInfo getInternalForwardInfo(String path, String requestMethod) {
        String decodedPath;
        this.initialize();
        try {
            decodedPath = URLDecoder.decode(path, this.uriEncoding);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        InternalForwardInfo internalForwardInfo = this.findInternalForwardInfo(decodedPath, requestMethod);
        return internalForwardInfo;
    }

    private InternalForwardInfo findInternalForwardInfo(String path, String requestMethod) {
        Iterator<Routing> iterator = this.routings.values().iterator();
        while (iterator.hasNext()) {
            Routing routing = iterator.next();
            Matcher matcher = routing.getPattern().matcher(path);
            if (!matcher.find() || !routing.isAcceptable(requestMethod)) continue;
            HashMap<String, Routing> onSubmitRoutings = new HashMap<String, Routing>();
            onSubmitRoutings.put(routing.getOnSubmit(), routing);
            while (iterator.hasNext()) {
                Routing anotherRouting = iterator.next();
                if (!routing.getPattern().pattern().equals(anotherRouting.getPattern().pattern()) || !routing.getRequestMethod().equals((Object)anotherRouting.getRequestMethod())) continue;
                onSubmitRoutings.put(anotherRouting.getOnSubmit(), anotherRouting);
            }
            HashMap<String, String[]> uriParameters = new HashMap<String, String[]>();
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String name = routing.getUriParameterNames().get(i);
                String value = matcher.group(i + 1);
                uriParameters.put(name, new String[]{value});
            }
            String inernalFowardPath = this.buildInternalForwardPath(uriParameters);
            InternalForwardInfoImpl internalForwardInfo = new InternalForwardInfoImpl(inernalFowardPath, onSubmitRoutings);
            return internalForwardInfo;
        }
        return null;
    }

    @Override
    public String buildInternalForwardPath(Map<String, String[]> parameters) {
        StringBuilder builder = new StringBuilder(100);
        builder.append("/__internal_forward");
        if (parameters != null && !parameters.isEmpty()) {
            builder.append("?");
            QueryStringBuilder query = new QueryStringBuilder();
            if (!StringUtil.isEmpty((String)this.uriEncoding)) {
                query.setEncode(this.uriEncoding);
            }
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                for (String parameter : entry.getValue()) {
                    query.addParam(entry.getKey(), parameter);
                }
            }
            builder.append(query.toString());
        }
        return builder.toString();
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    private static String regexGroup(String regex) {
        return "(" + regex + ")";
    }

    @Override
    public String reverseLookup(Class<? extends Action> actionClass, String methodName, Map<String, String[]> parameters) {
        Routing routing = this.findRouting(actionClass, methodName);
        String actionPath = routing.getActionPath();
        Matcher matcher = URI_PARAMETER_MATCHING_PATTERN.matcher(actionPath);
        HashMap<String, String[]> copyOfParameters = new HashMap<String, String[]>(parameters);
        String redirectPath = actionPath;
        while (matcher.find()) {
            String uriParameterRegex;
            String holder = matcher.group(2);
            String[] tokens = CubbyUtils.split2(holder, ',');
            String uriParameterName = tokens[0];
            if (!copyOfParameters.containsKey(uriParameterName)) {
                throw new ActionRuntimeException("ECUB0104", new Object[]{actionPath, uriParameterName});
            }
            String value = ((String[])copyOfParameters.remove(uriParameterName))[0];
            if (!value.matches(uriParameterRegex = tokens.length == 1 ? DEFAULT_URI_PARAMETER_REGEX : tokens[1])) {
                throw new ActionRuntimeException("ECUB0105", new Object[]{actionPath, uriParameterName, value, uriParameterRegex});
            }
            try {
                String encodedValue = URLEncoder.encode(value, this.uriEncoding);
                redirectPath = StringUtil.replace((String)redirectPath, (String)matcher.group(1), (String)encodedValue);
            }
            catch (UnsupportedEncodingException e) {
                throw new IORuntimeException((IOException)e);
            }
        }
        if (!copyOfParameters.isEmpty()) {
            QueryStringBuilder builder = new QueryStringBuilder();
            builder.setEncode(this.uriEncoding);
            for (Map.Entry entry : copyOfParameters.entrySet()) {
                for (String value : (String[])entry.getValue()) {
                    builder.addParam((String)entry.getKey(), value);
                }
            }
            redirectPath = redirectPath + "?" + builder.toString();
        }
        return redirectPath;
    }

    private Routing findRouting(Class<? extends Action> actionClass, String methodName) {
        for (Routing routing : this.routings.values()) {
            if (!actionClass.getCanonicalName().equals(routing.getActionClass().getCanonicalName()) || !methodName.equals(routing.getMethod().getName())) continue;
            return routing;
        }
        throw new ActionRuntimeException("ECUB0103", new Object[]{actionClass, methodName});
    }

    @Override
    public void processClass(String packageName, String shortClassName) {
        if (shortClassName.indexOf(36) != -1) {
            return;
        }
        String className = ClassUtil.concatName((String)packageName, (String)shortClassName);
        if (!this.namingConvention.isTargetClassName(className)) {
            return;
        }
        if (!className.endsWith(this.namingConvention.getActionSuffix())) {
            return;
        }
        Class clazz = ClassUtil.forName((String)className);
        if (this.namingConvention.isSkipClass(clazz)) {
            return;
        }
        if (!CubbyUtils.isActionClass(clazz)) {
            return;
        }
        Class<? extends Action> actionClass = PathResolverImpl.cast(clazz);
        for (Method method : clazz.getMethods()) {
            RequestMethod[] acceptableRequestMethods;
            if (!CubbyUtils.isActionMethod(method)) continue;
            String actionPath = CubbyUtils.getActionPath(actionClass, method);
            for (RequestMethod requestMethod : acceptableRequestMethods = CubbyUtils.getAcceptableRequestMethods(clazz, method)) {
                this.add(actionPath, actionClass, method, requestMethod, true);
            }
        }
    }

    private static Class<? extends Action> cast(Class<?> clazz) {
        return clazz;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RoutingComparator
    implements Comparator<Routing> {
        RoutingComparator() {
        }

        @Override
        public int compare(Routing routing1, Routing routing2) {
            int compare = routing1.getPriority() - routing2.getPriority();
            if (compare != 0) {
                return compare;
            }
            compare = routing1.getUriParameterNames().size() - routing2.getUriParameterNames().size();
            if (compare != 0) {
                return compare;
            }
            compare = routing1.getPattern().pattern().compareTo(routing2.getPattern().pattern());
            if (compare != 0) {
                return compare;
            }
            compare = routing1.getRequestMethod().compareTo(routing2.getRequestMethod());
            if (compare != 0) {
                return compare;
            }
            compare = routing1.getOnSubmit() == routing2.getOnSubmit() ? 0 : (routing1.getOnSubmit() == null ? -1 : (routing2.getOnSubmit() == null ? 1 : routing1.getOnSubmit().compareTo(routing2.getOnSubmit())));
            return compare;
        }
    }
}

