/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.converter.impl;

import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import org.seasar.cubby.converter.ConversionHelper;
import org.seasar.cubby.converter.impl.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDateConverter
extends AbstractConverter {
    @Override
    public Class<?> getObjectType() {
        return Date.class;
    }

    @Override
    public Object convertToObject(Object value, Class<?> objectType, ConversionHelper helper) {
        if (value == null) {
            return null;
        }
        DateFormat dateFormat = helper.getFormatPattern().getDateFormat();
        return this.toDate((String)value, dateFormat);
    }

    protected Date toDate(String date, DateFormat dateFormat) {
        if (date == null || date.length() == 0) {
            return null;
        }
        try {
            return new Date(dateFormat.parse(date).getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public String convertToString(Object value, ConversionHelper helper) {
        if (value == null) {
            return null;
        }
        DateFormat formatter = helper.getFormatPattern().getDateFormat();
        return formatter.format((Date)value);
    }
}

