/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.ResourceNotFoundRuntimeException;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.URLUtil;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static String getResourcePath(String path, String extension) {
        if (extension == null) {
            return path;
        }
        extension = "." + extension;
        if (path.endsWith(extension)) {
            return path;
        }
        return path.replace('.', '/') + extension;
    }

    public static String getResourcePath(Class clazz) {
        return clazz.getName().replace('.', '/') + ".class";
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static URL getResource(String path) {
        return ResourceUtil.getResource(path, null);
    }

    public static URL getResource(String path, String extension) throws ResourceNotFoundRuntimeException {
        URL url = ResourceUtil.getResourceNoException(path, extension);
        if (url != null) {
            return url;
        }
        throw new ResourceNotFoundRuntimeException(ResourceUtil.getResourcePath(path, extension));
    }

    public static URL getResourceNoException(String path) {
        return ResourceUtil.getResourceNoException(path, null);
    }

    public static URL getResourceNoException(String path, String extension) {
        return ResourceUtil.getResourceNoException(path, extension, Thread.currentThread().getContextClassLoader());
    }

    public static URL getResourceNoException(String path, String extension, ClassLoader loader) {
        if (path == null || loader == null) {
            return null;
        }
        path = ResourceUtil.getResourcePath(path, extension);
        return loader.getResource(path);
    }

    public static InputStream getResourceAsStream(String path) {
        return ResourceUtil.getResourceAsStream(path, null);
    }

    public static InputStream getResourceAsStream(String path, String extension) {
        URL url = ResourceUtil.getResource(path, extension);
        return URLUtil.openStream(url);
    }

    public static InputStream getResourceAsStreamNoException(String path) {
        return ResourceUtil.getResourceAsStreamNoException(path, null);
    }

    public static InputStream getResourceAsStreamNoException(String path, String extension) {
        URL url = ResourceUtil.getResourceNoException(path, extension);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean isExist(String path) {
        return ResourceUtil.getResourceNoException(path) != null;
    }

    public static Properties getProperties(String path) throws IORuntimeException {
        Properties props = new Properties();
        InputStream is = ResourceUtil.getResourceAsStream(path);
        try {
            props.load(is);
            return props;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static String getExtension(String path) {
        int extPos = path.lastIndexOf(".");
        if (extPos >= 0) {
            return path.substring(extPos + 1);
        }
        return null;
    }

    public static String removeExtension(String path) {
        int extPos = path.lastIndexOf(".");
        if (extPos >= 0) {
            return path.substring(0, extPos);
        }
        return path;
    }

    public static File getBuildDir(Class clazz) {
        return ResourceUtil.getBuildDir(ResourceUtil.getResourcePath(clazz));
    }

    public static File getBuildDir(String path) {
        File dir = null;
        URL url = ResourceUtil.getResource(path);
        if ("file".equals(url.getProtocol())) {
            int num = path.split("/").length;
            dir = new File(ResourceUtil.getFileName(url));
            int i = 0;
            while (i < num) {
                ++i;
                dir = dir.getParentFile();
            }
        } else {
            dir = new File(JarFileUtil.toJarFilePath(url));
        }
        return dir;
    }

    public static String toExternalForm(URL url) {
        String s = url.toExternalForm();
        return URLUtil.decode(s, "UTF8");
    }

    public static String getFileName(URL url) {
        String s = url.getFile();
        return URLUtil.decode(s, "UTF8");
    }

    public static File getFile(URL url) {
        File file = new File(ResourceUtil.getFileName(url));
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static File getResourceAsFile(String path) {
        return ResourceUtil.getResourceAsFile(path, null);
    }

    public static File getResourceAsFile(String path, String extension) {
        return ResourceUtil.getFile(ResourceUtil.getResource(path, extension));
    }

    public static File getResourceAsFileNoException(Class clazz) {
        return ResourceUtil.getResourceAsFileNoException(ResourceUtil.getResourcePath(clazz));
    }

    public static File getResourceAsFileNoException(String path) {
        URL url = ResourceUtil.getResourceNoException(path);
        if (url == null) {
            return null;
        }
        return ResourceUtil.getFile(url);
    }

    public static String convertPath(String path, Class clazz) {
        if (ResourceUtil.isExist(path)) {
            return path;
        }
        String prefix = clazz.getName().replace('.', '/').replaceFirst("/[^/]+$", "");
        String extendedPath = prefix + "/" + path;
        if (ResourceUtil.getResourceNoException(extendedPath) != null) {
            return extendedPath;
        }
        return path;
    }
}

