/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import java.io.InputStream;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.ResourceUtil;

public class HotdeployClassLoader
extends ClassLoader {
    private NamingConvention namingConvention;

    public HotdeployClassLoader(ClassLoader classLoader, NamingConvention namingConvention) {
        super(classLoader);
        this.namingConvention = namingConvention;
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if ("org.seasar.framework.container.hotdeploy.HotdeployUtil$RebuilderImpl".equals(className)) {
            Class<?> clazz = this.findLoadedClass(className);
            if (clazz != null) {
                return clazz;
            }
            return this.defineClass(className, resolve);
        }
        if (this.isTargetClass(className)) {
            Class clazz = this.findLoadedClass(className);
            if (clazz != null) {
                return clazz;
            }
            clazz = ClassLoaderUtil.findLoadedClass(this.getParent(), className);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.defineClass(className, resolve);
            if (clazz != null) {
                return clazz;
            }
        }
        return super.loadClass(className, resolve);
    }

    private Class defineClass(String className, boolean resolve) {
        String path = ClassUtil.getResourcePath(className);
        InputStream is = ResourceUtil.getResourceAsStreamNoException(path);
        if (is != null) {
            Class clazz = this.defineClass(className, is);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return null;
    }

    protected Class defineClass(String className, InputStream classFile) {
        return this.defineClass(className, InputStreamUtil.getBytes(classFile));
    }

    protected Class defineClass(String className, byte[] bytes) {
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    protected boolean isTargetClass(String className) {
        return this.namingConvention.isTargetClassName(className);
    }
}

