/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.io.File;
import org.seasar.framework.container.autoregister.AbstractComponentAutoRegister;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class FileSystemComponentAutoRegister
extends AbstractComponentAutoRegister {
    public void registerAll() {
        File packageDir = this.getRootDir();
        String[] referencePackages = this.getTargetPackages();
        for (int i = 0; i < referencePackages.length; ++i) {
            ClassTraversal.forEach(packageDir, referencePackages[i], this);
        }
    }

    protected File getRootDir() {
        String path = this.getContainer().getPath();
        String[] names = StringUtil.split(path, "/");
        File file = ResourceUtil.getResourceAsFile(path);
        for (int i = 0; i < names.length; ++i) {
            file = file.getParentFile();
        }
        return file;
    }
}

