/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.model.AutoShape;
import org.apache.poi.hslf.model.Line;
import org.apache.poi.hslf.model.Picture;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.hslf.model.TextBox;

public class ShapeFactory {
    public static Shape createShape(EscherContainerRecord spContainer, Shape parent) {
        Shape shape;
        if (spContainer.getRecordId() == -4093) {
            return new ShapeGroup(spContainer, parent);
        }
        EscherSpRecord spRecord = spContainer.getChildById((short)-4086);
        int type = spRecord.getOptions() >> 4;
        switch (type) {
            case 202: {
                shape = new TextBox(spContainer, parent);
                break;
            }
            case 1: {
                EscherTextboxRecord txtbox = (EscherTextboxRecord)Shape.getEscherChild(spContainer, -4083);
                if (txtbox == null) {
                    shape = new AutoShape(spContainer, parent);
                    break;
                }
                shape = new TextBox(spContainer, parent);
                break;
            }
            case 75: {
                shape = new Picture(spContainer, parent);
                break;
            }
            case 20: {
                shape = new Line(spContainer, parent);
                break;
            }
            case 0: {
                if ((spRecord.getFlags() & 1) != 0) {
                    shape = new ShapeGroup(spContainer, parent);
                    break;
                }
                shape = new AutoShape(spContainer, parent);
                break;
            }
            default: {
                shape = new AutoShape(spContainer, parent);
            }
        }
        return shape;
    }
}

