package jp.sourceforge.tsukuyomi.openid;

import java.util.Map;

/**
 * OpenID 認証サーバへの認証リクエストを行うためのクラスへのインタフェースです。
 * 
 * @author asuka
 *
 */
public interface AuthenticationRequest {
	/**
	 * 認証リクエストを送るためのリダイレクト URL を取得します。これは OpenID 1.x の場合のみ使用すべきです。
	 * 
	 * @return 認証リクエストを送るためのリダイレクト URL
	 */
	String getRedirectURL();
	
	/**
	 * HTTP レスポンスとして認証リクエストのリダイレクトを送信します。
	 */
	void sendRedirect();
	
	/**
	 * 認証リクエストを POST で送るための URL を取得します。これは OpenID 2.x の場合のみ使用すべきです。
	 * 
	 * @return 認証リクエストを POST で送るための URL
	 */
	String getPostURL();
	
	/**
	 * 認証リクエストのためのパラメータを取得します。
	 * 
	 * @return 認証リクエストのためのパラメータ
	 */
	Map<String, String> getParameterMap();
	
	/**
	 * 認証リクエストを POST で送るためのフォームの HTML を HTTP レスポンスに書き込みます。
	 */
	void writeForm();
	
	/**
	 * 認証サーバのバージョンに応じて、 {@link #sendRedirect()} または {@link #writeForm()} を実行します。
	 */
	void goNext();
}
