/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.util;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.openid4java.util.ProxyProperties;

public class HttpClientFactory {
    private static ProxyProperties proxyProperties = null;

    public static ProxyProperties getProxyProperties() {
        return proxyProperties;
    }

    public static void setProxyProperties(ProxyProperties properties) {
        proxyProperties = properties;
    }

    public static HttpClient getInstance(int maxRedirects, Boolean allowCircularRedirects, int connTimeout, int socketTimeout, String cookiePolicy) {
        HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        client.getParams().setParameter("http.protocol.max-redirects", (Object)new Integer(maxRedirects));
        client.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)allowCircularRedirects);
        client.getParams().setSoTimeout(socketTimeout);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(connTimeout);
        client.getParams().setParameter("http.protocol.cookie-policy", (Object)cookiePolicy);
        if (proxyProperties != null) {
            HostConfiguration hostConf = client.getHostConfiguration();
            hostConf.setProxy(proxyProperties.getProxyHostName(), proxyProperties.getProxyPort());
            AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
            client.getState().setProxyCredentials(authScope, (Credentials)new UsernamePasswordCredentials(proxyProperties.getUserName(), proxyProperties.getPassword()));
        }
        return client;
    }
}

