/* GENERATED FILE - EDIT THE SOURCE IN macenctab.im INSTEAD! */

/* Comment from George Williams in the part of the FontForge macenc.c
 * source file which these auto-generated tables replace:

     The original data for these mappings may be found at
       http://www.unicode.org/Public/MAPPINGS/VENDORS/APPLE/
     unfortunately this site does not contain all the macintosh encodings
     so we leave some blank

     Response (indirectly) from charsets@apple.com when asked about the
     missing encodings:

        > I don't believe any of those additional scripts are actually
        > defined as character encodings. He can safely ignore anything
        > that's not in the Apple folder on the Unicode site.
        >
        > I monitor charsets@apple.com and don't recall seeing any e-mail
        > on this subject. It's possible it got lost in the voluminous
        > spam the address receives.
        >
        > Deborah

     I find this perplexing (unless the script is defined but unused, how can
     it fail to have a defined encoding), but will accept it.

 * George wrote that at some unspecified distant point in the past.  As of
 * the current writing (Matthew Skala, June 2015), there are other tables
 * available at the Unicode Consortium URL mentioned above, that were not
 * included in the FontForge source file.  Notes below describe what I think
 * is going on with those files.
 *
 * For the moment these lookups cover only Mac 8-bit encodings.  I may add
 * 16-bit encodings if I can figure out how the FontForge code handles them.
 */

#include <ustring.h>

#include "_stdint.h"

/* basic array lookup for map "macenc_arabic" */

unichar_t __icemap_macenc_arabic_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xC4,0xA0,0xC7,0xC9,0xD1,0xD6,
  0xDC,0xE1,0xE0,0xE2,0xE4,0x6BA,0xAB,0xE7,0xE9,0xE8,0xEA,0xEB,0xED,
  0x2026,0xEE,0xEF,0xF1,0xF3,0xBB,0xF4,0xF6,0xF7,0xFA,0xF9,0xFB,0xFC,
  0x20,0x21,0x22,0x23,0x24,0x66A,0x26,0x27,0x28,0x29,0x2A,0x2B,0x60C,
  0x2D,0x2E,0x2F,0x660,0x661,0x662,0x663,0x664,0x665,0x666,0x667,0x668,
  0x669,0x3A,0x61B,0x3C,0x3D,0x3E,0x61F,0x274A,0x621,0x622,0x623,0x624,
  0x625,0x626,0x627,0x628,0x629,0x62A,0x62B,0x62C,0x62D,0x62E,0x62F,
  0x630,0x631,0x632,0x633,0x634,0x635,0x636,0x637,0x638,0x639,0x63A,
  0x5B,0x5C,0x5D,0x5E,0x5F,0x640,0x641,0x642,0x643,0x644,0x645,0x646,
  0x647,0x648,0x649,0x64A,0x64B,0x64C,0x64D,0x64E,0x64F,0x650,0x651,
  0x652,0x67E,0x679,0x686,0x6D5,0x6A4,0x6AF,0x688,0x691,0x7B,0x7C,0x7D,
  0x698,0x6D2,
};

/* basic array lookup for map "macenc_centeuro" */

unichar_t __icemap_macenc_centeuro_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xC4,0x100,0x101,0xC9,0x104,0xD6,
  0xDC,0xE1,0x105,0x10C,0xE4,0x10D,0x106,0x107,0xE9,0x179,0x17A,0x10E,
  0xED,0x10F,0x112,0x113,0x116,0xF3,0x117,0xF4,0xF6,0xF5,0xFA,0x11A,
  0x11B,0xFC,0x2020,0xB0,0x118,0xA3,0xA7,0x2022,0xB6,0xDF,0xAE,0xA9,
  0x2122,0x119,0xA8,0x2260,0x123,0x12E,0x12F,0x12A,0x2264,0x2265,0x12B,
  0x136,0x2202,0x2211,0x142,0x13B,0x13C,0x13D,0x13E,0x139,0x13A,0x145,
  0x146,0x143,0xAC,0x221A,0x144,0x147,0x2206,0xAB,0xBB,0x2026,0xA0,
  0x148,0x150,0xD5,0x151,0x14C,0x2013,0x2014,0x201C,0x201D,0x2018,
  0x2019,0xF7,0x25CA,0x14D,0x154,0x155,0x158,0x2039,0x203A,0x159,0x156,
  0x157,0x160,0x201A,0x201E,0x161,0x15A,0x15B,0xC1,0x164,0x165,0xCD,
  0x17D,0x17E,0x16A,0xD3,0xD4,0x16B,0x16E,0xDA,0x16F,0x170,0x171,0x172,
  0x173,0xDD,0xFD,0x137,0x17B,0x141,0x17C,0x122,0x2C7,
};

/* basic array lookup for map "macenc_croatian" */

unichar_t __icemap_macenc_croatian_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xC4,0xC5,0xC7,0xC9,0xD1,0xD6,
  0xDC,0xE1,0xE0,0xE2,0xE4,0xE3,0xE5,0xE7,0xE9,0xE8,0xEA,0xEB,0xED,
  0xEC,0xEE,0xEF,0xF1,0xF3,0xF2,0xF4,0xF6,0xF5,0xFA,0xF9,0xFB,0xFC,
  0x2020,0xB0,0xA2,0xA3,0xA7,0x2022,0xB6,0xDF,0xAE,0x160,0x2122,0xB4,
  0xA8,0x2260,0x17D,0xD8,0x221E,0xB1,0x2264,0x2265,0x2206,0xB5,0x2202,
  0x2211,0x220F,0x161,0x222B,0xAA,0xBA,0x3A9,0x17E,0xF8,0xBF,0xA1,0xAC,
  0x221A,0x192,0x2248,0x106,0xAB,0x10C,0x2026,0xA0,0xC0,0xC3,0xD5,
  0x152,0x153,0x110,0x2014,0x201C,0x201D,0x2018,0x2019,0xF7,0x25CA,
  0xF8FF,0xA9,0x2044,0x20AC,0x2039,0x203A,0xC6,0xBB,0x2013,0xB7,0x201A,
  0x201E,0x2030,0xC2,0x107,0xC1,0x10D,0xC8,0xCD,0xCE,0xCF,0xCC,0xD3,
  0xD4,0x111,0xD2,0xDA,0xDB,0xD9,0x131,0x2C6,0x2DC,0xAF,0x3C0,0xCB,
  0x2DA,0xB8,0xCA,0xE6,0x2C7,
};

/* basic array lookup for map "macenc_cyrillic" */

unichar_t __icemap_macenc_cyrillic_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x410,0x411,0x412,0x413,0x414,
  0x415,0x416,0x417,0x418,0x419,0x41A,0x41B,0x41C,0x41D,0x41E,0x41F,
  0x420,0x421,0x422,0x423,0x424,0x425,0x426,0x427,0x428,0x429,0x42A,
  0x42B,0x42C,0x42D,0x42E,0x42F,0x2020,0xB0,0x490,0xA3,0xA7,0x2022,
  0xB6,0x406,0xAE,0xA9,0x2122,0x402,0x452,0x2260,0x403,0x453,0x221E,
  0xB1,0x2264,0x2265,0x456,0xB5,0x491,0x408,0x404,0x454,0x407,0x457,
  0x409,0x459,0x40A,0x45A,0x458,0x405,0xAC,0x221A,0x192,0x2248,0x2206,
  0xAB,0xBB,0x2026,0xA0,0x40B,0x45B,0x40C,0x45C,0x455,0x2013,0x2014,
  0x201C,0x201D,0x2018,0x2019,0xF7,0x201E,0x40E,0x45E,0x40F,0x45F,
  0x2116,0x401,0x451,0x44F,0x430,0x431,0x432,0x433,0x434,0x435,0x436,
  0x437,0x438,0x439,0x43A,0x43B,0x43C,0x43D,0x43E,0x43F,0x440,0x441,
  0x442,0x443,0x444,0x445,0x446,0x447,0x448,0x449,0x44A,0x44B,0x44C,
  0x44D,0x44E,0x20AC,
};

/* basic array lookup for map "macenc_devanagari" */

unichar_t __icemap_macenc_devanagari_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xD7,0x2212,0x2013,0x2014,0x2018,
  0x2019,0x2026,0x2022,0xA9,0xAE,0x2122,0xE3,0xE5,0xE7,0xE9,0xE8,0x965,
  0x970,0xED,0xEC,0xEE,0xEF,0xF1,0xF3,0xF2,0xF4,0xF6,0xF5,0xFA,0xF9,
  0xFB,0xFC,0x2020,0x901,0x902,0x903,0x905,0x906,0x907,0x908,0x909,
  0x90A,0x90B,0x90E,0x90F,0x910,0x90D,0x912,0x913,0x914,0x911,0x915,
  0x916,0x917,0x918,0x919,0x91A,0x91B,0x91C,0x91D,0x91E,0x91F,0x920,
  0x921,0x922,0x923,0x924,0x925,0x926,0x927,0x928,0x929,0x92A,0x92B,
  0x92C,0x92D,0x92E,0x92F,0x95F,0x930,0x931,0x932,0x933,0x934,0x935,
  0x936,0x937,0x938,0x939,0x200E,0x93E,0x93F,0x940,0x941,0x942,0x943,
  0x946,0x947,0x948,0x945,0x94A,0x94B,0x94C,0x949,0x94D,0x93C,0x964,
  0xCE,0xCF,0xCC,0xD3,0xD4,0xF8FF,0x966,0x967,0x968,0x969,0x96A,0x96B,
  0x96C,0x96D,0x96E,0x96F,0x2DA,0xB8,0x2DD,0x2DB,0x2C7,
};

/* basic array lookup for map "macenc_farsi" */

unichar_t __icemap_macenc_farsi_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xC4,0xA0,0xC7,0xC9,0xD1,0xD6,
  0xDC,0xE1,0xE0,0xE2,0xE4,0x6BA,0xAB,0xE7,0xE9,0xE8,0xEA,0xEB,0xED,
  0x2026,0xEE,0xEF,0xF1,0xF3,0xBB,0xF4,0xF6,0xF7,0xFA,0xF9,0xFB,0xFC,
  0x20,0x21,0x22,0x23,0x24,0x66A,0x26,0x27,0x28,0x29,0x2A,0x2B,0x60C,
  0x2D,0x2E,0x2F,0x6F0,0x6F1,0x6F2,0x6F3,0x6F4,0x6F5,0x6F6,0x6F7,0x6F8,
  0x6F9,0x3A,0x61B,0x3C,0x3D,0x3E,0x61F,0x274A,0x621,0x622,0x623,0x624,
  0x625,0x626,0x627,0x628,0x629,0x62A,0x62B,0x62C,0x62D,0x62E,0x62F,
  0x630,0x631,0x632,0x633,0x634,0x635,0x636,0x637,0x638,0x639,0x63A,
  0x5B,0x5C,0x5D,0x5E,0x5F,0x640,0x641,0x642,0x643,0x644,0x645,0x646,
  0x647,0x648,0x649,0x64A,0x64B,0x64C,0x64D,0x64E,0x64F,0x650,0x651,
  0x652,0x67E,0x679,0x686,0x6D5,0x6A4,0x6AF,0x688,0x691,0x7B,0x7C,0x7D,
  0x698,0x6D2,
};

/* basic array lookup for map "macenc_greek" */

unichar_t __icemap_macenc_greek_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xC4,0xB9,0xB2,0xC9,0xB3,0xD6,
  0xDC,0x385,0xE0,0xE2,0xE4,0x384,0xA8,0xE7,0xE9,0xE8,0xEA,0xEB,0xA3,
  0x2122,0xEE,0xEF,0x2022,0xBD,0x2030,0xF4,0xF6,0xA6,0x20AC,0xF9,0xFB,
  0xFC,0x2020,0x393,0x394,0x398,0x39B,0x39E,0x3A0,0xDF,0xAE,0xA9,0x3A3,
  0x3AA,0xA7,0x2260,0xB0,0xB7,0x391,0xB1,0x2264,0x2265,0xA5,0x392,
  0x395,0x396,0x397,0x399,0x39A,0x39C,0x3A6,0x3AB,0x3A8,0x3A9,0x3AC,
  0x39D,0xAC,0x39F,0x3A1,0x2248,0x3A4,0xAB,0xBB,0x2026,0xA0,0x3A5,
  0x3A7,0x386,0x388,0x153,0x2013,0x2015,0x201C,0x201D,0x2018,0x2019,
  0xF7,0x389,0x38A,0x38C,0x38E,0x3AD,0x3AE,0x3AF,0x3CC,0x38F,0x3CD,
  0x3B1,0x3B2,0x3C8,0x3B4,0x3B5,0x3C6,0x3B3,0x3B7,0x3B9,0x3BE,0x3BA,
  0x3BB,0x3BC,0x3BD,0x3BF,0x3C0,0x3CE,0x3C1,0x3C3,0x3C4,0x3B8,0x3C9,
  0x3C2,0x3C7,0x3C5,0x3B6,0x3CA,0x3CB,0x390,0x3B0,0xAD,
};

/* basic array lookup for map "macenc_gujarati" */

unichar_t __icemap_macenc_gujarati_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xD7,0x2212,0x2013,0x2014,0x2018,
  0x2019,0x2026,0x2022,0xA9,0xAE,0x2122,0xE3,0xE5,0xE7,0xE9,0xE8,0x965,
  0xEB,0xED,0xEC,0xEE,0xEF,0xF1,0xF3,0xF2,0xF4,0xF6,0xF5,0xFA,0xF9,
  0xFB,0xFC,0x2020,0xA81,0xA82,0xA83,0xA85,0xA86,0xA87,0xA88,0xA89,
  0xA8A,0xA8B,0xB4,0xA8F,0xA90,0xA8D,0xD8,0xA93,0xA94,0xA91,0xA95,
  0xA96,0xA97,0xA98,0xA99,0xA9A,0xA9B,0xA9C,0xA9D,0xA9E,0xA9F,0xAA0,
  0xAA1,0xAA2,0xAA3,0xAA4,0xAA5,0xAA6,0xAA7,0xAA8,0xAB,0xAAA,0xAAB,
  0xAAC,0xAAD,0xAAE,0xAAF,0x152,0xAB0,0x2013,0xAB2,0xAB3,0x201D,0xAB5,
  0xAB6,0xAB7,0xAB8,0xAB9,0x200E,0xABE,0xABF,0xAC0,0xAC1,0xAC2,0xAC3,
  0x2021,0xAC7,0xAC8,0xAC5,0x2030,0xACB,0xACC,0xAC9,0xACD,0xABC,0x964,
  0xCE,0xCF,0xCC,0xD3,0xD4,0xF8FF,0xAE6,0xAE7,0xAE8,0xAE9,0xAEA,0xAEB,
  0xAEC,0xAED,0xAEE,0xAEF,0x2DA,0xB8,0x2DD,0x2DB,0x2C7,
};

/* basic array lookup for map "macenc_gurmukhi" */

unichar_t __icemap_macenc_gurmukhi_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xD7,0x2212,0x2013,0x2014,0x2018,
  0x2019,0x2026,0x2022,0xA9,0xAE,0x2122,0xE3,0xE5,0xE7,0xE9,0xE8,0xA71,
  0xA5C,0xA73,0xA72,0xA74,0xEF,0xF1,0xF3,0xF2,0xF4,0xF6,0xF5,0xFA,0xF9,
  0xFB,0xFC,0x2020,0xB0,0xA02,0xA3,0xA05,0xA06,0xA07,0xA08,0xA09,0xA0A,
  0x2122,0xB4,0xA0F,0xA10,0xC6,0xD8,0xA13,0xA14,0x2264,0xA15,0xA16,
  0xA17,0xA18,0xA19,0xA1A,0xA1B,0xA1C,0xA1D,0xA1E,0xA1F,0xA20,0xA21,
  0xA22,0xA23,0xA24,0xA25,0xA26,0xA27,0xA28,0xAB,0xA2A,0xA2B,0xA2C,
  0xA2D,0xA2E,0xA2F,0x152,0xA30,0x2013,0xA32,0x201C,0x201D,0xA35,
  0x2019,0xF7,0xA38,0xA39,0x200E,0xA3E,0xA3F,0xA40,0xA41,0xA42,0xFB02,
  0x2021,0xA47,0xA48,0x201E,0x2030,0xA4B,0xA4C,0xC1,0xA4D,0xA3C,0x964,
  0xCE,0xCF,0xCC,0xD3,0xD4,0xF8FF,0xA66,0xA67,0xA68,0xA69,0xA6A,0xA6B,
  0xA6C,0xA6D,0xA6E,0xA6F,0x2DA,0xB8,0x2DD,0x2DB,0x2C7,
};

/* basic array lookup for map "macenc_hebrew" */

unichar_t __icemap_macenc_hebrew_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xC4,0xC5,0xC7,0xC9,0xD1,0xD6,
  0xDC,0xE1,0xE0,0xE2,0xE4,0xE3,0xE5,0xE7,0xE9,0xE8,0xEA,0xEB,0xED,
  0xEC,0xEE,0xEF,0xF1,0xF3,0xF2,0xF4,0xF6,0xF5,0xFA,0xF9,0xFB,0xFC,
  0x20,0x21,0x22,0x23,0x24,0x25,0x20AA,0x27,0x29,0x28,0x2A,0x2B,0x2C,
  0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,
  0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0xBF,0x201E,0xF89B,0xF89C,0xF89D,
  0xF89E,0x5BC,0xFB4B,0xFB35,0x2026,0xA0,0x5B8,0x5B7,0x5B5,0x5B6,0x5B4,
  0x2013,0x2014,0x201C,0x201D,0x2018,0x2019,0xFB2A,0xFB2B,0x5BF,0x5B0,
  0x5B2,0x5B1,0x5BB,0x5B9,0xFB01,0x5B3,0x5D0,0x5D1,0x5D2,0x5D3,0x5D4,
  0x5D5,0x5D6,0x5D7,0x5D8,0x5D9,0x5DA,0x5DB,0x5DC,0x5DD,0x5DE,0x5DF,
  0x5E0,0x5E1,0x5E2,0x5E3,0x5E4,0x5E5,0x5E6,0x5E7,0x5E8,0x5E9,0x5EA,
  0x7D,0x5D,0x7B,0x5B,0x7C,
};

/* basic array lookup for map "macenc_iceland" */

unichar_t __icemap_macenc_iceland_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xC4,0xC5,0xC7,0xC9,0xD1,0xD6,
  0xDC,0xE1,0xE0,0xE2,0xE4,0xE3,0xE5,0xE7,0xE9,0xE8,0xEA,0xEB,0xED,
  0xEC,0xEE,0xEF,0xF1,0xF3,0xF2,0xF4,0xF6,0xF5,0xFA,0xF9,0xFB,0xFC,
  0xDD,0xB0,0xA2,0xA3,0xA7,0x2022,0xB6,0xDF,0xAE,0xA9,0x2122,0xB4,0xA8,
  0x2260,0xC6,0xD8,0x221E,0xB1,0x2264,0x2265,0xA5,0xB5,0x2202,0x2211,
  0x220F,0x3C0,0x222B,0xAA,0xBA,0x3A9,0xE6,0xF8,0xBF,0xA1,0xAC,0x221A,
  0x192,0x2248,0x2206,0xAB,0xBB,0x2026,0xA0,0xC0,0xC3,0xD5,0x152,0x153,
  0x2013,0x2014,0x201C,0x201D,0x2018,0x2019,0xF7,0x25CA,0xFF,0x178,
  0x2044,0x20AC,0xD0,0xF0,0xDE,0xFE,0xFD,0xB7,0x201A,0x201E,0x2030,
  0xC2,0xCA,0xC1,0xCB,0xC8,0xCD,0xCE,0xCF,0xCC,0xD3,0xD4,0xF8FF,0xD2,
  0xDA,0xDB,0xD9,0x131,0x2C6,0x2DC,0xAF,0x2D8,0x2D9,0x2DA,0xB8,0x2DD,
  0x2DB,0x2C7,
};

/* basic array lookup for map "macenc_macromanenc" */

unichar_t __icemap_macenc_macromanenc_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xC4,0xC5,0xC7,0xC9,0xD1,0xD6,
  0xDC,0xE1,0xE0,0xE2,0xE4,0xE3,0xE5,0xE7,0xE9,0xE8,0xEA,0xEB,0xED,
  0xEC,0xEE,0xEF,0xF1,0xF3,0xF2,0xF4,0xF6,0xF5,0xFA,0xF9,0xFB,0xFC,
  0x2020,0xB0,0xA2,0xA3,0xA7,0x2022,0xB6,0xDF,0xAE,0xA9,0x2122,0xB4,
  0xA8,0x2260,0xC6,0xD8,0x221E,0xB1,0x2264,0x2265,0xA5,0xB5,0x2202,
  0x2211,0x220F,0x3C0,0x222B,0xAA,0xBA,0x3A9,0xE6,0xF8,0xBF,0xA1,0xAC,
  0x221A,0x192,0x2248,0x2206,0xAB,0xBB,0x2026,0xA0,0xC0,0xC3,0xD5,
  0x152,0x153,0x2013,0x2014,0x201C,0x201D,0x2018,0x2019,0xF7,0x25CA,
  0xFF,0x178,0x2044,0x20AC,0x2039,0x203A,0xFB01,0xFB02,0x2021,0xB7,
  0x201A,0x201E,0x2030,0xC2,0xCA,0xC1,0xCB,0xC8,0xCD,0xCE,0xCF,0xCC,
  0xD3,0xD4,0xF8FF,0xD2,0xDA,0xDB,0xD9,0x131,0x2C6,0x2DC,0xAF,0x2D8,
  0x2D9,0x2DA,0xB8,0x2DD,0x2DB,0x2C7,
};

/* basic array lookup for map "macenc_romanian" */

unichar_t __icemap_macenc_romanian_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xC4,0xC5,0xC7,0xC9,0xD1,0xD6,
  0xDC,0xE1,0xE0,0xE2,0xE4,0xE3,0xE5,0xE7,0xE9,0xE8,0xEA,0xEB,0xED,
  0xEC,0xEE,0xEF,0xF1,0xF3,0xF2,0xF4,0xF6,0xF5,0xFA,0xF9,0xFB,0xFC,
  0x2020,0xB0,0xA2,0xA3,0xA7,0x2022,0xB6,0xDF,0xAE,0xA9,0x2122,0xB4,
  0xA8,0x2260,0x102,0x218,0x221E,0xB1,0x2264,0x2265,0xA5,0xB5,0x2202,
  0x2211,0x220F,0x3C0,0x222B,0xAA,0xBA,0x3A9,0x103,0x219,0xBF,0xA1,
  0xAC,0x221A,0x192,0x2248,0x2206,0xAB,0xBB,0x2026,0xA0,0xC0,0xC3,0xD5,
  0x152,0x153,0x2013,0x2014,0x201C,0x201D,0x2018,0x2019,0xF7,0x25CA,
  0xFF,0x178,0x2044,0x20AC,0x2039,0x203A,0x21A,0x21B,0x2021,0xB7,
  0x201A,0x201E,0x2030,0xC2,0xCA,0xC1,0xCB,0xC8,0xCD,0xCE,0xCF,0xCC,
  0xD3,0xD4,0xF8FF,0xD2,0xDA,0xDB,0xD9,0x131,0x2C6,0x2DC,0xAF,0x2D8,
  0x2D9,0x2DA,0xB8,0x2DD,0x2DB,0x2C7,
};

/* basic array lookup for map "macenc_symbol" */

int32_t __icemap_macenc_symbol_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x2200,0x23,0x2203,0x25,0x26,0x220D,0x28,0x29,
  0x2217,0x2B,0x2C,0x2212,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,
  0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x2245,0x391,0x392,
  0x3A7,0x394,0x395,0x3A6,0x393,0x397,0x399,0x3D1,0x39A,0x39B,0x39C,
  0x39D,0x39F,0x3A0,0x398,0x3A1,0x3A3,0x3A4,0x3A5,0x3C2,0x3A9,0x39E,
  0x3A8,0x396,0x5B,0x2234,0x5D,0x22A5,0x5F,0xF8E5,0x3B1,0x3B2,0x3C7,
  0x3B4,0x3B5,0x3C6,0x3B3,0x3B7,0x3B9,0x3D5,0x3BA,0x3BB,0x3BC,0x3BD,
  0x3BF,0x3C0,0x3B8,0x3C1,0x3C3,0x3C4,0x3C5,0x3D6,0x3C9,0x3BE,0x3C8,
  0x3B6,0x7B,0x7C,0x7D,0x223C,0x7F,0xC4,0xC5,0xC7,0xC9,0xD1,0xD6,0xDC,
  0xE1,0xE0,0xE2,0xE4,0xE3,0xE5,0xE7,0xE9,0xE8,0xEA,0xEB,0xED,0xEC,
  0xEE,0xEF,0xF1,0xF3,0xF2,0xF4,0xF6,0xF5,0xFA,0xF9,0xFB,0xFC,0x20AC,
  0x3D2,0x2032,0x2264,0x2044,0x221E,0x192,0x2663,0x2666,0x2665,0x2660,
  0x2194,0x2190,0x2191,0x2192,0x2193,0xB0,0xB1,0x2033,0x2265,0xD7,
  0x221D,0x2202,0x2022,0xF7,0x2260,0x2261,0x2248,0x2026,0x23D0,0x23AF,
  0x21B5,0x2135,0x2111,0x211C,0x2118,0x2297,0x2295,0x2205,0x2229,
  0x222A,0x2283,0x2287,0x2284,0x2282,0x2286,0x2208,0x2209,0x2220,
  0x2207,0xAE,0xA9,0x2122,0x220F,0x221A,0x22C5,0xAC,0x2227,0x2228,
  0x21D4,0x21D0,0x21D1,0x21D2,0x21D3,0x25CA,0x3008,0x201A,0x201E,
  0x2030,0x2211,0x239B,0x239C,0x239D,0x23A1,0x23A2,0x23A3,0x23A7,
  0x23A8,0x23A9,0x23AA,0xF8FF,0x3009,0x222B,0x2320,0x23AE,0x2321,
  0x239E,0x239F,0x23A0,0x23A4,0x23A5,0x23A6,0x23AB,0x23AC,0x23AD,0x2C7,
};

/* basic array lookup for map "macenc_thai" */

unichar_t __icemap_macenc_thai_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xAB,0xBB,0x2026,0xC9,0xD1,0xD6,
  0xDC,0xE1,0xE0,0xE2,0xE4,0xE3,0xE5,0x201C,0x201D,0xE8,0xEA,0x2022,
  0xED,0xEC,0xEE,0xEF,0xF1,0xF3,0xF2,0xF4,0xF6,0xF5,0xFA,0x2018,0x2019,
  0xFC,0xA0,0xE01,0xE02,0xE03,0xE04,0xE05,0xE06,0xE07,0xE08,0xE09,
  0xE0A,0xE0B,0xE0C,0xE0D,0xE0E,0xE0F,0xE10,0xE11,0xE12,0xE13,0xE14,
  0xE15,0xE16,0xE17,0xE18,0xE19,0xE1A,0xE1B,0xE1C,0xE1D,0xE1E,0xE1F,
  0xE20,0xE21,0xE22,0xE23,0xE24,0xE25,0xE26,0xE27,0xE28,0xE29,0xE2A,
  0xE2B,0xE2C,0xE2D,0xE2E,0xE2F,0xE30,0xE31,0xE32,0xE33,0xE34,0xE35,
  0xE36,0xE37,0xE38,0xE39,0xE3A,0x2060,0x200B,0x2013,0x2014,0xE3F,
  0xE40,0xE41,0xE42,0xE43,0xE44,0xE45,0xE46,0xE47,0xE48,0xE49,0xE4A,
  0xE4B,0xE4C,0xE4D,0x2122,0xE4F,0xE50,0xE51,0xE52,0xE53,0xE54,0xE55,
  0xE56,0xE57,0xE58,0xE59,0xAE,0xA9,0xB8,0x2DD,0x2DB,0x2C7,
};

/* basic array lookup for map "macenc_turkish" */

unichar_t __icemap_macenc_turkish_array[256]={
  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,
  0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,
  0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,
  0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,
  0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,
  0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0xC4,0xC5,0xC7,0xC9,0xD1,0xD6,
  0xDC,0xE1,0xE0,0xE2,0xE4,0xE3,0xE5,0xE7,0xE9,0xE8,0xEA,0xEB,0xED,
  0xEC,0xEE,0xEF,0xF1,0xF3,0xF2,0xF4,0xF6,0xF5,0xFA,0xF9,0xFB,0xFC,
  0x2020,0xB0,0xA2,0xA3,0xA7,0x2022,0xB6,0xDF,0xAE,0xA9,0x2122,0xB4,
  0xA8,0x2260,0xC6,0xD8,0x221E,0xB1,0x2264,0x2265,0xA5,0xB5,0x2202,
  0x2211,0x220F,0x3C0,0x222B,0xAA,0xBA,0x3A9,0xE6,0xF8,0xBF,0xA1,0xAC,
  0x221A,0x192,0x2248,0x2206,0xAB,0xBB,0x2026,0xA0,0xC0,0xC3,0xD5,
  0x152,0x153,0x2013,0x2014,0x201C,0x201D,0x2018,0x2019,0xF7,0x25CA,
  0xFF,0x178,0x11E,0x11F,0x130,0x131,0x15E,0x15F,0x2021,0xB7,0x201A,
  0x201E,0x2030,0xC2,0xCA,0xC1,0xCB,0xC8,0xCD,0xCE,0xCF,0xCC,0xD3,0xD4,
  0xF8FF,0xD2,0xDA,0xDB,0xD9,0xF8A0,0x2C6,0x2DC,0xAF,0x2D8,0x2D9,0x2DA,
  0xB8,0x2DD,0x2DB,0x2C7,
};

