/* Copyright (c) 2010, mshio <mshio@users.sourceforge.jp>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer.
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *  o Neither the name of the Tsubuyaki Ticker Project nor the names of its 
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */
var tsubuyakiTickerSettings = {
    users: null,
    numberOfRecord: 5,
    interval: 100,
    movingQuantity: 7,
    dateFormat: 'YYYY/MM/DD hh:mm',
    displayUserID: 'on',
    displayDateTime: 'on',
    autoReload: 'off',
    notFoundMessage: '* * * [INFO] NO TWEET WAS FOUND * * *',
    responseFailureMessage: '* * * [TIMEOUT] THERE IS AT LEAST ONE RESPONSE NOT BEING RETURNED * * *'
};

var _tickerData = {
    userList: [],
    tweetList: {},
    tweetNum: {},
    failure: {},
    animation: null,
    dateFormatter: null,
    callbacks: {}
};

function getTweets(account, numOfRec, numCode) {
    var s = document.createElement('script');
    s.type = 'text/javascript';
    s.src = 'http://search.twitter.com/search.json?q=from%3A' + account + '&rpp=' + numOfRec + '&callback=_tickerData.callbacks.' + numCode;
    var t = document.getElementById('tsubuyakiTicker');
    t.appendChild(s);
}

function cleanupTickerDiv() {
    var t = document.getElementById('tsubuyakiTicker');
    var ns = t.childNodes;
    for (var i in ns) {
	var n = ns[i] ? ns[i].tagName : null;
	if (n && (n == 'script' || n == 'SCRIPT')) { t.removeChild(ns[i]); }
    }
}

function tweets(result, code) {
    var r = result.results;
    if (r.length > 0) {
	_tickerData.tweetList[r[0].from_user] = [];
	_tickerData.tweetNum[r[0].from_user] = r.length;
	var l = _tickerData.tweetList[r[0].from_user];
	for (var i in r) l.push(new Tweet(r[i].from_user, r[i].text, r[i].id, r[i].created_at, r[i].iso_language_code));
    } else {
	_tickerData.failure[code] = true;
    }
}

function Tweet(user, text, id, date, lang) {
    this.user = user;
    this.text = 
	text.replace(/(http:\/\/[0-9A-Za-z\.\/_\?&\~\-\=\#\:%]+)/g, '<a href="$1" target="_blank">$1</a>')
	.replace(/\s(@[a-zA-Z0-9_]+)/g, ' <a href="http://twitter.com/$1" target="_blank">$1</a>')
	.replace(/^(@[a-zA-Z0-9_]+)/, '<a href="http://twitter.com/$1" target="_blank">$1</a>')
	.replace(/\s(#[a-zA-Z0-9_]+)/g, ' <a href="http://twitter.com/search?q=$1" target="_blank">$1</a>')
	.replace(/^(#[a-zA-Z0-9_]+)/, '<a href="http://twitter.com/search?q=$1" target="_blank">$1</a>');
    this.id = id;
    this.date = date;
    this.lang = lang;
}

function ListManager(numUser) {
    this.numUser = numUser;
    this.counter = 0;
    this.timer = new TickerTimer(this, 'execCheck', 10);
}
ListManager.prototype = {
    check: function() {
	var l = _tickerData.tweetList;
	var n = _tickerData.tweetNum;
	var f = _tickerData.failure;
	var c = (function() {
	    var r = 0;
	    for (var i in f) if (f[i]) r++;
	    return r;
	})();
	var size = 0;
	for (var k in l) { size++; }
	if (size != this.numUser - c) return false;
	for (var i in l) if (l[i].length != n[i]) return false;
	for (var i in f) _tickerData.failure[i] = false;
	return true;
    }, 
    execCheck: function() {
	if (! this.check()) { 
	    if (++this.counter < 200) this.timer.restart(10);
	    else formatList(tsubuyakiTickerSettings.responseFailureMessage);
	} else {
	    cleanupTickerDiv();
	    formatList(null);
	}
    }
};

function checkSwitch(v) {
    return v != 'off' && v != 'Off' && v != 'OFF';
}

function formatList(enforcedMessage) {
    function toDateFmt(text) {
	if (! _tickerData.dateFormatter)
	    (_tickerData.dateFormatter = 
	     new DateFormatter()).compile(tsubuyakiTickerSettings.dateFormat);
	return _tickerData.dateFormatter.apply(text);
    }

    function getUnitedList() {
	var l = [];
	var t = _tickerData.tweetList;
	for (var k in t) for (var i in t[k]) l.push(t[k][i]);
	l.sort(function(a, b) { return b.id - a.id; });
	return l;
    }

    function makeupTweetLine(list, showDatetime, showUser) {
	var a = [];
	for (var n = 0; n < _tickerData.tweetNum[list[0].user]; n++) {
	    var s = [];
	    s.push('<span class="tsubu-tweet" lang="');
	    s.push(list[n].lang);
	    s.push('">');
	    s.push(list[n].text);
	    s.push('</span>');
	    if (showDatetime || showUser) {
		s.push('&nbsp;(');
		if (showDatetime) {
		    s.push('<span class="tsubu-datetime">');
		    s.push(toDateFmt(list[n].date));
		    s.push('</span>');
		    if (showUser) { s.push('&nbsp;'); }
		}
		if (showUser) {
		    s.push('<a class="tsubu-user" href="http://twitter.com/');
		    s.push(list[n].user);
		    s.push('" target="_blank">');
		    s.push(list[n].user);
		    s.push('</a>');
		}
		s.push(')');
	    }
	    a.push(s.join(''));
	}
	return a.join('<span class="tsubu-sep">&nbsp;&diams;&nbsp;&diams;&nbsp;&diams;&nbsp;</span>&nbsp;');
    }

    function getErrorLine(message) {
	return '<span class="tsubu-error">' + message + '</span>';
    }

    var buf = enforcedMessage ? getErrorLine(enforcedMessage) : (function() {
	var showUser = checkSwitch(tsubuyakiTickerSettings.displayUserID);
	var showDate = checkSwitch(tsubuyakiTickerSettings.displayDateTime);
	var list = getUnitedList();
	return (list.length > 0) ? makeupTweetLine(list, showDate, showUser) :
	    getErrorLine(tsubuyakiTickerSettings.notFoundMessage);
    })();
    var d = document.getElementById('tsubuyakiTicker').childNodes[0];
    if (d.innerHTML.length > 0) {
	d.prepare = buf;
    } else {
	d.innerHTML = buf;
	_tickerData.animation = new TickerAnimation(d);
    }
}

function TickerAnimation(span) {
    this.span = span;
    this.interval = tsubuyakiTickerSettings.interval;
    this.movingQuantity = tsubuyakiTickerSettings.movingQuantity;
    this.speeddown = 0;
    this.prepare = false;
    this.timer = new TickerTimer(this, 'move', this.interval);
}
TickerAnimation.prototype = {
    move: function() {
	var s = this.span;
	var x = getIntValue(s, s.style.left);
	var w = s.offsetWidth;
	if (this.speeddown != 0) this.speeddown += this.speeddown;
	var v = this.movingQuantity - this.speeddown;
	var auto = checkSwitch(tsubuyakiTickerSettings.autoReload);
	if (v > 0) {
	    x -= v;
	    if (x < -w) {
		x = getTickerWidth();
		if (this.span.prepare) this.span.innerHTML = this.span.prepare;
		this.prepare = false;
	    } else if (auto && ! this.prepare && x < - w + 250) {
		this.getTweetsInBackground();
	    }
	    s.style.left = x + (s.measure ? s.measure : 'px');
	    this.timer.restart(this.interval);
	} else this.timer.abort();
    },
    getTweetsInBackground: function() {
	var l = _tickerData.userList;
	var n = tsubuyakiTickerSettings.numberOfRecord;
	this.prepare = true;
	for (var i in l) { getTweets(l[i], n, getNumberCode(i)); }
	new ListManager(l.length);
    }
};

function stopTickerAnimation() {
    var a = _tickerData.animation;
    if (a && a.speeddown == 0) { a.speeddown = 0.05; }
}

function restartTickerAnimation() {
    var a = _tickerData.animation;
    if (a) { a.speeddown = 0; }
    if (a.timer) { a.timer.abort(); }
    a.timer = new TickerTimer(a, 'move', a.interval);
}

function TickerTimer(target, method, timeout) {
    this.target = target;
    this.method = method;
    this.id = this.setTimer(timeout);
}
TickerTimer.prototype = {
    abort: function() { if (this.id) { clearTimeout(this.id); } },
    restart: function(timeout) { this.id = this.setTimer(timeout); },
    setTimer: function(timeout) {
	var t = this.target, m = this.method;
	return setTimeout(function() { if (t[m]) { t[m](); } }, timeout);
    }
};

function DateFormatter() {
    this.scenario = [];
}
DateFormatter.prototype = {
    apply: function(text) {
	var r = [];
	var d = new Date(text);
	var s = this.scenario;
	for (var i in s) {
	    if (s[i][0] == 'put') {
		r.push(s[i][1]);
	    } else {
		var buf = d[s[i][0]]();
		for (var j = 1; j < s[i].length; j++) buf = this[s[i][j]](buf);
		r.push(buf);
	    }
	}
	return r.join('');
    },
    plus: function(value) {
	return parseInt(value) + 1;
    },
    fmtZero: function(value) {
	return (String(value).length == 1) ? '0' + value : value;
    },
    getDblFig: function(value) {
	var s = String(value);
	return s.substring(s.length - 2);
    },
    compile: function(format) {
	var p = []
	var status = 'normal';
	var start = 0;
	var c;

	var map = { 'M': 'getMonth', 'D': 'getDate', 'h': 'getHours',
	    'm': 'getMinutes', 's': 'getSeconds' };

	function changeStatus(i) {
	    var len = i - start;
	    if (status != c) {
		switch (status) {
		case 'normal':
		    if (i != 0) { p.push(['put', format.substring(start, i)]); }
		    break;
		case 'Y':
		    if (len == 2) p.push(['getYear', 'getDblFig']);
		    else if (len == 4) p.push(['getFullYear']);
		    else p.push(['put', format.substring(start, i)]);
		    break;
		default:
		    var m = map[status];
		    if (len == 1) {
			if (status == 'M') p.push([m, 'plus']);
			else p.push([m]);
		    } else if (len == 2) {
			if (status == 'M') p.push([m, 'plus', 'fmtZero']);
			else p.push([m, 'fmtZero']);
		    } else p.push(['put', format.substring(start, i)]);
		    break;
		}
		start = i;
	    }
	}

	for (var i = 0; i < format.length; i++) {
	    c = format.charAt(i);
	    if (c != 'Y' && c != 'M' && c != 'D' && 
		c != 'h' && c != 'm' && c != 's') c = 'normal';
	    changeStatus(i);
	    status = c;
	}
	c = '';
	changeStatus(format.length);
	this.scenario = p;
    }
}

function getTickerWidth() {
    var d = document.getElementById('tsubuyakiTicker');
    return (d.style.width) ? getIntValue(d, d.style.width) : d.offsetWidth;
}

function setupDiv(element) {
    var d = element;
    d.style.overflow = 'hidden';
    var w = getTickerWidth();
    var c = document.createElement('span');
    var s = c.style;
    s.whiteSpace = 'nowrap';
    s.position = 'relative';
    if (w) {
	s.left = w + (d.measure ? d.measure : 'px');
	d.appendChild(c);
    }
}

function getIntValue(element, text) {
    var v = text.replace(/([0-9]+)\s*[a-zA-Z]+/, '$1');
    if (v.length != text) {
	element.measure = text.substring(v.length);
	return parseInt(v);
    }
    return null;
}

function getNumberCode(number) {
    var n = number;
    var s = [];
    do {
	var v = n % 10;
	n = (n - v) / 10;
	s.push(String.fromCharCode(v + 0x61));
    } while (n > 0);
    return s.join('');
}

function tsubuyakiTickerMain() {
    var d = document.getElementById('tsubuyakiTicker');
    var s = tsubuyakiTickerSettings.users;
    if (d && s && s != '') {
	setupDiv(d);
	var u = s.substring(0, 160);
	var l = u.split(/,\s*/);
	var n = tsubuyakiTickerSettings.numberOfRecord;
	try {
	    n = parseInt(String(n));
	    for (var i in l) {
		_tickerData.userList[i] = encodeURI(l[i]);
		var c = getNumberCode(i);
		_tickerData.failure[c] = false;
		_tickerData.callbacks[c] = 
		    (function() {
			var p = c;
			return function(r) { tweets(r, p) };
		    })();
		getTweets(_tickerData.userList[i], n, c);
	    }
	    new ListManager(l.length, n);
	} catch (e) { }
    }
}

window.onload = function() {
    tsubuyakiTickerMain();
}

function loadTsubuyakiTicker() {
    var d = document.getElementById('tsubuyakiTicker');
    if (d && ! d.hasChildNodes()) { tsubuyakiTickerMain(); }
}
