package ts.query;

import ts.tester.UnitTest;
import ts.tester.function.ObjectInspector;
import ts.util.*;
import ts.util.table.*;
import java.util.*;
import java.io.*;

public class QueryResultTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryResultTest.class, args);
  }

  enum ENUM { AAA, BBB, CCC, }

  public void constructor_queryId()
  {
    MSG("クエリIDを引数にとるコンストラクタの確認。");

    QueryResult rslt = new QueryResult("q0");
    TRUE(rslt instanceof IQueryResult);
    TRUE(rslt instanceof Serializable);
    EQUAL(rslt.getQueryId(), "q0");
    TRUE(rslt.isSuccess());
    NULL(rslt.getException());
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    EQUAL(rslt.getBeginTimeMillis(), 0L);
    EQUAL(rslt.getEndTimeMillis(), 0L);
    TRUE(rslt.getAllResultIds().isEmpty());
    NULL(rslt.getResultTable("e1"));
    NULL(rslt.getResultTable("e2"));
    NULL(rslt.getResultTable("e3"));
    TRUE(rslt.getResultTableMap().isEmpty());

    rslt = new QueryResult("");
    TRUE(rslt instanceof IQueryResult);
    TRUE(rslt instanceof Serializable);
    EQUAL(rslt.getQueryId(), "");
    TRUE(rslt.isSuccess());
    NULL(rslt.getException());
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    EQUAL(rslt.getBeginTimeMillis(), 0L);
    EQUAL(rslt.getEndTimeMillis(), 0L);
    TRUE(rslt.getAllResultIds().isEmpty());
    NULL(rslt.getResultTable("e1"));
    NULL(rslt.getResultTable("e2"));
    NULL(rslt.getResultTable("e3"));
    TRUE(rslt.getResultTableMap().isEmpty());
  }

  public void constructor_queryId_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryResult(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void setException_exc_ReasonedException()
  {
    MSG("例外オブジェクトを設定するメソッドの確認。");
    MSG("- ReasonedExceptionの場合。");

    QueryResult rslt = new QueryResult("q0");
    NULL(rslt.getException());

    ReasonedException exc = new ReasonedException(ENUM.AAA);
    rslt.setException(exc);

    EQUAL(rslt.getException().getReason(), ENUM.AAA);
    NULL (rslt.getException().getCause());
  }

  public void setException_exc_ReasonedRuntimeException()
  {
    MSG("例外オブジェクトを設定するメソッドの確認。");
    MSG("- ReasonedRuntimeExceptionの場合。");

    QueryResult rslt = new QueryResult("q0");
    NULL(rslt.getException());

    ReasonedRuntimeException exc = new ReasonedRuntimeException(ENUM.BBB);
    rslt.setException(exc);

    EQUAL(rslt.getException().getReason(), ENUM.BBB);
    EQUAL(rslt.getException().getCause(), exc);
  }

  public void setException_exc_Exception()
  {
    MSG("例外オブジェクトを設定するメソッドの確認。");
    MSG("- Exceptionの場合。");

    QueryResult rslt = new QueryResult("q0");
    NULL(rslt.getException());

    Exception exc = new Exception();
    rslt.setException(exc);

    EQUAL(rslt.getException().getReason(), IQueryResult.Error.FailToExecute);
    EQUAL(rslt.getException().getCause(), exc);
  }

  public void setException_exc_Null()
  {
    MSG("引数がヌルの場合。");

    QueryResult rslt = new QueryResult("q0");
    NULL(rslt.getException());

    rslt.setException(null);
    NULL(rslt.getException());

    Exception exc = new Exception();
    rslt.setException(exc);
    EQUAL(rslt.getException().getReason(), IQueryResult.Error.FailToExecute);
    EQUAL(rslt.getException().getCause(), exc);

    rslt.setException(null);
    NULL(rslt.getException());
  }

  public void setBeginTimeMillis_tm()
  {
    MSG("開始時刻を設定するメソッドの場合。");

    QueryResult rslt = new QueryResult("q0");
    EQUAL(rslt.getBeginTimeMillis(), 0L);
    EQUAL(rslt.getEndTimeMillis(), 0L);
    EQUAL(rslt.getSpentTimeMillis(), 0L);

    MSG("- 引数が正の値の場合。");
    rslt.setBeginTimeMillis(1234L);
    EQUAL(rslt.getBeginTimeMillis(), 1234L);
    EQUAL(rslt.getEndTimeMillis(), 0L);
    EQUAL(rslt.getSpentTimeMillis(), 0L);

    MSG("- 引数がゼロの値の場合。");
    rslt.setBeginTimeMillis(0L);
    EQUAL(rslt.getBeginTimeMillis(), 0L);
    EQUAL(rslt.getEndTimeMillis(), 0L);
    EQUAL(rslt.getSpentTimeMillis(), 0L);

    MSG("- 引数が負の値の場合。");
    try {
      rslt.setBeginTimeMillis(-1L);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
    EQUAL(rslt.getBeginTimeMillis(), 0L);
    EQUAL(rslt.getEndTimeMillis(), 0L);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
  }

  public void setEndTimeMillis()
  {
    MSG("終了時刻を設定するメソッドの場合。");

    QueryResult rslt0 = new QueryResult("q0");
    QueryResult rslt1 = new QueryResult("q1");
    rslt1.setBeginTimeMillis(111L);

    MSG("- 引数が開始時刻より後の場合。");
    rslt0.setEndTimeMillis(100L);
    EQUAL(rslt0.getBeginTimeMillis(), 0L);
    EQUAL(rslt0.getEndTimeMillis(), 100L);
    EQUAL(rslt0.getSpentTimeMillis(), 100L);

    rslt1.setEndTimeMillis(200L);
    EQUAL(rslt1.getBeginTimeMillis(), 111L);
    EQUAL(rslt1.getEndTimeMillis(), 200L);
    EQUAL(rslt1.getSpentTimeMillis(), 89L);

    MSG("- 引数が開始時刻と同じ場合。");
    rslt0.setEndTimeMillis(0L);
    EQUAL(rslt0.getBeginTimeMillis(), 0L);
    EQUAL(rslt0.getEndTimeMillis(), 0L);
    EQUAL(rslt0.getSpentTimeMillis(), 0L);

    rslt1.setEndTimeMillis(111L);
    EQUAL(rslt1.getBeginTimeMillis(), 111L);
    EQUAL(rslt1.getEndTimeMillis(), 111L);
    EQUAL(rslt1.getSpentTimeMillis(), 0L);

    MSG("- 引数が開始時刻より前の場合。");
    try {
      rslt1.setEndTimeMillis(100L);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    MSG("- 引数が負の値の場合。");
    try {
      rslt0.setEndTimeMillis(-1L);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      rslt1.setEndTimeMillis(-100L);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void put_resultTable_in_resultTableMap()
  {
    MSG("結果テーブル・マップに結果テーブルを設定する動作の確認。");

    QueryResult rslt = new QueryResult("q");
    TRUE(rslt.getResultTableMap().isEmpty());

    Table<String,Serializable> table01 =
      new ArrayListTable<String,Serializable>();

    Table<String,Serializable> table02 =
      new ArrayListTable<String,Serializable>();

    Table<String,Serializable> table03 =
      new ArrayListTable<String,Serializable>();

    rslt.getResultTableMap().put("e1", table01);
    FALSE(rslt.getResultTableMap().isEmpty());
    EQUAL(rslt.getResultTableMap().size(), 1);
    NULL (rslt.getResultTableMap().get("e0"));
    EQUAL(rslt.getResultTableMap().get("e1"), table01);
    NULL (rslt.getResultTableMap().get("e2"));
    NULL (rslt.getResultTableMap().get("e3"));
    EQUAL(rslt.getAllResultIds(), Arrays.asList("e1"));

    rslt.getResultTableMap().put("e2", table02);
    FALSE(rslt.getResultTableMap().isEmpty());
    EQUAL(rslt.getResultTableMap().size(), 2);
    NULL (rslt.getResultTableMap().get("e0"));
    EQUAL(rslt.getResultTableMap().get("e1"), table01);
    EQUAL(rslt.getResultTableMap().get("e2"), table02);
    NULL (rslt.getResultTableMap().get("e3"));
    EQUAL(rslt.getAllResultIds(), Arrays.asList("e1", "e2"));

    rslt.getResultTableMap().put("e2", table03);
    FALSE(rslt.getResultTableMap().isEmpty());
    EQUAL(rslt.getResultTableMap().size(), 2);
    NULL (rslt.getResultTableMap().get("e0"));
    EQUAL(rslt.getResultTableMap().get("e1"), table01);
    EQUAL(rslt.getResultTableMap().get("e2"), table03);
    NULL (rslt.getResultTableMap().get("e3"));
    EQUAL(rslt.getAllResultIds(), Arrays.asList("e1", "e2"));
  }
}
