package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import ts.util.table.*;
import java.util.*;
import java.io.*;

public class QueryHistoryTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryHistoryTest.class, args);
  }

  enum ENUM { AAA, BBB, CCC, }

  public void constructor()
  {
    MSG("デフォルト・コンストラクタ。");

    ReasonedException exc = new ReasonedException(ENUM.AAA);

    QueryHistory history = new QueryHistory();
    TRUE(history instanceof IQueryHistory);
    TRUE(history instanceof Serializable);
    EQUAL(history.getAll().size(), 0);
    EQUAL(history.getByQueryId("q0").size(), 0);
    EQUAL(history.getByQueryId("q1").size(), 0);
    EQUAL(history.getByConnectionId("c00").size(), 0);
    EQUAL(history.getByConnectionId("c01").size(), 0);
    EQUAL(history.getByConnectionId("c02").size(), 0);
    EQUAL(history.getByConnectionId("c10").size(), 0);
    EQUAL(history.getByConnectionId("c11").size(), 0);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByExecutionId("e000").size(), 0);
    EQUAL(history.getByExecutionId("e001").size(), 0);
    EQUAL(history.getByExecutionId("e002").size(), 0);
    EQUAL(history.getByExecutionId("e010").size(), 0);
    EQUAL(history.getByExecutionId("e011").size(), 0);
    EQUAL(history.getByExecutionId("e020").size(), 0);
    EQUAL(history.getByExecutionId("e100").size(), 0);
    EQUAL(history.getByExecutionId("e110").size(), 0);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 0);
    EQUAL(history.getByExecutionId("c00","e001").size(), 0);
    EQUAL(history.getByExecutionId("c00","e002").size(), 0);
    EQUAL(history.getByExecutionId("c01","e010").size(), 0);
    EQUAL(history.getByExecutionId("c01","e011").size(), 0);
    EQUAL(history.getByExecutionId("c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 0);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 0);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 0);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByIsSuccess(true).size(), 0);
    EQUAL(history.getByIsSuccess(false).size(), 0);
    EQUAL(history.getByException(exc), null);
  }

  public void appendNew()
  {
    MSG("履歴を追加するメソッドの確認。");

    QueryHistory history = new QueryHistory();

    ReasonedException exc0 = new ReasonedException(ENUM.AAA);
    ReasonedException exc1 = new ReasonedException(ENUM.BBB);
    ReasonedException exc2 = new ReasonedException(ENUM.CCC);

    Map<QueryHistory.Item,Serializable> rec0 = history.appendNew();
    long entryTm0 = System.currentTimeMillis();
    rec0.put(QueryHistory.Item.QueryId, "q0");
    rec0.put(QueryHistory.Item.ConnectionId, "c00");
    rec0.put(QueryHistory.Item.ExecutionId, "e000");
    rec0.put(QueryHistory.Item.IsSuccess, true);
    //rec0.put(QueryHistory.Item.Exception, null);
    rec0.put(QueryHistory.Item.BeginTime, 11111L);
    rec0.put(QueryHistory.Item.EndTime, 21111L);
    rec0.put(QueryHistory.Item.SpentTime, 10000L);
    rec0.put(QueryHistory.Item.FetchCount, 100);
    rec0.put(QueryHistory.Item.UpdateCount, 0);
    rec0.put(QueryHistory.Item.Content, "Content[q0][c00][e000]");
    rec0.put(QueryHistory.Item.EntryDateTime, entryTm0);

    EQUAL(history.getAll().size(), 1);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getByQueryId("q0").size(), 1);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q1").size(), 0);
    EQUAL(history.getByConnectionId("c00").size(), 1);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c01").size(), 0);
    EQUAL(history.getByConnectionId("c02").size(), 0);
    EQUAL(history.getByConnectionId("c10").size(), 0);
    EQUAL(history.getByConnectionId("c11").size(), 0);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 1);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByExecutionId("e000").size(), 1);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e001").size(), 0);
    EQUAL(history.getByExecutionId("e002").size(), 0);
    EQUAL(history.getByExecutionId("e010").size(), 0);
    EQUAL(history.getByExecutionId("e011").size(), 0);
    EQUAL(history.getByExecutionId("e020").size(), 0);
    EQUAL(history.getByExecutionId("e100").size(), 0);
    EQUAL(history.getByExecutionId("e110").size(), 0);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e001").size(), 0);
    EQUAL(history.getByExecutionId("c00","e002").size(), 0);
    EQUAL(history.getByExecutionId("c01","e010").size(), 0);
    EQUAL(history.getByExecutionId("c01","e011").size(), 0);
    EQUAL(history.getByExecutionId("c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 0);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 0);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 0);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByIsSuccess(true).size(), 1);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(false).size(), 0);
    EQUAL(history.getByException(exc0), null);
    EQUAL(history.getByException(exc1), null);
    EQUAL(history.getByException(exc2), null);

    Map<QueryHistory.Item,Serializable> rec1 = history.appendNew();
    long entryTm1 = System.currentTimeMillis();
    rec1.put(QueryHistory.Item.QueryId, "q0");
    rec1.put(QueryHistory.Item.ConnectionId, "c00");
    rec1.put(QueryHistory.Item.ExecutionId, "e001");
    rec1.put(QueryHistory.Item.IsSuccess, true);
    //rec1.put(QueryHistory.Item.Exception, null);
    rec1.put(QueryHistory.Item.BeginTime, 22222L);
    rec1.put(QueryHistory.Item.EndTime, 33111L);
    rec1.put(QueryHistory.Item.SpentTime, 11000L);
    rec1.put(QueryHistory.Item.FetchCount, 0);
    rec1.put(QueryHistory.Item.UpdateCount, 10);
    rec1.put(QueryHistory.Item.Content, "Content[q0][c00][e001]");
    rec1.put(QueryHistory.Item.EntryDateTime, entryTm1);

    EQUAL(history.getAll().size(), 2);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getAll().get(1), rec1);
    EQUAL(history.getByQueryId("q0").size(), 2);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q0").get(1), rec1);
    EQUAL(history.getByQueryId("q1").size(), 0);
    EQUAL(history.getByConnectionId("c00").size(), 2);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c00").get(1), rec1);
    EQUAL(history.getByConnectionId("c01").size(), 0);
    EQUAL(history.getByConnectionId("c02").size(), 0);
    EQUAL(history.getByConnectionId("c10").size(), 0);
    EQUAL(history.getByConnectionId("c11").size(), 0);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 2);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c00").get(1), rec1);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByExecutionId("e000").size(), 1);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e001").size(), 1);
    EQUAL(history.getByExecutionId("e001").get(0), rec1);
    EQUAL(history.getByExecutionId("e002").size(), 0);
    EQUAL(history.getByExecutionId("e010").size(), 0);
    EQUAL(history.getByExecutionId("e011").size(), 0);
    EQUAL(history.getByExecutionId("e020").size(), 0);
    EQUAL(history.getByExecutionId("e100").size(), 0);
    EQUAL(history.getByExecutionId("e110").size(), 0);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("c00","e002").size(), 0);
    EQUAL(history.getByExecutionId("c01","e010").size(), 0);
    EQUAL(history.getByExecutionId("c01","e011").size(), 0);
    EQUAL(history.getByExecutionId("c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 0);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 0);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 0);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByIsSuccess(true).size(), 2);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(true).get(1), rec1);
    EQUAL(history.getByIsSuccess(false).size(), 0);
    EQUAL(history.getByException(exc0), null);
    EQUAL(history.getByException(exc1), null);
    EQUAL(history.getByException(exc2), null);

    Map<QueryHistory.Item,Serializable> rec2 = history.appendNew();
    long entryTm2 = System.currentTimeMillis();
    rec2.put(QueryHistory.Item.QueryId, "q0");
    rec2.put(QueryHistory.Item.ConnectionId, "c00");
    rec2.put(QueryHistory.Item.ExecutionId, "e002");
    rec2.put(QueryHistory.Item.IsSuccess, true);
    //rec2.put(QueryHistory.Item.Exception, null);
    rec2.put(QueryHistory.Item.BeginTime, 33333L);
    rec2.put(QueryHistory.Item.EndTime, 44411L);
    rec2.put(QueryHistory.Item.SpentTime, 11100L);
    rec2.put(QueryHistory.Item.FetchCount, 10);
    rec2.put(QueryHistory.Item.UpdateCount, 1);
    rec2.put(QueryHistory.Item.Content, "Content[q0][c00][e002]");
    rec2.put(QueryHistory.Item.EntryDateTime, entryTm2);

    EQUAL(history.getAll().size(), 3);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getAll().get(1), rec1);
    EQUAL(history.getAll().get(2), rec2);
    EQUAL(history.getByQueryId("q0").size(), 3);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q0").get(1), rec1);
    EQUAL(history.getByQueryId("q0").get(2), rec2);
    EQUAL(history.getByQueryId("q1").size(), 0);
    EQUAL(history.getByConnectionId("c00").size(), 3);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c00").get(1), rec1);
    EQUAL(history.getByConnectionId("c00").get(2), rec2);
    EQUAL(history.getByConnectionId("c01").size(), 0);
    EQUAL(history.getByConnectionId("c02").size(), 0);
    EQUAL(history.getByConnectionId("c10").size(), 0);
    EQUAL(history.getByConnectionId("c11").size(), 0);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c00").get(1), rec1);
    EQUAL(history.getByConnectionId("q0", "c00").get(2), rec2);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByExecutionId("e000").size(), 1);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e001").size(), 1);
    EQUAL(history.getByExecutionId("e001").get(0), rec1);
    EQUAL(history.getByExecutionId("e002").size(), 1);
    EQUAL(history.getByExecutionId("e002").get(0), rec2);
    EQUAL(history.getByExecutionId("e010").size(), 0);
    EQUAL(history.getByExecutionId("e011").size(), 0);
    EQUAL(history.getByExecutionId("e020").size(), 0);
    EQUAL(history.getByExecutionId("e100").size(), 0);
    EQUAL(history.getByExecutionId("e110").size(), 0);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("c01","e010").size(), 0);
    EQUAL(history.getByExecutionId("c01","e011").size(), 0);
    EQUAL(history.getByExecutionId("c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 0);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 0);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByIsSuccess(true).size(), 3);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(true).get(1), rec1);
    EQUAL(history.getByIsSuccess(true).get(2), rec2);
    EQUAL(history.getByIsSuccess(false).size(), 0);
    EQUAL(history.getByException(exc0), null);
    EQUAL(history.getByException(exc1), null);
    EQUAL(history.getByException(exc2), null);

    Map<QueryHistory.Item,Serializable> rec3 = history.appendNew();
    long entryTm3 = System.currentTimeMillis();
    rec3.put(QueryHistory.Item.QueryId, "q0");
    rec3.put(QueryHistory.Item.ConnectionId, "c01");
    rec3.put(QueryHistory.Item.ExecutionId, "e010");
    rec3.put(QueryHistory.Item.IsSuccess, false);
    rec3.put(QueryHistory.Item.Exception, exc0);
    rec3.put(QueryHistory.Item.BeginTime, 44444L);
    rec3.put(QueryHistory.Item.EndTime, 54444L);
    rec3.put(QueryHistory.Item.SpentTime, 10000L);
    rec3.put(QueryHistory.Item.FetchCount, 1);
    rec3.put(QueryHistory.Item.UpdateCount, 0);
    rec3.put(QueryHistory.Item.Content, "Content[q0][c01][e010]");
    rec3.put(QueryHistory.Item.EntryDateTime, entryTm3);

    EQUAL(history.getAll().size(), 4);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getAll().get(1), rec1);
    EQUAL(history.getAll().get(2), rec2);
    EQUAL(history.getAll().get(3), rec3);
    EQUAL(history.getByQueryId("q0").size(), 4);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q0").get(1), rec1);
    EQUAL(history.getByQueryId("q0").get(2), rec2);
    EQUAL(history.getByQueryId("q0").get(3), rec3);
    EQUAL(history.getByQueryId("q1").size(), 0);
    EQUAL(history.getByConnectionId("c00").size(), 3);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c00").get(1), rec1);
    EQUAL(history.getByConnectionId("c00").get(2), rec2);
    EQUAL(history.getByConnectionId("c01").size(), 1);
    EQUAL(history.getByConnectionId("c01").get(0), rec3);
    EQUAL(history.getByConnectionId("c02").size(), 0);
    EQUAL(history.getByConnectionId("c10").size(), 0);
    EQUAL(history.getByConnectionId("c11").size(), 0);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c00").get(1), rec1);
    EQUAL(history.getByConnectionId("q0", "c00").get(2), rec2);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 1);
    EQUAL(history.getByConnectionId("q0", "c01").get(0), rec3);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByExecutionId("e000").size(), 1);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e001").size(), 1);
    EQUAL(history.getByExecutionId("e001").get(0), rec1);
    EQUAL(history.getByExecutionId("e002").size(), 1);
    EQUAL(history.getByExecutionId("e002").get(0), rec2);
    EQUAL(history.getByExecutionId("e010").size(), 1);
    EQUAL(history.getByExecutionId("e010").get(0), rec3);
    EQUAL(history.getByExecutionId("e011").size(), 0);
    EQUAL(history.getByExecutionId("e020").size(), 0);
    EQUAL(history.getByExecutionId("e100").size(), 0);
    EQUAL(history.getByExecutionId("e110").size(), 0);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("c01","e011").size(), 0);
    EQUAL(history.getByExecutionId("c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 0);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByIsSuccess(true).size(), 3);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(true).get(1), rec1);
    EQUAL(history.getByIsSuccess(true).get(2), rec2);
    EQUAL(history.getByIsSuccess(false).size(), 1);
    EQUAL(history.getByIsSuccess(false).get(0), rec3);
    EQUAL(history.getByException(exc0), rec3);
    EQUAL(history.getByException(exc1), null);
    EQUAL(history.getByException(exc2), null);

    Map<QueryHistory.Item,Serializable> rec4 = history.appendNew();
    long entryTm4 = System.currentTimeMillis();
    rec4.put(QueryHistory.Item.QueryId, "q0");
    rec4.put(QueryHistory.Item.ConnectionId, "c01");
    rec4.put(QueryHistory.Item.ExecutionId, "e011");
    rec4.put(QueryHistory.Item.IsSuccess, true);
    rec4.put(QueryHistory.Item.Exception, null);
    rec4.put(QueryHistory.Item.BeginTime, 55555L);
    rec4.put(QueryHistory.Item.EndTime, 66555L);
    rec4.put(QueryHistory.Item.SpentTime, 11000L);
    rec4.put(QueryHistory.Item.FetchCount, 10);
    rec4.put(QueryHistory.Item.UpdateCount, 100);
    rec4.put(QueryHistory.Item.Content, "Content[q0][c01][e011]");
    rec4.put(QueryHistory.Item.EntryDateTime, entryTm4);

    EQUAL(history.getAll().size(), 5);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getAll().get(1), rec1);
    EQUAL(history.getAll().get(2), rec2);
    EQUAL(history.getAll().get(3), rec3);
    EQUAL(history.getAll().get(4), rec4);
    EQUAL(history.getByQueryId("q0").size(), 5);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q0").get(1), rec1);
    EQUAL(history.getByQueryId("q0").get(2), rec2);
    EQUAL(history.getByQueryId("q0").get(3), rec3);
    EQUAL(history.getByQueryId("q0").get(4), rec4);
    EQUAL(history.getByQueryId("q1").size(), 0);
    EQUAL(history.getByConnectionId("c00").size(), 3);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c00").get(1), rec1);
    EQUAL(history.getByConnectionId("c00").get(2), rec2);
    EQUAL(history.getByConnectionId("c01").size(), 2);
    EQUAL(history.getByConnectionId("c01").get(0), rec3);
    EQUAL(history.getByConnectionId("c01").get(1), rec4);
    EQUAL(history.getByConnectionId("c02").size(), 0);
    EQUAL(history.getByConnectionId("c10").size(), 0);
    EQUAL(history.getByConnectionId("c11").size(), 0);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c00").get(1), rec1);
    EQUAL(history.getByConnectionId("q0", "c00").get(2), rec2);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 2);
    EQUAL(history.getByConnectionId("q0", "c01").get(0), rec3);
    EQUAL(history.getByConnectionId("q0", "c01").get(1), rec4);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByExecutionId("e000").size(), 1);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e001").size(), 1);
    EQUAL(history.getByExecutionId("e001").get(0), rec1);
    EQUAL(history.getByExecutionId("e002").size(), 1);
    EQUAL(history.getByExecutionId("e002").get(0), rec2);
    EQUAL(history.getByExecutionId("e010").size(), 1);
    EQUAL(history.getByExecutionId("e010").get(0), rec3);
    EQUAL(history.getByExecutionId("e011").size(), 1);
    EQUAL(history.getByExecutionId("e011").get(0), rec4);
    EQUAL(history.getByExecutionId("e020").size(), 0);
    EQUAL(history.getByExecutionId("e100").size(), 0);
    EQUAL(history.getByExecutionId("e110").size(), 0);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 0);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByIsSuccess(true).size(), 4);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(true).get(1), rec1);
    EQUAL(history.getByIsSuccess(true).get(2), rec2);
    EQUAL(history.getByIsSuccess(true).get(3), rec4);
    EQUAL(history.getByIsSuccess(false).size(), 1);
    EQUAL(history.getByIsSuccess(false).get(0), rec3);
    EQUAL(history.getByException(exc0), rec3);
    EQUAL(history.getByException(exc1), null);
    EQUAL(history.getByException(exc2), null);

    Map<QueryHistory.Item,Serializable> rec5 = history.appendNew();
    long entryTm5 = System.currentTimeMillis();
    rec5.put(QueryHistory.Item.QueryId, "q0");
    rec5.put(QueryHistory.Item.ConnectionId, "c02");
    rec5.put(QueryHistory.Item.ExecutionId, "e020");
    rec5.put(QueryHistory.Item.IsSuccess, false);
    rec5.put(QueryHistory.Item.Exception, exc1);
    rec5.put(QueryHistory.Item.BeginTime, 66666L);
    rec5.put(QueryHistory.Item.EndTime, 77766L);
    rec5.put(QueryHistory.Item.SpentTime, 11100L);
    rec5.put(QueryHistory.Item.FetchCount, 11);
    rec5.put(QueryHistory.Item.UpdateCount, 111);
    rec5.put(QueryHistory.Item.Content, "Content[q0][c02][e020]");
    rec5.put(QueryHistory.Item.EntryDateTime, entryTm5);

    EQUAL(history.getAll().size(), 6);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getAll().get(1), rec1);
    EQUAL(history.getAll().get(2), rec2);
    EQUAL(history.getAll().get(3), rec3);
    EQUAL(history.getAll().get(4), rec4);
    EQUAL(history.getAll().get(5), rec5);
    EQUAL(history.getByQueryId("q0").size(), 6);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q0").get(1), rec1);
    EQUAL(history.getByQueryId("q0").get(2), rec2);
    EQUAL(history.getByQueryId("q0").get(3), rec3);
    EQUAL(history.getByQueryId("q0").get(4), rec4);
    EQUAL(history.getByQueryId("q0").get(5), rec5);
    EQUAL(history.getByQueryId("q1").size(), 0);
    EQUAL(history.getByConnectionId("c00").size(), 3);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c00").get(1), rec1);
    EQUAL(history.getByConnectionId("c00").get(2), rec2);
    EQUAL(history.getByConnectionId("c01").size(), 2);
    EQUAL(history.getByConnectionId("c01").get(0), rec3);
    EQUAL(history.getByConnectionId("c01").get(1), rec4);
    EQUAL(history.getByConnectionId("c02").size(), 1);
    EQUAL(history.getByConnectionId("c02").get(0), rec5);
    EQUAL(history.getByConnectionId("c10").size(), 0);
    EQUAL(history.getByConnectionId("c11").size(), 0);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c00").get(1), rec1);
    EQUAL(history.getByConnectionId("q0", "c00").get(2), rec2);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 2);
    EQUAL(history.getByConnectionId("q0", "c01").get(0), rec3);
    EQUAL(history.getByConnectionId("q0", "c01").get(1), rec4);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 1);
    EQUAL(history.getByConnectionId("q0", "c02").get(0), rec5);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByExecutionId("e000").size(), 1);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e001").size(), 1);
    EQUAL(history.getByExecutionId("e001").get(0), rec1);
    EQUAL(history.getByExecutionId("e002").size(), 1);
    EQUAL(history.getByExecutionId("e002").get(0), rec2);
    EQUAL(history.getByExecutionId("e010").size(), 1);
    EQUAL(history.getByExecutionId("e010").get(0), rec3);
    EQUAL(history.getByExecutionId("e011").size(), 1);
    EQUAL(history.getByExecutionId("e011").get(0), rec4);
    EQUAL(history.getByExecutionId("e020").size(), 1);
    EQUAL(history.getByExecutionId("e020").get(0), rec5);
    EQUAL(history.getByExecutionId("e100").size(), 0);
    EQUAL(history.getByExecutionId("e110").size(), 0);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("q0","c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 0);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByIsSuccess(true).size(), 4);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(true).get(1), rec1);
    EQUAL(history.getByIsSuccess(true).get(2), rec2);
    EQUAL(history.getByIsSuccess(true).get(3), rec4);
    EQUAL(history.getByIsSuccess(false).size(), 2);
    EQUAL(history.getByIsSuccess(false).get(0), rec3);
    EQUAL(history.getByIsSuccess(false).get(1), rec5);
    EQUAL(history.getByException(exc0), rec3);
    EQUAL(history.getByException(exc1), rec5);
    EQUAL(history.getByException(exc2), null);

    Map<QueryHistory.Item,Serializable> rec6 = history.appendNew();
    long entryTm6 = System.currentTimeMillis();
    rec6.put(QueryHistory.Item.QueryId, "q1");
    rec6.put(QueryHistory.Item.ConnectionId, "c10");
    rec6.put(QueryHistory.Item.ExecutionId, "e100");
    rec6.put(QueryHistory.Item.IsSuccess, true);
    //rec6.put(QueryHistory.Item.Exception, null);
    rec6.put(QueryHistory.Item.BeginTime, 77777L);
    rec6.put(QueryHistory.Item.EndTime, 87777L);
    rec6.put(QueryHistory.Item.SpentTime, 10000L);
    rec6.put(QueryHistory.Item.FetchCount, 0);
    rec6.put(QueryHistory.Item.UpdateCount, 1);
    rec6.put(QueryHistory.Item.Content, "Content[q1][c10][e100]");
    rec6.put(QueryHistory.Item.EntryDateTime, entryTm6);

    EQUAL(history.getAll().size(), 7);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getAll().get(1), rec1);
    EQUAL(history.getAll().get(2), rec2);
    EQUAL(history.getAll().get(3), rec3);
    EQUAL(history.getAll().get(4), rec4);
    EQUAL(history.getAll().get(5), rec5);
    EQUAL(history.getAll().get(6), rec6);
    EQUAL(history.getByQueryId("q0").size(), 6);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q0").get(1), rec1);
    EQUAL(history.getByQueryId("q0").get(2), rec2);
    EQUAL(history.getByQueryId("q0").get(3), rec3);
    EQUAL(history.getByQueryId("q0").get(4), rec4);
    EQUAL(history.getByQueryId("q0").get(5), rec5);
    EQUAL(history.getByQueryId("q1").size(), 1);
    EQUAL(history.getByQueryId("q1").get(0), rec6);
    EQUAL(history.getByConnectionId("c00").size(), 3);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c00").get(1), rec1);
    EQUAL(history.getByConnectionId("c00").get(2), rec2);
    EQUAL(history.getByConnectionId("c01").size(), 2);
    EQUAL(history.getByConnectionId("c01").get(0), rec3);
    EQUAL(history.getByConnectionId("c01").get(1), rec4);
    EQUAL(history.getByConnectionId("c02").size(), 1);
    EQUAL(history.getByConnectionId("c02").get(0), rec5);
    EQUAL(history.getByConnectionId("c10").size(), 1);
    EQUAL(history.getByConnectionId("c10").get(0), rec6);
    EQUAL(history.getByConnectionId("c11").size(), 0);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c00").get(1), rec1);
    EQUAL(history.getByConnectionId("q0", "c00").get(2), rec2);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 2);
    EQUAL(history.getByConnectionId("q0", "c01").get(0), rec3);
    EQUAL(history.getByConnectionId("q0", "c01").get(1), rec4);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 1);
    EQUAL(history.getByConnectionId("q0", "c02").get(0), rec5);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c10").get(0), rec6);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByExecutionId("e000").size(), 1);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e001").size(), 1);
    EQUAL(history.getByExecutionId("e001").get(0), rec1);
    EQUAL(history.getByExecutionId("e002").size(), 1);
    EQUAL(history.getByExecutionId("e002").get(0), rec2);
    EQUAL(history.getByExecutionId("e010").size(), 1);
    EQUAL(history.getByExecutionId("e010").get(0), rec3);
    EQUAL(history.getByExecutionId("e011").size(), 1);
    EQUAL(history.getByExecutionId("e011").get(0), rec4);
    EQUAL(history.getByExecutionId("e020").size(), 1);
    EQUAL(history.getByExecutionId("e020").get(0), rec5);
    EQUAL(history.getByExecutionId("e100").size(), 1);
    EQUAL(history.getByExecutionId("e100").get(0), rec6);
    EQUAL(history.getByExecutionId("e110").size(), 0);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("q0","c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("q1","c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 0);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByIsSuccess(true).size(), 5);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(true).get(1), rec1);
    EQUAL(history.getByIsSuccess(true).get(2), rec2);
    EQUAL(history.getByIsSuccess(true).get(3), rec4);
    EQUAL(history.getByIsSuccess(true).get(4), rec6);
    EQUAL(history.getByIsSuccess(false).size(), 2);
    EQUAL(history.getByIsSuccess(false).get(0), rec3);
    EQUAL(history.getByIsSuccess(false).get(1), rec5);
    EQUAL(history.getByException(exc0), rec3);
    EQUAL(history.getByException(exc1), rec5);
    EQUAL(history.getByException(exc2), null);

    Map<QueryHistory.Item,Serializable> rec7 = history.appendNew();
    long entryTm7 = System.currentTimeMillis();
    rec7.put(QueryHistory.Item.QueryId, "q1");
    rec7.put(QueryHistory.Item.ConnectionId, "c11");
    rec7.put(QueryHistory.Item.ExecutionId, "e110");
    rec7.put(QueryHistory.Item.IsSuccess, true);
    //rec7.put(QueryHistory.Item.Exception, null);
    rec7.put(QueryHistory.Item.BeginTime, 88888L);
    rec7.put(QueryHistory.Item.EndTime, 99888L);
    rec7.put(QueryHistory.Item.SpentTime, 11000L);
    rec7.put(QueryHistory.Item.FetchCount, 0);
    rec7.put(QueryHistory.Item.UpdateCount, 1);
    rec7.put(QueryHistory.Item.Content, "Content[q1][c11][e110]");
    rec7.put(QueryHistory.Item.EntryDateTime, entryTm7);

    EQUAL(history.getAll().size(), 8);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getAll().get(1), rec1);
    EQUAL(history.getAll().get(2), rec2);
    EQUAL(history.getAll().get(3), rec3);
    EQUAL(history.getAll().get(4), rec4);
    EQUAL(history.getAll().get(5), rec5);
    EQUAL(history.getAll().get(6), rec6);
    EQUAL(history.getAll().get(7), rec7);
    EQUAL(history.getByQueryId("q0").size(), 6);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q0").get(1), rec1);
    EQUAL(history.getByQueryId("q0").get(2), rec2);
    EQUAL(history.getByQueryId("q0").get(3), rec3);
    EQUAL(history.getByQueryId("q0").get(4), rec4);
    EQUAL(history.getByQueryId("q0").get(5), rec5);
    EQUAL(history.getByQueryId("q1").size(), 2);
    EQUAL(history.getByQueryId("q1").get(0), rec6);
    EQUAL(history.getByQueryId("q1").get(1), rec7);
    EQUAL(history.getByConnectionId("c00").size(), 3);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c00").get(1), rec1);
    EQUAL(history.getByConnectionId("c00").get(2), rec2);
    EQUAL(history.getByConnectionId("c01").size(), 2);
    EQUAL(history.getByConnectionId("c01").get(0), rec3);
    EQUAL(history.getByConnectionId("c01").get(1), rec4);
    EQUAL(history.getByConnectionId("c02").size(), 1);
    EQUAL(history.getByConnectionId("c02").get(0), rec5);
    EQUAL(history.getByConnectionId("c10").size(), 1);
    EQUAL(history.getByConnectionId("c10").get(0), rec6);
    EQUAL(history.getByConnectionId("c11").size(), 1);
    EQUAL(history.getByConnectionId("c11").get(0), rec7);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c00").get(1), rec1);
    EQUAL(history.getByConnectionId("q0", "c00").get(2), rec2);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 2);
    EQUAL(history.getByConnectionId("q0", "c01").get(0), rec3);
    EQUAL(history.getByConnectionId("q0", "c01").get(1), rec4);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 1);
    EQUAL(history.getByConnectionId("q0", "c02").get(0), rec5);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c10").get(0), rec6);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c11").get(0), rec7);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByExecutionId("e000").size(), 1);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e001").size(), 1);
    EQUAL(history.getByExecutionId("e001").get(0), rec1);
    EQUAL(history.getByExecutionId("e002").size(), 1);
    EQUAL(history.getByExecutionId("e002").get(0), rec2);
    EQUAL(history.getByExecutionId("e010").size(), 1);
    EQUAL(history.getByExecutionId("e010").get(0), rec3);
    EQUAL(history.getByExecutionId("e011").size(), 1);
    EQUAL(history.getByExecutionId("e011").get(0), rec4);
    EQUAL(history.getByExecutionId("e020").size(), 1);
    EQUAL(history.getByExecutionId("e020").get(0), rec5);
    EQUAL(history.getByExecutionId("e100").size(), 1);
    EQUAL(history.getByExecutionId("e100").get(0), rec6);
    EQUAL(history.getByExecutionId("e110").size(), 1);
    EQUAL(history.getByExecutionId("e110").get(0), rec7);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("c11","e110").size(), 1);
    EQUAL(history.getByExecutionId("c11","e110").get(0), rec7);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("q0","c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("q1","c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 1);
    EQUAL(history.getByExecutionId("q1","c11","e110").get(0), rec7);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByIsSuccess(true).size(), 6);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(true).get(1), rec1);
    EQUAL(history.getByIsSuccess(true).get(2), rec2);
    EQUAL(history.getByIsSuccess(true).get(3), rec4);
    EQUAL(history.getByIsSuccess(true).get(4), rec6);
    EQUAL(history.getByIsSuccess(true).get(5), rec7);
    EQUAL(history.getByIsSuccess(false).size(), 2);
    EQUAL(history.getByIsSuccess(false).get(0), rec3);
    EQUAL(history.getByIsSuccess(false).get(1), rec5);
    EQUAL(history.getByException(exc0), rec3);
    EQUAL(history.getByException(exc1), rec5);
    EQUAL(history.getByException(exc2), null);

    Map<QueryHistory.Item,Serializable> rec8 = history.appendNew();
    long entryTm8 = System.currentTimeMillis();
    rec8.put(QueryHistory.Item.QueryId, "q1");
    rec8.put(QueryHistory.Item.ConnectionId, "c00");
    rec8.put(QueryHistory.Item.ExecutionId, "e000");
    rec8.put(QueryHistory.Item.IsSuccess, true);
    //rec8.put(QueryHistory.Item.Exception, null);
    rec8.put(QueryHistory.Item.BeginTime, 99999L);
    rec8.put(QueryHistory.Item.EndTime, 199999L);
    rec8.put(QueryHistory.Item.SpentTime, 100000L);
    rec8.put(QueryHistory.Item.FetchCount, 2);
    rec8.put(QueryHistory.Item.UpdateCount, 0);
    rec8.put(QueryHistory.Item.Content, "Content[q1][c00][e001]");
    rec8.put(QueryHistory.Item.EntryDateTime, entryTm8);

    EQUAL(history.getAll().size(), 9);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getAll().get(1), rec1);
    EQUAL(history.getAll().get(2), rec2);
    EQUAL(history.getAll().get(3), rec3);
    EQUAL(history.getAll().get(4), rec4);
    EQUAL(history.getAll().get(5), rec5);
    EQUAL(history.getAll().get(6), rec6);
    EQUAL(history.getAll().get(7), rec7);
    EQUAL(history.getAll().get(8), rec8);
    EQUAL(history.getByQueryId("q0").size(), 6);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q0").get(1), rec1);
    EQUAL(history.getByQueryId("q0").get(2), rec2);
    EQUAL(history.getByQueryId("q0").get(3), rec3);
    EQUAL(history.getByQueryId("q0").get(4), rec4);
    EQUAL(history.getByQueryId("q0").get(5), rec5);
    EQUAL(history.getByQueryId("q1").size(), 3);
    EQUAL(history.getByQueryId("q1").get(0), rec6);
    EQUAL(history.getByQueryId("q1").get(1), rec7);
    EQUAL(history.getByQueryId("q1").get(2), rec8);
    EQUAL(history.getByConnectionId("c00").size(), 4);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c00").get(1), rec1);
    EQUAL(history.getByConnectionId("c00").get(2), rec2);
    EQUAL(history.getByConnectionId("c00").get(3), rec8);
    EQUAL(history.getByConnectionId("c01").size(), 2);
    EQUAL(history.getByConnectionId("c01").get(0), rec3);
    EQUAL(history.getByConnectionId("c01").get(1), rec4);
    EQUAL(history.getByConnectionId("c02").size(), 1);
    EQUAL(history.getByConnectionId("c02").get(0), rec5);
    EQUAL(history.getByConnectionId("c10").size(), 1);
    EQUAL(history.getByConnectionId("c10").get(0), rec6);
    EQUAL(history.getByConnectionId("c11").size(), 1);
    EQUAL(history.getByConnectionId("c11").get(0), rec7);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c00").get(1), rec1);
    EQUAL(history.getByConnectionId("q0", "c00").get(2), rec2);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 2);
    EQUAL(history.getByConnectionId("q0", "c01").get(0), rec3);
    EQUAL(history.getByConnectionId("q0", "c01").get(1), rec4);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 1);
    EQUAL(history.getByConnectionId("q0", "c02").get(0), rec5);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c10").get(0), rec6);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c11").get(0), rec7);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c00").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c00").get(0), rec8);
    EQUAL(history.getByExecutionId("e000").size(), 2);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e000").get(1), rec8);
    EQUAL(history.getByExecutionId("e001").size(), 1);
    EQUAL(history.getByExecutionId("e001").get(0), rec1);
    EQUAL(history.getByExecutionId("e002").size(), 1);
    EQUAL(history.getByExecutionId("e002").get(0), rec2);
    EQUAL(history.getByExecutionId("e010").size(), 1);
    EQUAL(history.getByExecutionId("e010").get(0), rec3);
    EQUAL(history.getByExecutionId("e011").size(), 1);
    EQUAL(history.getByExecutionId("e011").get(0), rec4);
    EQUAL(history.getByExecutionId("e020").size(), 1);
    EQUAL(history.getByExecutionId("e020").get(0), rec5);
    EQUAL(history.getByExecutionId("e100").size(), 1);
    EQUAL(history.getByExecutionId("e100").get(0), rec6);
    EQUAL(history.getByExecutionId("e110").size(), 1);
    EQUAL(history.getByExecutionId("e110").get(0), rec7);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 2);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e000").get(1), rec8);
    EQUAL(history.getByExecutionId("c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("c11","e110").size(), 1);
    EQUAL(history.getByExecutionId("c11","e110").get(0), rec7);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("q0","c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("q1","c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 1);
    EQUAL(history.getByExecutionId("q1","c11","e110").get(0), rec7);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("q1","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q1","c00","e000").get(0), rec8);
    EQUAL(history.getByIsSuccess(true).size(), 7);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(true).get(1), rec1);
    EQUAL(history.getByIsSuccess(true).get(2), rec2);
    EQUAL(history.getByIsSuccess(true).get(3), rec4);
    EQUAL(history.getByIsSuccess(true).get(4), rec6);
    EQUAL(history.getByIsSuccess(true).get(5), rec7);
    EQUAL(history.getByIsSuccess(true).get(6), rec8);
    EQUAL(history.getByIsSuccess(false).size(), 2);
    EQUAL(history.getByIsSuccess(false).get(0), rec3);
    EQUAL(history.getByIsSuccess(false).get(1), rec5);
    EQUAL(history.getByException(exc0), rec3);
    EQUAL(history.getByException(exc1), rec5);
    EQUAL(history.getByException(exc2), null);

    Map<QueryHistory.Item,Serializable> rec9 = history.appendNew();
    long entryTm9 = System.currentTimeMillis();
    rec9.put(QueryHistory.Item.QueryId, "q0");
    rec9.put(QueryHistory.Item.ConnectionId, "c01");
    rec9.put(QueryHistory.Item.ExecutionId, "e000");
    rec9.put(QueryHistory.Item.IsSuccess, true);
    //rec9.put(QueryHistory.Item.Exception, null);
    rec9.put(QueryHistory.Item.BeginTime, 111111L);
    rec9.put(QueryHistory.Item.EndTime, 121111L);
    rec9.put(QueryHistory.Item.SpentTime, 100000L);
    rec9.put(QueryHistory.Item.FetchCount, 2);
    rec9.put(QueryHistory.Item.UpdateCount, 0);
    rec9.put(QueryHistory.Item.Content, "Content[q0][c01][e000]");
    rec9.put(QueryHistory.Item.EntryDateTime, entryTm9);

    EQUAL(history.getAll().size(), 10);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getAll().get(1), rec1);
    EQUAL(history.getAll().get(2), rec2);
    EQUAL(history.getAll().get(3), rec3);
    EQUAL(history.getAll().get(4), rec4);
    EQUAL(history.getAll().get(5), rec5);
    EQUAL(history.getAll().get(6), rec6);
    EQUAL(history.getAll().get(7), rec7);
    EQUAL(history.getAll().get(8), rec8);
    EQUAL(history.getAll().get(9), rec9);
    EQUAL(history.getByQueryId("q0").size(), 7);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q0").get(1), rec1);
    EQUAL(history.getByQueryId("q0").get(2), rec2);
    EQUAL(history.getByQueryId("q0").get(3), rec3);
    EQUAL(history.getByQueryId("q0").get(4), rec4);
    EQUAL(history.getByQueryId("q0").get(5), rec5);
    EQUAL(history.getByQueryId("q0").get(6), rec9);
    EQUAL(history.getByQueryId("q1").size(), 3);
    EQUAL(history.getByQueryId("q1").get(0), rec6);
    EQUAL(history.getByQueryId("q1").get(1), rec7);
    EQUAL(history.getByQueryId("q1").get(2), rec8);
    EQUAL(history.getByConnectionId("c00").size(), 4);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c00").get(1), rec1);
    EQUAL(history.getByConnectionId("c00").get(2), rec2);
    EQUAL(history.getByConnectionId("c00").get(3), rec8);
    EQUAL(history.getByConnectionId("c01").size(), 3);
    EQUAL(history.getByConnectionId("c01").get(0), rec3);
    EQUAL(history.getByConnectionId("c01").get(1), rec4);
    EQUAL(history.getByConnectionId("c01").get(2), rec9);
    EQUAL(history.getByConnectionId("c02").size(), 1);
    EQUAL(history.getByConnectionId("c02").get(0), rec5);
    EQUAL(history.getByConnectionId("c10").size(), 1);
    EQUAL(history.getByConnectionId("c10").get(0), rec6);
    EQUAL(history.getByConnectionId("c11").size(), 1);
    EQUAL(history.getByConnectionId("c11").get(0), rec7);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c00").get(1), rec1);
    EQUAL(history.getByConnectionId("q0", "c00").get(2), rec2);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c01").get(0), rec3);
    EQUAL(history.getByConnectionId("q0", "c01").get(1), rec4);
    EQUAL(history.getByConnectionId("q0", "c01").get(2), rec9);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 1);
    EQUAL(history.getByConnectionId("q0", "c02").get(0), rec5);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c10").get(0), rec6);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c11").get(0), rec7);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c00").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c00").get(0), rec8);
    EQUAL(history.getByExecutionId("e000").size(), 3);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e000").get(1), rec8);
    EQUAL(history.getByExecutionId("e000").get(2), rec9);
    EQUAL(history.getByExecutionId("e001").size(), 1);
    EQUAL(history.getByExecutionId("e001").get(0), rec1);
    EQUAL(history.getByExecutionId("e002").size(), 1);
    EQUAL(history.getByExecutionId("e002").get(0), rec2);
    EQUAL(history.getByExecutionId("e010").size(), 1);
    EQUAL(history.getByExecutionId("e010").get(0), rec3);
    EQUAL(history.getByExecutionId("e011").size(), 1);
    EQUAL(history.getByExecutionId("e011").get(0), rec4);
    EQUAL(history.getByExecutionId("e020").size(), 1);
    EQUAL(history.getByExecutionId("e020").get(0), rec5);
    EQUAL(history.getByExecutionId("e100").size(), 1);
    EQUAL(history.getByExecutionId("e100").get(0), rec6);
    EQUAL(history.getByExecutionId("e110").size(), 1);
    EQUAL(history.getByExecutionId("e110").get(0), rec7);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 2);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e000").get(1), rec8);
    EQUAL(history.getByExecutionId("c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("c01","e000").size(), 1);
    EQUAL(history.getByExecutionId("c01","e000").get(0), rec9);
    EQUAL(history.getByExecutionId("c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("c11","e110").size(), 1);
    EQUAL(history.getByExecutionId("c11","e110").get(0), rec7);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("q0","c01","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e000").get(0), rec9);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("q0","c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("q1","c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 1);
    EQUAL(history.getByExecutionId("q1","c11","e110").get(0), rec7);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("q1","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q1","c00","e000").get(0), rec8);
    EQUAL(history.getByIsSuccess(true).size(), 8);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(true).get(1), rec1);
    EQUAL(history.getByIsSuccess(true).get(2), rec2);
    EQUAL(history.getByIsSuccess(true).get(3), rec4);
    EQUAL(history.getByIsSuccess(true).get(4), rec6);
    EQUAL(history.getByIsSuccess(true).get(5), rec7);
    EQUAL(history.getByIsSuccess(true).get(6), rec8);
    EQUAL(history.getByIsSuccess(true).get(7), rec9);
    EQUAL(history.getByIsSuccess(false).size(), 2);
    EQUAL(history.getByIsSuccess(false).get(0), rec3);
    EQUAL(history.getByIsSuccess(false).get(1), rec5);
    EQUAL(history.getByException(exc0), rec3);
    EQUAL(history.getByException(exc1), rec5);
    EQUAL(history.getByException(exc2), null);

    rec9.put(IQueryHistory.Item.Exception, exc2);

    EQUAL(history.getAll().size(), 10);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getAll().get(1), rec1);
    EQUAL(history.getAll().get(2), rec2);
    EQUAL(history.getAll().get(3), rec3);
    EQUAL(history.getAll().get(4), rec4);
    EQUAL(history.getAll().get(5), rec5);
    EQUAL(history.getAll().get(6), rec6);
    EQUAL(history.getAll().get(7), rec7);
    EQUAL(history.getAll().get(8), rec8);
    EQUAL(history.getAll().get(9), rec9);
    EQUAL(history.getByQueryId("q0").size(), 7);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q0").get(1), rec1);
    EQUAL(history.getByQueryId("q0").get(2), rec2);
    EQUAL(history.getByQueryId("q0").get(3), rec3);
    EQUAL(history.getByQueryId("q0").get(4), rec4);
    EQUAL(history.getByQueryId("q0").get(5), rec5);
    EQUAL(history.getByQueryId("q0").get(6), rec9);
    EQUAL(history.getByQueryId("q1").size(), 3);
    EQUAL(history.getByQueryId("q1").get(0), rec6);
    EQUAL(history.getByQueryId("q1").get(1), rec7);
    EQUAL(history.getByQueryId("q1").get(2), rec8);
    EQUAL(history.getByConnectionId("c00").size(), 4);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c00").get(1), rec1);
    EQUAL(history.getByConnectionId("c00").get(2), rec2);
    EQUAL(history.getByConnectionId("c00").get(3), rec8);
    EQUAL(history.getByConnectionId("c01").size(), 3);
    EQUAL(history.getByConnectionId("c01").get(0), rec3);
    EQUAL(history.getByConnectionId("c01").get(1), rec4);
    EQUAL(history.getByConnectionId("c01").get(2), rec9);
    EQUAL(history.getByConnectionId("c02").size(), 1);
    EQUAL(history.getByConnectionId("c02").get(0), rec5);
    EQUAL(history.getByConnectionId("c10").size(), 1);
    EQUAL(history.getByConnectionId("c10").get(0), rec6);
    EQUAL(history.getByConnectionId("c11").size(), 1);
    EQUAL(history.getByConnectionId("c11").get(0), rec7);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c00").get(1), rec1);
    EQUAL(history.getByConnectionId("q0", "c00").get(2), rec2);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c01").get(0), rec3);
    EQUAL(history.getByConnectionId("q0", "c01").get(1), rec4);
    EQUAL(history.getByConnectionId("q0", "c01").get(2), rec9);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 1);
    EQUAL(history.getByConnectionId("q0", "c02").get(0), rec5);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c10").get(0), rec6);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c11").get(0), rec7);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c00").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c00").get(0), rec8);
    EQUAL(history.getByExecutionId("e000").size(), 3);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e000").get(1), rec8);
    EQUAL(history.getByExecutionId("e000").get(2), rec9);
    EQUAL(history.getByExecutionId("e001").size(), 1);
    EQUAL(history.getByExecutionId("e001").get(0), rec1);
    EQUAL(history.getByExecutionId("e002").size(), 1);
    EQUAL(history.getByExecutionId("e002").get(0), rec2);
    EQUAL(history.getByExecutionId("e010").size(), 1);
    EQUAL(history.getByExecutionId("e010").get(0), rec3);
    EQUAL(history.getByExecutionId("e011").size(), 1);
    EQUAL(history.getByExecutionId("e011").get(0), rec4);
    EQUAL(history.getByExecutionId("e020").size(), 1);
    EQUAL(history.getByExecutionId("e020").get(0), rec5);
    EQUAL(history.getByExecutionId("e100").size(), 1);
    EQUAL(history.getByExecutionId("e100").get(0), rec6);
    EQUAL(history.getByExecutionId("e110").size(), 1);
    EQUAL(history.getByExecutionId("e110").get(0), rec7);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 2);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e000").get(1), rec8);
    EQUAL(history.getByExecutionId("c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("c01","e000").size(), 1);
    EQUAL(history.getByExecutionId("c01","e000").get(0), rec9);
    EQUAL(history.getByExecutionId("c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("c11","e110").size(), 1);
    EQUAL(history.getByExecutionId("c11","e110").get(0), rec7);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("q0","c01","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e000").get(0), rec9);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("q0","c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("q1","c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 1);
    EQUAL(history.getByExecutionId("q1","c11","e110").get(0), rec7);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("q1","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q1","c00","e000").get(0), rec8);
    EQUAL(history.getByIsSuccess(true).size(), 8);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(true).get(1), rec1);
    EQUAL(history.getByIsSuccess(true).get(2), rec2);
    EQUAL(history.getByIsSuccess(true).get(3), rec4);
    EQUAL(history.getByIsSuccess(true).get(4), rec6);
    EQUAL(history.getByIsSuccess(true).get(5), rec7);
    EQUAL(history.getByIsSuccess(true).get(6), rec8);
    EQUAL(history.getByIsSuccess(true).get(7), rec9);
    EQUAL(history.getByIsSuccess(false).size(), 2);
    EQUAL(history.getByIsSuccess(false).get(0), rec3);
    EQUAL(history.getByIsSuccess(false).get(1), rec5);
    EQUAL(history.getByException(exc0), rec3);
    EQUAL(history.getByException(exc1), rec5);
    EQUAL(history.getByException(exc2), rec9);

    rec9.put(QueryHistory.Item.QueryId, "q1");
    rec9.put(QueryHistory.Item.ConnectionId, "c11");
    rec9.put(QueryHistory.Item.ExecutionId, "e000");

    EQUAL(history.getAll().size(), 10);
    EQUAL(history.getAll().get(0), rec0);
    EQUAL(history.getAll().get(1), rec1);
    EQUAL(history.getAll().get(2), rec2);
    EQUAL(history.getAll().get(3), rec3);
    EQUAL(history.getAll().get(4), rec4);
    EQUAL(history.getAll().get(5), rec5);
    EQUAL(history.getAll().get(6), rec6);
    EQUAL(history.getAll().get(7), rec7);
    EQUAL(history.getAll().get(8), rec8);
    EQUAL(history.getAll().get(9), rec9);
    EQUAL(history.getByQueryId("q0").size(), 6);
    EQUAL(history.getByQueryId("q0").get(0), rec0);
    EQUAL(history.getByQueryId("q0").get(1), rec1);
    EQUAL(history.getByQueryId("q0").get(2), rec2);
    EQUAL(history.getByQueryId("q0").get(3), rec3);
    EQUAL(history.getByQueryId("q0").get(4), rec4);
    EQUAL(history.getByQueryId("q0").get(5), rec5);
    EQUAL(history.getByQueryId("q1").size(), 4);
    EQUAL(history.getByQueryId("q1").get(0), rec6);
    EQUAL(history.getByQueryId("q1").get(1), rec7);
    EQUAL(history.getByQueryId("q1").get(2), rec8);
    EQUAL(history.getByQueryId("q1").get(3), rec9);
    EQUAL(history.getByConnectionId("c00").size(), 4);
    EQUAL(history.getByConnectionId("c00").get(0), rec0);
    EQUAL(history.getByConnectionId("c00").get(1), rec1);
    EQUAL(history.getByConnectionId("c00").get(2), rec2);
    EQUAL(history.getByConnectionId("c00").get(3), rec8);
    EQUAL(history.getByConnectionId("c01").size(), 2);
    EQUAL(history.getByConnectionId("c01").get(0), rec3);
    EQUAL(history.getByConnectionId("c01").get(1), rec4);
    EQUAL(history.getByConnectionId("c02").size(), 1);
    EQUAL(history.getByConnectionId("c02").get(0), rec5);
    EQUAL(history.getByConnectionId("c10").size(), 1);
    EQUAL(history.getByConnectionId("c10").get(0), rec6);
    EQUAL(history.getByConnectionId("c11").size(), 2);
    EQUAL(history.getByConnectionId("c11").get(0), rec7);
    EQUAL(history.getByConnectionId("c11").get(1), rec9);
    EQUAL(history.getByConnectionId("c12").size(), 0);
    EQUAL(history.getByConnectionId("c20").size(), 0);
    EQUAL(history.getByConnectionId("c21").size(), 0);
    EQUAL(history.getByConnectionId("c22").size(), 0);
    EQUAL(history.getByConnectionId("q0", "c00").size(), 3);
    EQUAL(history.getByConnectionId("q0", "c00").get(0), rec0);
    EQUAL(history.getByConnectionId("q0", "c00").get(1), rec1);
    EQUAL(history.getByConnectionId("q0", "c00").get(2), rec2);
    EQUAL(history.getByConnectionId("q0", "c01").size(), 2);
    EQUAL(history.getByConnectionId("q0", "c01").get(0), rec3);
    EQUAL(history.getByConnectionId("q0", "c01").get(1), rec4);
    EQUAL(history.getByConnectionId("q0", "c02").size(), 1);
    EQUAL(history.getByConnectionId("q0", "c02").get(0), rec5);
    EQUAL(history.getByConnectionId("q1", "c10").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c10").get(0), rec6);
    EQUAL(history.getByConnectionId("q1", "c11").size(), 2);
    EQUAL(history.getByConnectionId("q1", "c11").get(0), rec7);
    EQUAL(history.getByConnectionId("q1", "c11").get(1), rec9);
    EQUAL(history.getByConnectionId("q1", "c12").size(), 0);
    EQUAL(history.getByConnectionId("q1", "c00").size(), 1);
    EQUAL(history.getByConnectionId("q1", "c00").get(0), rec8);
    EQUAL(history.getByExecutionId("e000").size(), 3);
    EQUAL(history.getByExecutionId("e000").get(0), rec0);
    EQUAL(history.getByExecutionId("e000").get(1), rec8);
    EQUAL(history.getByExecutionId("e000").get(2), rec9);
    EQUAL(history.getByExecutionId("e001").size(), 1);
    EQUAL(history.getByExecutionId("e001").get(0), rec1);
    EQUAL(history.getByExecutionId("e002").size(), 1);
    EQUAL(history.getByExecutionId("e002").get(0), rec2);
    EQUAL(history.getByExecutionId("e010").size(), 1);
    EQUAL(history.getByExecutionId("e010").get(0), rec3);
    EQUAL(history.getByExecutionId("e011").size(), 1);
    EQUAL(history.getByExecutionId("e011").get(0), rec4);
    EQUAL(history.getByExecutionId("e020").size(), 1);
    EQUAL(history.getByExecutionId("e020").get(0), rec5);
    EQUAL(history.getByExecutionId("e100").size(), 1);
    EQUAL(history.getByExecutionId("e100").get(0), rec6);
    EQUAL(history.getByExecutionId("e110").size(), 1);
    EQUAL(history.getByExecutionId("e110").get(0), rec7);
    EQUAL(history.getByExecutionId("e120").size(), 0);
    EQUAL(history.getByExecutionId("e200").size(), 0);
    EQUAL(history.getByExecutionId("e210").size(), 0);
    EQUAL(history.getByExecutionId("e220").size(), 0);
    EQUAL(history.getByExecutionId("c00","e000").size(), 2);
    EQUAL(history.getByExecutionId("c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("c00","e000").get(1), rec8);
    EQUAL(history.getByExecutionId("c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("c11","e110").size(), 1);
    EQUAL(history.getByExecutionId("c11","e110").get(0), rec7);
    EQUAL(history.getByExecutionId("c11","e000").size(), 1);
    EQUAL(history.getByExecutionId("c11","e000").get(0), rec9);
    EQUAL(history.getByExecutionId("c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("c20","e200").size(), 0);
    EQUAL(history.getByExecutionId("c21","e210").size(), 0);
    EQUAL(history.getByExecutionId("c22","e220").size(), 0);
    EQUAL(history.getByExecutionId("q0","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e000").get(0), rec0);
    EQUAL(history.getByExecutionId("q0","c00","e001").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e001").get(0), rec1);
    EQUAL(history.getByExecutionId("q0","c00","e002").size(), 1);
    EQUAL(history.getByExecutionId("q0","c00","e002").get(0), rec2);
    EQUAL(history.getByExecutionId("q0","c01","e010").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e010").get(0), rec3);
    EQUAL(history.getByExecutionId("q0","c01","e011").size(), 1);
    EQUAL(history.getByExecutionId("q0","c01","e011").get(0), rec4);
    EQUAL(history.getByExecutionId("q0","c02","e020").size(), 1);
    EQUAL(history.getByExecutionId("q0","c02","e020").get(0), rec5);
    EQUAL(history.getByExecutionId("q1","c10","e100").size(), 1);
    EQUAL(history.getByExecutionId("q1","c10","e100").get(0), rec6);
    EQUAL(history.getByExecutionId("q1","c11","e110").size(), 1);
    EQUAL(history.getByExecutionId("q1","c11","e110").get(0), rec7);
    EQUAL(history.getByExecutionId("q1","c11","e000").size(), 1);
    EQUAL(history.getByExecutionId("q1","c11","e000").get(0), rec9);
    EQUAL(history.getByExecutionId("q1","c12","e120").size(), 0);
    EQUAL(history.getByExecutionId("q1","c00","e000").size(), 1);
    EQUAL(history.getByExecutionId("q1","c00","e000").get(0), rec8);
    EQUAL(history.getByIsSuccess(true).size(), 8);
    EQUAL(history.getByIsSuccess(true).get(0), rec0);
    EQUAL(history.getByIsSuccess(true).get(1), rec1);
    EQUAL(history.getByIsSuccess(true).get(2), rec2);
    EQUAL(history.getByIsSuccess(true).get(3), rec4);
    EQUAL(history.getByIsSuccess(true).get(4), rec6);
    EQUAL(history.getByIsSuccess(true).get(5), rec7);
    EQUAL(history.getByIsSuccess(true).get(6), rec8);
    EQUAL(history.getByIsSuccess(true).get(7), rec9);
    EQUAL(history.getByIsSuccess(false).size(), 2);
    EQUAL(history.getByIsSuccess(false).get(0), rec3);
    EQUAL(history.getByIsSuccess(false).get(1), rec5);
    EQUAL(history.getByException(exc0), rec3);
    EQUAL(history.getByException(exc1), rec5);
    EQUAL(history.getByException(exc2), rec9);
  }
}
