package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import java.io.*;
import java.util.*;

public class QueryEnvironmentTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryEnvironmentTest.class, args);
  }

  @Override
  protected void preTesting()
  {
    QueryEnvironment.getInstance();
  }

  @Override
  protected void preInvocation(String method)
  {
    ResourceBundle.clearCache();
  }

  public void getInstance()
  {
    MSG("シングルトン・オブジェクトを取得するメソッドの確認。");

    QueryEnvironment env0 = QueryEnvironment.getInstance();
    QueryEnvironment env1 = QueryEnvironment.getInstance();
    QueryEnvironment env2 = QueryEnvironment.getInstance();

    EQUAL(env0, env1);
    EQUAL(env0, env2);

    NOTNULL(env0.getConfig());
  }

  public void getConnectionConfigDirectory()
  {
    MSG("接続設定ファイル格納ディレクトリを取得するメソッドの確認。");

    QueryEnvironment env = QueryEnvironment.getInstance();
    EQUAL(env.getConnectionConfigDirectory(),
      new File("test/data/ts/query/configs/connection/"));
  }

  public void getExecutionConfigDirectory()
  {
    MSG("実行設定ファイル格納ディレクトリを取得するメソッドの確認。");

    QueryEnvironment env = QueryEnvironment.getInstance();
    EQUAL(env.getExecutionConfigDirectory(),
      new File("test/data/ts/query/configs/execution/"));
  }

  public void getQueryConfigDirectory()
  {
    MSG("実行設定ファイル格納ディレクトリを取得するメソッドの確認。");

    QueryEnvironment env = QueryEnvironment.getInstance();
    EQUAL(env.getQueryConfigDirectory(),
      new File("test/data/ts/query/configs/query/"));
  }
}
