/*
 * IQuery class.
 *
 * Copyright (C) 2012 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.query;

import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;
import java.util.Map;

/**
 * １つのまとまったクエリを表すクラスのインターフェイス。
 * <br>
 * 任意の接続先に対する一つ又は複数の照会や更新からなるクエリを処理し、結果を
 * {@link IQueryResult}に格納して返す。
 *
 * @author 佐藤隆之
 * @version $Id: IQuery.java,v 1.5 2012-02-28 15:51:16 tayu Exp $
 */
public interface IQuery
{
  /**
   * このオブジェクトが表すクエリを実行する。
   * 実行結果は、{@link QueryResult}オブジェクトに格納して返す。
   *
   * @param inputMap 入力パラメータ・マップ。
   * @return クエリの実行結果を格納した{@link QueryResult}オブジェクト。
   * @throws ReasonedException クエリの実行に失敗した場合。
   * @throws ReasonedRuntimeException クエリを実行するための設定等に誤りがあった
   *   場合。
   */
  IQueryResult execute(Map<String,Object> inputMap)
    throws ReasonedException, ReasonedRuntimeException;

  /**
   * クエリの実行履歴を取得する。
   *
   * @return {@link IQueryHistory}オブジェクト。
   */
  IQueryHistory getQueryHistory();
}
