/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ts.query.IQuery;
import ts.query.IQueryConnection;
import ts.query.IQueryExecution;
import ts.query.IQueryHistory;
import ts.query.IQueryTransaction;
import ts.query.IQueryTransactionManager;
import ts.query.QueryTransaction;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;

public class QueryTransactionManager
implements IQueryTransactionManager {
    private static final ThreadLocal<IQueryTransaction> THREAD_LOCAL = new ThreadLocal();
    private static final Map<String, IQueryTransaction> TRANSACTION_MAP = new HashMap<String, IQueryTransaction>();

    QueryTransactionManager() {
    }

    @Override
    public IQueryTransaction createThreadLocalTransaction() throws ReasonedRuntimeException {
        return this.createThreadLocalTransaction(QueryTransaction.class);
    }

    @Override
    public IQueryTransaction createThreadLocalTransaction(Class<? extends IQueryTransaction> clazz) throws ReasonedRuntimeException {
        IQueryTransaction iQueryTransaction = THREAD_LOCAL.get();
        if (iQueryTransaction != null && iQueryTransaction.getState() != IQueryTransaction.State.Ended) {
            throw new ReasonedRuntimeException((Enum)IQueryTransactionManager.Error.ThreadLocalAlreadyExists, "[transaction class=" + iQueryTransaction.getClass().getName() + "]");
        }
        if (clazz == null) {
            throw new ReasonedRuntimeException((Enum)IQueryTransactionManager.Error.FailToCreateThreadLocal, "[transaction class=null]");
        }
        try {
            THREAD_LOCAL.set(clazz.newInstance());
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)IQueryTransactionManager.Error.FailToCreateThreadLocal, "[transaction class=" + clazz.getName() + "]", (Throwable)exception);
        }
        return new ThreadLocalTransaction();
    }

    @Override
    public IQueryTransaction getThreadLocalTransaction() {
        return new ThreadLocalTransaction();
    }

    @Override
    public IQueryTransaction createThreadSafeTransaction(String string) throws ReasonedRuntimeException {
        return this.createThreadSafeTransaction(string, QueryTransaction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQueryTransaction createThreadSafeTransaction(String string, Class<? extends IQueryTransaction> clazz) throws ReasonedRuntimeException {
        assert (string != null && clazz != null) : string == null ? "@param:key is null." : (clazz == null ? "@param:tranClass is null." : "");
        Map<String, IQueryTransaction> map = TRANSACTION_MAP;
        synchronized (map) {
            IQueryTransaction iQueryTransaction = TRANSACTION_MAP.get(string);
            if (iQueryTransaction != null && iQueryTransaction.getState() != IQueryTransaction.State.Ended) {
                throw new ReasonedRuntimeException((Enum)IQueryTransactionManager.Error.ThreadSafeAlreadyExists, "[transaction class=" + iQueryTransaction.getClass().getName() + "]");
            }
            try {
                TRANSACTION_MAP.put(string, clazz.newInstance());
            }
            catch (Exception exception) {
                throw new ReasonedRuntimeException((Enum)IQueryTransactionManager.Error.FailToCreateThreadSafe, "[transaction class=" + clazz.getName() + "]", (Throwable)exception);
            }
            return new ThreadSafeTransaction(string);
        }
    }

    @Override
    public IQueryTransaction getThreadSafeTransaction(String string) {
        return new ThreadSafeTransaction(string);
    }

    private static final class ThreadSafeQueryHistory
    implements IQueryHistory {
        static final long serialVersionUID = 2962083979616856555L;
        private final IQueryHistory inner;

        ThreadSafeQueryHistory(IQueryHistory iQueryHistory) {
            this.inner = iQueryHistory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<IQueryHistory.Item, Serializable> appendNew() {
            IQueryHistory iQueryHistory = this.inner;
            synchronized (iQueryHistory) {
                return this.inner.appendNew();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Map<IQueryHistory.Item, Serializable>> getAll() {
            IQueryHistory iQueryHistory = this.inner;
            synchronized (iQueryHistory) {
                return this.inner.getAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Map<IQueryHistory.Item, Serializable>> getByQueryId(String string) {
            IQueryHistory iQueryHistory = this.inner;
            synchronized (iQueryHistory) {
                return this.inner.getByQueryId(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Map<IQueryHistory.Item, Serializable>> getByConnectionId(String string) {
            IQueryHistory iQueryHistory = this.inner;
            synchronized (iQueryHistory) {
                return this.inner.getByConnectionId(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Map<IQueryHistory.Item, Serializable>> getByConnectionId(String string, String string2) {
            IQueryHistory iQueryHistory = this.inner;
            synchronized (iQueryHistory) {
                return this.inner.getByConnectionId(string, string2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Map<IQueryHistory.Item, Serializable>> getByExecutionId(String string) {
            IQueryHistory iQueryHistory = this.inner;
            synchronized (iQueryHistory) {
                return this.inner.getByExecutionId(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Map<IQueryHistory.Item, Serializable>> getByExecutionId(String string, String string2) {
            IQueryHistory iQueryHistory = this.inner;
            synchronized (iQueryHistory) {
                return this.inner.getByExecutionId(string, string2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Map<IQueryHistory.Item, Serializable>> getByExecutionId(String string, String string2, String string3) {
            IQueryHistory iQueryHistory = this.inner;
            synchronized (iQueryHistory) {
                return this.inner.getByExecutionId(string, string2, string3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Map<IQueryHistory.Item, Serializable>> getByIsSuccess(boolean bl) {
            IQueryHistory iQueryHistory = this.inner;
            synchronized (iQueryHistory) {
                return this.inner.getByIsSuccess(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<IQueryHistory.Item, Serializable> getByException(ReasonedException reasonedException) {
            IQueryHistory iQueryHistory = this.inner;
            synchronized (iQueryHistory) {
                return this.inner.getByException(reasonedException);
            }
        }
    }

    private static final class ThreadSafeTransaction
    implements IQueryTransaction {
        private final String key;
        private final IQueryTransaction transaction;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ThreadSafeTransaction(String string) throws ReasonedRuntimeException {
            Map map = TRANSACTION_MAP;
            synchronized (map) {
                IQueryTransaction iQueryTransaction = (IQueryTransaction)TRANSACTION_MAP.get(string);
                if (iQueryTransaction == null) {
                    throw new ReasonedRuntimeException((Enum)IQueryTransactionManager.Error.ThreadSafeNotExist, "[key=" + string + "]");
                }
                this.key = string;
                this.transaction = iQueryTransaction;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void begin() throws ReasonedException, ReasonedRuntimeException {
            IQueryTransaction iQueryTransaction = this.transaction;
            synchronized (iQueryTransaction) {
                this.transaction.begin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() throws ReasonedException, ReasonedRuntimeException {
            IQueryTransaction iQueryTransaction = this.transaction;
            synchronized (iQueryTransaction) {
                this.transaction.commit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() throws ReasonedRuntimeException {
            IQueryTransaction iQueryTransaction = this.transaction;
            synchronized (iQueryTransaction) {
                this.transaction.rollback();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void end() throws ReasonedRuntimeException {
            Object object = TRANSACTION_MAP;
            synchronized (object) {
                IQueryTransaction iQueryTransaction = (IQueryTransaction)TRANSACTION_MAP.get(this.key);
                if (iQueryTransaction != null && iQueryTransaction.equals(this.transaction)) {
                    TRANSACTION_MAP.remove(this.key);
                }
            }
            object = this.transaction;
            synchronized (object) {
                this.transaction.end();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IQueryTransaction.State getState() {
            IQueryTransaction iQueryTransaction = this.transaction;
            synchronized (iQueryTransaction) {
                return this.transaction.getState();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getBeginTimeMillis() {
            IQueryTransaction iQueryTransaction = this.transaction;
            synchronized (iQueryTransaction) {
                return this.transaction.getBeginTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLimitTimeMillis() {
            IQueryTransaction iQueryTransaction = this.transaction;
            synchronized (iQueryTransaction) {
                return this.transaction.getLimitTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimeoutMillis(long l) {
            IQueryTransaction iQueryTransaction = this.transaction;
            synchronized (iQueryTransaction) {
                this.transaction.setTimeoutMillis(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getTimeoutMillis() {
            IQueryTransaction iQueryTransaction = this.transaction;
            synchronized (iQueryTransaction) {
                return this.transaction.getTimeoutMillis();
            }
        }

        @Override
        public IQueryHistory getQueryHistory() {
            return new ThreadSafeQueryHistory(this.transaction.getQueryHistory());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IQueryConnection getQueryConnection(String string) throws ReasonedException, ReasonedRuntimeException {
            IQueryTransaction iQueryTransaction = this.transaction;
            synchronized (iQueryTransaction) {
                return this.transaction.getQueryConnection(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IQueryExecution getQueryExecution(String string) throws ReasonedException, ReasonedRuntimeException {
            IQueryTransaction iQueryTransaction = this.transaction;
            synchronized (iQueryTransaction) {
                return this.transaction.getQueryExecution(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IQuery getQuery(String string) throws ReasonedException, ReasonedRuntimeException {
            IQueryTransaction iQueryTransaction = this.transaction;
            synchronized (iQueryTransaction) {
                return this.transaction.getQuery(string);
            }
        }

        public int hashCode() {
            return this.transaction.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ThreadSafeTransaction)) {
                return false;
            }
            ThreadSafeTransaction threadSafeTransaction = (ThreadSafeTransaction)ThreadSafeTransaction.class.cast(object);
            return this.transaction.equals(threadSafeTransaction.transaction);
        }
    }

    private static final class ThreadLocalTransaction
    implements IQueryTransaction {
        private final IQueryTransaction transaction;

        ThreadLocalTransaction() throws ReasonedRuntimeException {
            IQueryTransaction iQueryTransaction = (IQueryTransaction)THREAD_LOCAL.get();
            if (iQueryTransaction == null) {
                throw new ReasonedRuntimeException((Enum)IQueryTransactionManager.Error.ThreadLocalNotExist);
            }
            this.transaction = iQueryTransaction;
        }

        IQueryTransaction getInner() {
            if (this.transaction == THREAD_LOCAL.get()) {
                return this.transaction;
            }
            if (this.transaction.getState() == IQueryTransaction.State.Ended) {
                return this.transaction;
            }
            if (THREAD_LOCAL.get() == null) {
                throw new ReasonedRuntimeException((Enum)IQueryTransactionManager.Error.ThreadLocalNotExist);
            }
            throw new ReasonedRuntimeException((Enum)IQueryTransactionManager.Error.ThreadLocalAlreadyDiscarded);
        }

        @Override
        public void begin() throws ReasonedException, ReasonedRuntimeException {
            this.getInner().begin();
        }

        @Override
        public void commit() throws ReasonedException, ReasonedRuntimeException {
            this.getInner().commit();
        }

        @Override
        public void rollback() throws ReasonedRuntimeException {
            this.getInner().rollback();
        }

        @Override
        public void end() throws ReasonedRuntimeException {
            IQueryTransaction iQueryTransaction = this.getInner();
            THREAD_LOCAL.remove();
            iQueryTransaction.end();
        }

        @Override
        public IQueryTransaction.State getState() {
            return this.getInner().getState();
        }

        @Override
        public long getBeginTimeMillis() {
            return this.getInner().getBeginTimeMillis();
        }

        @Override
        public long getLimitTimeMillis() {
            return this.getInner().getLimitTimeMillis();
        }

        @Override
        public long getTimeoutMillis() {
            return this.getInner().getTimeoutMillis();
        }

        @Override
        public void setTimeoutMillis(long l) {
            this.getInner().setTimeoutMillis(l);
        }

        @Override
        public IQueryHistory getQueryHistory() {
            return this.getInner().getQueryHistory();
        }

        @Override
        public IQueryConnection getQueryConnection(String string) throws ReasonedException, ReasonedRuntimeException {
            return this.getInner().getQueryConnection(string);
        }

        @Override
        public IQueryExecution getQueryExecution(String string) throws ReasonedException, ReasonedRuntimeException {
            return this.getInner().getQueryExecution(string);
        }

        @Override
        public IQuery getQuery(String string) throws ReasonedException, ReasonedRuntimeException {
            return this.getInner().getQuery(string);
        }

        public int hashCode() {
            return this.getInner().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ThreadLocalTransaction)) {
                return false;
            }
            ThreadLocalTransaction threadLocalTransaction = (ThreadLocalTransaction)ThreadLocalTransaction.class.cast(object);
            return this.getInner().equals(threadLocalTransaction.getInner());
        }
    }
}

