/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ts.query.IQueryResult;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;
import ts.util.table.Table;

public class QueryResult
implements IQueryResult {
    static final long serialVersionUID = -6094683686497030260L;
    private final String queryId;
    private long beginTimeMillis = 0L;
    private long endTimeMillis = 0L;
    private ReasonedException exception = null;
    private final Map<String, Table<String, Serializable>> resultTableMap = this.newResultTableMap();

    public QueryResult(String string) {
        assert (string != null) : "@param:queryId is null.";
        this.queryId = string;
    }

    protected Map<String, Table<String, Serializable>> newResultTableMap() {
        return new HashMap<String, Table<String, Serializable>>();
    }

    @Override
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    public boolean isSuccess() {
        return this.exception == null;
    }

    @Override
    public ReasonedException getException() {
        return this.exception;
    }

    protected void setException(Exception exception) {
        if (exception == null) {
            this.exception = null;
        } else if (exception instanceof ReasonedException) {
            this.exception = (ReasonedException)((Object)ReasonedException.class.cast(exception));
        } else if (exception instanceof ReasonedRuntimeException) {
            ReasonedRuntimeException reasonedRuntimeException = (ReasonedRuntimeException)((Object)ReasonedRuntimeException.class.cast(exception));
            ReasonedException reasonedException = new ReasonedException(reasonedRuntimeException.getReason(), reasonedRuntimeException.getMessage(), (Throwable)reasonedRuntimeException);
            reasonedException.setStackTrace(reasonedRuntimeException.getStackTrace());
            this.exception = reasonedException;
        } else {
            ReasonedException reasonedException = new ReasonedException((Enum)IQueryResult.Error.FailToExecute, exception.getMessage(), (Throwable)exception);
            reasonedException.setStackTrace(exception.getStackTrace());
            this.exception = reasonedException;
        }
    }

    @Override
    public long getBeginTimeMillis() {
        return this.beginTimeMillis;
    }

    protected void setBeginTimeMillis(long l) {
        assert (l >= 0L) : "@param:tm is negative.";
        this.beginTimeMillis = l;
    }

    @Override
    public long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    protected void setEndTimeMillis(long l) {
        assert (l >= this.beginTimeMillis) : "@param:tm is less than begin time.";
        this.endTimeMillis = l;
    }

    @Override
    public long getSpentTimeMillis() {
        return Math.max(this.endTimeMillis - this.beginTimeMillis, 0L);
    }

    @Override
    public Collection<String> getAllResultIds() {
        return this.resultTableMap.keySet();
    }

    @Override
    public Table<String, Serializable> getResultTable(String string) {
        return this.resultTableMap.get(string);
    }

    protected Map<String, Table<String, Serializable>> getResultTableMap() {
        return this.resultTableMap;
    }
}

