/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import ts.query.IQueryConnection;
import ts.query.IQueryHistory;
import ts.query.IQueryTransaction;
import ts.query.QueryConnectionConfig;
import ts.query.QueryHistory;

public abstract class QueryConnection
implements IQueryConnection {
    private final QueryConnectionConfig config;
    private final QueryHistory history;
    private final long limitTimeMillis;

    protected QueryConnection(QueryConnectionConfig queryConnectionConfig) {
        assert (queryConnectionConfig != null) : "@param:config is null.";
        this.config = queryConnectionConfig;
        this.history = this.newQueryHistory();
        this.limitTimeMillis = 0L;
    }

    protected QueryConnection(QueryConnectionConfig queryConnectionConfig, IQueryTransaction iQueryTransaction) {
        assert (queryConnectionConfig != null) : "@param:config is null.";
        this.config = queryConnectionConfig;
        this.history = (QueryHistory)QueryHistory.class.cast(iQueryTransaction.getQueryHistory());
        this.limitTimeMillis = iQueryTransaction.getLimitTimeMillis();
    }

    protected QueryHistory newQueryHistory() {
        return new QueryHistory();
    }

    @Override
    public String getConnectionId() {
        return this.config.getConnectionId();
    }

    protected QueryConnectionConfig getConfig() {
        return this.config;
    }

    protected abstract long getOpenTimeMillis();

    @Override
    public long getLimitTimeMillis() {
        long l = this.getOpenTimeMillis();
        long l2 = this.getConfig().getLimitSpentTime();
        long l3 = this.limitTimeMillis;
        if (l <= 0L || l2 <= 0L) {
            return l3;
        }
        if (l3 <= 0L) {
            return l + l2;
        }
        return Math.min(l + l2, l3);
    }

    protected QueryHistory getQueryHistoryObject() {
        return this.history;
    }

    @Override
    public IQueryHistory getQueryHistory() {
        return this.getQueryHistoryObject();
    }
}

