/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import ts.query.IQuery;
import ts.query.IQueryConnection;
import ts.query.IQueryExecution;
import ts.query.IQueryHistory;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;

public interface IQueryTransaction {
    public void begin() throws ReasonedException, ReasonedRuntimeException;

    public void commit() throws ReasonedException, ReasonedRuntimeException;

    public void rollback() throws ReasonedRuntimeException;

    public void end() throws ReasonedRuntimeException;

    public State getState();

    public long getBeginTimeMillis();

    public long getLimitTimeMillis();

    public long getTimeoutMillis();

    public void setTimeoutMillis(long var1);

    public IQueryHistory getQueryHistory();

    public IQueryConnection getQueryConnection(String var1) throws ReasonedException, ReasonedRuntimeException;

    public IQueryExecution getQueryExecution(String var1) throws ReasonedException, ReasonedRuntimeException;

    public IQuery getQuery(String var1) throws ReasonedException, ReasonedRuntimeException;

    public static enum State {
        Created,
        Begining,
        Begined,
        Committing,
        Committed,
        Rollbacking,
        Rollbacked,
        Ending,
        Ended;

    }

    public static enum Error {
        IllegalState,
        QueryConnectionNotFound,
        FailToRollback,
        FailToEnd;

    }
}

