/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import ts.query.IQueryTransaction;
import ts.query.Query;
import ts.query.QueryConfig;
import ts.query.QueryEnvironment;
import ts.query.QueryExecutionConfig;
import ts.query.QueryResult;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;
import ts.util.TypedMap;
import ts.util.resource.Resource;
import ts.util.resource.XmlResource;
import ts.util.table.Table;
import ts.util.text.StringCutter;

public class ControllableQuery
extends Query {
    private Resource controlResource = this.loadControlResource();

    protected ControllableQuery(QueryConfig queryConfig) throws ReasonedRuntimeException {
        super(queryConfig);
    }

    protected ControllableQuery(QueryConfig queryConfig, IQueryTransaction iQueryTransaction) throws ReasonedRuntimeException {
        super(queryConfig, iQueryTransaction);
    }

    protected Resource loadControlResource() {
        QueryEnvironment queryEnvironment = QueryEnvironment.getInstance();
        File file = queryEnvironment.getQueryConfigDirectory();
        String string = this.getConfig().getResource().getFirstValue("ts-query.query.execution.control.xmlfile");
        if (string.isEmpty()) {
            return this.getConfig().getResource();
        }
        File file2 = new File(file, string);
        if (!file2.exists()) {
            throw new ReasonedRuntimeException((Enum)Error.QueryControlFileNotFound, "[path=" + file2.getAbsolutePath() + "]");
        }
        try {
            XmlResource xmlResource = new XmlResource();
            xmlResource.setValidating(false);
            xmlResource.load(file2.getCanonicalPath());
            return xmlResource;
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.FailToLoadQueryControlFile, "[path=" + file2.getAbsolutePath() + "]", (Throwable)exception);
        }
    }

    protected Resource getControlResource() {
        return this.controlResource;
    }

    @Override
    protected void executeQuery(Map<String, Object> map, QueryResult queryResult) throws ReasonedException, ReasonedRuntimeException {
        for (Resource resource : this.getControlResource().getChildren("ts-query.query.execution.control.*")) {
            this.controlExecution(resource, map, queryResult);
        }
    }

    protected void controlExecution(Resource resource, Map<String, Object> map, QueryResult queryResult) throws ReasonedException, ReasonedRuntimeException {
        String string = resource.getBaseElementName();
        if (string.equals("if")) {
            String string2 = resource.getFirstAttribute("", "param");
            String string3 = resource.getFirstAttribute("", "from");
            String string4 = resource.getFirstAttribute("", "exists");
            String string5 = resource.getFirstAttribute("", "equals");
            String string6 = resource.getFirstAttribute("", "notEqual");
            String string7 = resource.getFirstAttribute("", "contains");
            String string8 = resource.getFirstAttribute("", "notContains");
            String string9 = resource.getFirstAttribute("", "delimiter");
            String string10 = this.getParamValue(string2, string3, map, queryResult);
            if (!this.checkExistsCondition(string10, string4)) {
                return;
            }
            if (!this.checkEqualsCondition(string10, string5)) {
                return;
            }
            if (!this.checkNotEqualCondition(string10, string6)) {
                return;
            }
            if (!this.checkContainsCondition(string10, string7, string9)) {
                return;
            }
            if (!this.checkNotContainCondition(string10, string8, string9)) {
                return;
            }
            for (Resource resource2 : resource.getChildren("*")) {
                this.controlExecution(resource2, map, queryResult);
            }
        } else if (string.equals("id")) {
            String string11 = resource.getFirstValue("");
            QueryExecutionConfig queryExecutionConfig = new QueryExecutionConfig(string11);
            Object t = queryExecutionConfig.create(this.getTransaction());
            t.execute(map, queryResult);
        }
    }

    protected String getParamValue(String string, String string2, Map<String, Object> map, QueryResult queryResult) {
        Object object = null;
        if (!string2.isEmpty()) {
            Table<String, Serializable> table = queryResult.getResultTable(string2);
            if (table != null && table.recordCount() > 0) {
                object = table.recordFirst().get(string);
            }
        } else {
            object = map.get(string);
        }
        if (object == null) {
            return null;
        }
        TypedMap typedMap = new TypedMap();
        typedMap.put((Object)"", object);
        return typedMap.getString((Object)"");
    }

    protected boolean checkExistsCondition(String string, String string2) throws ReasonedRuntimeException {
        if (string2.isEmpty()) {
            return true;
        }
        if (string2.equals("true")) {
            return string != null;
        }
        if (string2.equals("false")) {
            return string == null;
        }
        throw new ReasonedRuntimeException((Enum)Error.IllegalAttributeValue, "[exists=" + string2 + "]");
    }

    protected boolean checkEqualsCondition(String string, String string2) {
        if (string2.isEmpty()) {
            return true;
        }
        return string2.equals(string);
    }

    protected boolean checkNotEqualCondition(String string, String string2) {
        if (string2.isEmpty()) {
            return true;
        }
        return !string2.equals(string);
    }

    protected boolean checkContainsCondition(String string, String string2, String string3) {
        if (string2.isEmpty()) {
            return true;
        }
        if (string3.isEmpty()) {
            return string2.equals(string);
        }
        List list = StringCutter.split((String)string2, (String)string3);
        return list.contains(string);
    }

    protected boolean checkNotContainCondition(String string, String string2, String string3) {
        if (string2.isEmpty()) {
            return true;
        }
        if (string3.isEmpty()) {
            return !string2.equals(string);
        }
        List list = StringCutter.split((String)string2, (String)string3);
        return !list.contains(string);
    }

    public static enum Error {
        QueryControlFileNotFound,
        FailToLoadQueryControlFile,
        IllegalAttributeValue;

    }
}

