/*
 * FileLastModifiedFilter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import java.io.File;
import java.io.FileFilter;
import java.util.Date;

/**
 * t@C̍ŏIXVƂt@CEtB^ENXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:46 $
 */
public class FileLastModifiedFilter implements FileFilter
{
  /** t@CŏIXV͈̏͂̊JnlB */
  private Date modifiedAfter_ = null;

  /** t@CŏIXV͈̏͂̏IlB */
  private Date modifiedBefore_ = null;

  /**
   * t@CŏIXV͈̔͂ɂƂRXgN^B
   * <br>
   * kݒ肵ꍇ́A̒lƂĎgpȂB
   * <br>
   * kłȂA͈͂̊JnlƏIl̎w肪tꍇ́A
   * ւĐݒ肷B
   *
   * @param  start t@CŏIXV͈̔͂̊JnlB 
   * @param  end t@CŏIXV͈̔͂̏IlB 
   */
  public FileLastModifiedFilter(Date start, Date end)
  {
    if (start != null && end != null) {
      if (start.before(end)) {
        modifiedAfter_ = start;
        modifiedBefore_ = end;
      }
      else {
        modifiedAfter_ = end;
        modifiedBefore_ = start;
      }
    }
    else {
      modifiedAfter_ = start;
      modifiedBefore_ = end;
    }
  }

  /**
   * w肳ꂽt@C̍ŏIXVÃIuWFNg̎ŏIXV
   * ͈͂ɊYiEl܂ށjǂ𔻒肷B
   *
   * @param  file Ώۂ̃t@CB
   * @return t@C̍XVYꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public boolean accept(File file)
  {
    assert (file != null) : "@param:file is null.";

    if (modifiedAfter_ != null) {
      if (file.lastModified() < modifiedAfter_.getTime()) {
        return false;
      }
    }

    if (modifiedBefore_ != null) {
      if (file.lastModified() > modifiedBefore_.getTime()) {
        return false;
      }
    }

    return true;
  }
}

