/*
 * DirectoryNotEmptyException class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import java.io.IOException;

/**
 * fBNgłȂꍇɃX[ONXB 
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:45 $
 */
public class DirectoryNotEmptyException extends IOException
{
  /** ̃NX̃VAo[WIDB */
  static final long serialVersionUID = -2111866153889457746L;

  /** fBNgpXB*/
  private String path_ ;

  /**
   * fBNgpXɂƂRXgN^B
   * <br>
   * ̃fBNgpXk̏ꍇÂ܂܎󂯕tB
   *
   * @param  path fBNgpXB
   */
  public DirectoryNotEmptyException(String path)
  {
    path_ = path;
  }

  /**
   * fBNgpXƗObZ[WɂƂRXgN^B
   * <br>
   * ̃fBNgpXk̏ꍇÂ܂܎󂯕tB
   * ̗ObZ[Wk̏ꍇÂ܂܎󂯕tB
   *
   * @param  path fBNgpXB
   * @param  msg ObZ[WB
   */
  public DirectoryNotEmptyException(String path, String msg)
  {
    super(msg);
    path_ = path;
  }

  /**
   * fBNgpX擾B
   *
   * @return fBNgpXB
   */
  public String getPath()
  {
    return path_ ;
  }

  /**
   * O̓e\擾B
   *
   * @return  O̓e\B
   */
  public String toString()
  {
    String s = getMessage();
    if (s == null) {
      s = "The directory is not empty";
    }
    return getClass().getName() + ": " + s + ": " + getPath();
  }
}
