/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ts.query.QueryResult;
import ts.util.ReasonedException;

public class QueryResultList
implements Serializable {
    private static final long serialVersionUID = 7570497809387060417L;
    private final List<QueryResult> resultLst = new LinkedList<QueryResult>();
    private final Map<String, List<QueryResult>> qid2RsltMap = new HashMap<String, List<QueryResult>>();
    private final Map<String, List<QueryResult>> cid2RsltMap = new HashMap<String, List<QueryResult>>();
    private final Map<ReasonedException, QueryResult> exc2RsltMap = new HashMap<ReasonedException, QueryResult>();
    private long spentTimeMillis = -1L;

    public void addResult(QueryResult queryResult) {
        assert (queryResult != null) : "@param:result is null.";
        this.resultLst.add(queryResult);
        this.entryMappedList(this.qid2RsltMap, queryResult.getQueryId(), queryResult);
        this.entryMappedList(this.cid2RsltMap, queryResult.getConnectionId(), queryResult);
        if (queryResult.getReasonedException() != null) {
            this.exc2RsltMap.put(queryResult.getReasonedException(), queryResult);
        }
    }

    protected void entryMappedList(Map<String, List<QueryResult>> map, String string, QueryResult queryResult) {
        List<QueryResult> list = map.get(string);
        if (list == null) {
            list = new LinkedList<QueryResult>();
            map.put(string, list);
        }
        list.add(queryResult);
    }

    public boolean isSuccess() {
        for (QueryResult queryResult : this.resultLst) {
            if (queryResult.isSuccess()) continue;
            return false;
        }
        return true;
    }

    public long getSpentTimeMillis() {
        if (this.spentTimeMillis >= 0L) {
            return this.spentTimeMillis;
        }
        long l = 0L;
        for (QueryResult queryResult : this.resultLst) {
            l += queryResult.getSpentTimeMillis();
        }
        return l;
    }

    public void setSpentTimeMillis(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("@param:millis is negative.");
        }
        this.spentTimeMillis = l;
    }

    public void resetSpentTimeMillis() {
        this.spentTimeMillis = -1L;
    }

    public int countResults() {
        return this.resultLst.size();
    }

    public List<QueryResult> getAllResults() {
        return Collections.unmodifiableList(this.resultLst);
    }

    public QueryResult getFirstResult() {
        if (this.resultLst.isEmpty()) {
            return null;
        }
        return this.resultLst.get(0);
    }

    public QueryResult getLastResult() {
        if (this.resultLst.isEmpty()) {
            return null;
        }
        return this.resultLst.get(this.resultLst.size() - 1);
    }

    public List<QueryResult> getResultsByConnectionId(String string) {
        List<QueryResult> list = this.cid2RsltMap.get(string);
        if (list == null) {
            list = Collections.emptyList();
            return list;
        }
        return Collections.unmodifiableList(list);
    }

    public QueryResult getFirstResultByConnectionId(String string) {
        List<QueryResult> list = this.cid2RsltMap.get(string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public QueryResult getLastResultByConnectionId(String string) {
        List<QueryResult> list = this.cid2RsltMap.get(string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public List<QueryResult> getResultsByQueryId(String string) {
        List<QueryResult> list = this.qid2RsltMap.get(string);
        if (list == null) {
            list = Collections.emptyList();
            return list;
        }
        return Collections.unmodifiableList(list);
    }

    public QueryResult getFirstResultByQueryId(String string) {
        List<QueryResult> list = this.qid2RsltMap.get(string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public QueryResult getLastResultByQueryId(String string) {
        List<QueryResult> list = this.qid2RsltMap.get(string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public QueryResult getResultByException(ReasonedException reasonedException) {
        return this.exc2RsltMap.get(reasonedException);
    }

    QueryResultList toThreadSafe() {
        return new ThreadSafeQueryResultList(this);
    }

    protected static class ThreadSafeQueryResultList
    extends QueryResultList {
        private static final long serialVersionUID = -1759409178810650333L;
        private final QueryResultList inner;

        public ThreadSafeQueryResultList(QueryResultList queryResultList) {
            this.inner = queryResultList;
        }

        protected QueryResultList getInner() {
            return this.inner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void addResult(QueryResult queryResult) {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                this.getInner().addResult(queryResult);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean isSuccess() {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().isSuccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized long getSpentTimeMillis() {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().getSpentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void setSpentTimeMillis(long l) {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                this.getInner().setSpentTimeMillis(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void resetSpentTimeMillis() {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                this.getInner().resetSpentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int countResults() {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().countResults();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized List<QueryResult> getAllResults() {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().getAllResults();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized QueryResult getFirstResult() {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().getFirstResult();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized QueryResult getLastResult() {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().getLastResult();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized List<QueryResult> getResultsByConnectionId(String string) {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().getResultsByConnectionId(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized QueryResult getFirstResultByConnectionId(String string) {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().getFirstResultByConnectionId(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized QueryResult getLastResultByConnectionId(String string) {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().getLastResultByConnectionId(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized List<QueryResult> getResultsByQueryId(String string) {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().getResultsByQueryId(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized QueryResult getFirstResultByQueryId(String string) {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().getFirstResultByQueryId(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized QueryResult getLastResultByQueryId(String string) {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().getLastResultByQueryId(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized QueryResult getResultByException(ReasonedException reasonedException) {
            QueryResultList queryResultList = this.inner;
            synchronized (queryResultList) {
                return this.getInner().getResultByException(reasonedException);
            }
        }

        @Override
        QueryResultList toThreadSafe() {
            return this;
        }
    }
}

